/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.XMLParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class CloudConfiguration
implements Serializable {
    private static final long serialVersionUID = 7797042435807673948L;
    private static Logger logger = Logger.getLogger(CloudConfiguration.class);
    private static final String CONFIG_FILE = "tmim_msgservice_config.xml";
    private String configFile;
    private static Map<String, Account> accountMap;

    public static CloudConfiguration getInstance() {
        return Instance.configuration;
    }

    private CloudConfiguration() {
        this((String)null);
    }

    public static Account getAcount(String companynumber) {
        return accountMap.get(companynumber);
    }

    private CloudConfiguration(String configFile) {
        this.configFile = configFile;
        accountMap = new HashMap<String, Account>();
        if (configFile == null || configFile.length() == 0) {
            String path = System.getProperty("EAS_HOME");
            this.configFile = path + "/server/profiles/server1/config/" + CONFIG_FILE;
        }
        try {
            this.init();
        }
        catch (BOSException e) {
            logger.error((Object)("\u91d1\u8776\u4e91\u914d\u7f6e\u521d\u59cb\u5316\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    public void init() throws BOSException {
        Element root = this.getRoot(this.configFile);
        Element accounts = root.getChild("accounts");
        List eleAccounts = accounts.getChildren();
        for (Element eleAccount : eleAccounts) {
            Account account = this.getAccount(eleAccount);
            accountMap.put(account.companynumber, account);
        }
    }

    private Element getRoot(String filePath) throws BOSException {
        InputStream is = null;
        try {
            Element root;
            is = new FileInputStream(new File(filePath));
            Document doc = XMLParser.parseXML((InputStream)is);
            Element element = root = doc.getRootElement();
            return element;
        }
        catch (FileNotFoundException e) {
            throw new BOSException("tmim_msgservice_config.xml not found\uff1a" + this.configFile);
        }
        catch (JDOMException e) {
            throw new BOSException("tmim_msgservice_config.xml parse error\uff1a" + e.getMessage());
        }
        catch (IOException e) {
            throw new BOSException("tmim_msgservice_config.xml read error\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Account getAccount(Element eleHandler) {
        Account handler = new Account();
        handler.companynumber = eleHandler.getChild("companynumber").getText();
        handler.companyname = eleHandler.getChild("companyname").getText();
        handler.tid = eleHandler.getChild("tid").getText();
        handler.username = eleHandler.getChild("username").getText();
        handler.password = eleHandler.getChild("password").getText();
        handler.client_id = eleHandler.getChild("client_id").getText();
        handler.client_secret = eleHandler.getChild("client_secret").getText();
        return handler;
    }

    public class Account
    implements Serializable {
        private static final long serialVersionUID = 8587991329119654816L;
        String companynumber;
        String companyname;
        String tid;
        String username;
        String password;
        String client_id;
        String client_secret;

        Account() {
        }

        public String getCompanynumber() {
            return this.companynumber;
        }

        public void setCompanynumber(String companynumber) {
            this.companynumber = companynumber;
        }

        public String getCompanyname() {
            return this.companyname;
        }

        public void setCompanyname(String companyname) {
            this.companyname = companyname;
        }

        public String getTid() {
            return this.tid;
        }

        public void setTid(String tid) {
            this.tid = tid;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getClient_id() {
            return this.client_id;
        }

        public void setClient_id(String client_id) {
            this.client_id = client_id;
        }

        public String getClient_secret() {
            return this.client_secret;
        }

        public void setClient_secret(String client_secret) {
            this.client_secret = client_secret;
        }
    }

    private static class Instance {
        private static CloudConfiguration configuration = new CloudConfiguration();

        private Instance() {
        }
    }
}

