/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.actionproxy;

import com.kingdee.bos.appframework.client.servicebinding.IActionService;
import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.UIActionMonitor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ForceExitException;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.service.PermissionService;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4ListUI;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class IMActionProxy
implements IItemAction {
    private Map services;
    private Map serviceContext;
    private IItemAction target;
    private static Logger logger = Logger.getLogger(IMActionProxy.class);

    public IMActionProxy(Map serviceContext, Map services, IItemAction target) {
        if (services != null) {
            this.services = new LinkedHashMap(services);
        }
        if (serviceContext != null) {
            this.serviceContext = new HashMap(serviceContext);
            this.serviceContext.put("ACTION", target);
        }
        this.target = target;
        this.initServices(this.target);
    }

    public void actionPerformed(ActionEvent e) {
        final ActionParams params = new ActionParams(this.target, e);
        if (params.action.isDaemonRun()) {
            final MonitorInfo info = new MonitorInfo(params.uiObject.getUITitle() + "-->" + params.action.getValue("ShortDescription"), null, (Object)params.uiObject, params.action.isDaemonDialog());
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    try {
                        if (IMActionProxy.this.target.isBatchAction()) {
                            IMActionProxy.this.target.actionPerformed(params.event);
                        } else {
                            IMActionProxy.this.actionPerformedInvoke(params);
                        }
                        return null;
                    }
                    catch (Throwable e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                params.uiObject.handUIException(e);
                            }
                        });
                        return null;
                    }
                }

                public void finished() {
                    ThreadPool.destroyMonitor((MonitorInfo)info);
                }
            };
            info.setWorker(worker);
            ThreadPool.addActionThread((MonitorInfo)info);
            ThreadPool.setBackgroundRunButtonEnabled((boolean)true);
        } else {
            try {
                if (this.target.isBatchAction()) {
                    this.target.actionPerformed(params.event);
                } else {
                    this.actionPerformedInvoke(params);
                }
            }
            catch (Throwable ex) {
                params.uiObject.handUIException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void actionPerformedInvoke(ActionParams params) throws Throwable {
        block29: {
            boolean isExcute = true;
            long startTime = System.currentTimeMillis();
            if (params.action == null) {
                return;
            }
            isExcute = params.action.beforeActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
            if (!isExcute) {
                return;
            }
            UIActionMonitor.startAction((String)params.uiName, (String)params.actionName);
            try {
                block28: {
                    if (params.action.getExtendProperty("Mutex") != null) {
                        Uuid uuid = Uuid.create();
                        params.action.putValue("NetUuid", (Object)uuid);
                    }
                    params.action.setActionEvent(params.event);
                    Class<?> coreUICalss = Class.forName("com.kingdee.eas.framework.client.CoreUI");
                    if (coreUICalss.isAssignableFrom(params.uiObject.getClass())) {
                        try {
                            Method method = params.uiObject.getClass().getMethod("prepareAction", IItemAction.class);
                            IUIActionPostman handler = (IUIActionPostman)method.invoke((Object)params.uiObject, this.target);
                            handler.callHandler();
                        }
                        catch (Exception ite) {
                            params.action.putValue("NetUuid", null);
                            if (ite.getCause() == null) {
                                params.uiObject.handUIException((Throwable)ite);
                                UIActionMonitor.endAction((String)params.uiName, (String)params.actionName, (long)(System.currentTimeMillis() - startTime));
                                return;
                            }
                            params.uiObject.handUIException(ite.getCause());
                            UIActionMonitor.endAction((String)params.uiName, (String)params.actionName, (long)(System.currentTimeMillis() - startTime));
                            return;
                        }
                    }
                    if (this.serviceContext != null) {
                        this.serviceContext.put("ACTION", this.target);
                    }
                    try {
                        if (this.services != null) {
                            this.beforeAction();
                        }
                        logger.info((Object)("ItemActionJDKHandler[BEFORE PointCut] actionName: " + params.actionName));
                        this.target.actionPerformed(params.event);
                        if (params.action != null && params.event != null) {
                            params.action.afterActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
                        }
                        if (this.services != null) {
                            if (this.target instanceof ItemAction) {
                                if (this.target != null && !((ItemAction)this.target).isInvokeFailed()) {
                                    this.afterAction();
                                }
                            } else {
                                this.afterAction();
                            }
                        }
                        logger.info((Object)("ItemActionJDKHandler[AFTER PointCut] actionName: " + params.actionName));
                        if (params.action == null || params.event == null) break block28;
                    }
                    catch (ForceExitException forceExitException) {
                        if (params.action != null && params.event != null) {
                            params.action.finallyActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
                        }
                        params.action.putValue("NetUuid", null);
                        if (this.services != null) {
                            this.finalAction();
                        }
                        this.serviceContext.remove("ACTION");
                        logger.info((Object)("ItemActionJDKHandler[FINAL PointCut] actionName: " + params.actionName));
                        break block29;
                        catch (Throwable throwable) {
                            if (params.action != null && params.event != null) {
                                params.action.finallyActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
                            }
                            params.action.putValue("NetUuid", null);
                            if (this.services != null) {
                                this.finalAction();
                            }
                            this.serviceContext.remove("ACTION");
                            logger.info((Object)("ItemActionJDKHandler[FINAL PointCut] actionName: " + params.actionName));
                            throw throwable;
                        }
                    }
                    params.action.finallyActionPerformed((CoreUIObject)params.uiObject, params.actionName, params.event);
                }
                params.action.putValue("NetUuid", null);
                if (this.services != null) {
                    this.finalAction();
                }
                this.serviceContext.remove("ACTION");
                logger.info((Object)("ItemActionJDKHandler[FINAL PointCut] actionName: " + params.actionName));
                break block29;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                UIActionMonitor.endAction((String)params.uiName, (String)params.actionName, (long)(System.currentTimeMillis() - startTime));
            }
        }
    }

    private void finalAction() throws Throwable {
        for (String key : this.services.keySet()) {
            IBindService service = (IBindService)this.services.get(key);
            if (service == null || this.serviceContext == null) continue;
            service.finalActionPerformed(this.serviceContext);
        }
    }

    private void initServices(Object target) {
        IActionService itemAction;
        if (this.services == null) {
            this.services = new HashMap();
        }
        if (target instanceof IActionService && (itemAction = (IActionService)target).getServices() != null) {
            this.services.putAll(itemAction.getServices());
        }
        Map globalServices = (Map)this.serviceContext.get("GlobalService");
        if (this.services != null && globalServices != null) {
            this.services.putAll(globalServices);
        }
    }

    private void beforeAction() throws Throwable {
        IItemAction act;
        for (String key : this.services.keySet()) {
            IBindService service = (IBindService)this.services.get(key);
            if (service instanceof PermissionService || service == null || this.serviceContext == null) continue;
            service.beforeActionPerformed(this.serviceContext);
        }
        if (this.serviceContext != null && this.serviceContext.get("ACTION") instanceof IItemAction && (act = (IItemAction)this.serviceContext.get("ACTION")) != null) {
            ListUI ui = (ListUI)act.getUIObject();
            IPermSupport4ListUI uiSupport = null;
            if (!(ui instanceof IPermSupport4ListUI)) {
                return;
            }
            uiSupport = (IPermSupport4ListUI)ui;
            HashSet ids = new HashSet(ui.getAllSelecteIDListValues());
            if (ids.size() == 0) {
                return;
            }
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            ev.setFilter(filter);
            ICoreBase iCoreBase = uiSupport.getPermInterface();
            CoreBaseCollection coll = iCoreBase.getCollection(ev);
            Map uiContext = (Map)this.serviceContext.get("UICONTEXT");
            IObjectPK userPK = (IObjectPK)uiContext.get("USER.PK");
            IMetaDataPK metaPK = (IMetaDataPK)uiContext.get("METADATA.PK");
            IMetaDataPK actionPK = this.getActionPK((ItemAction)act);
            String permItemName = IMFacadeFactory.getRemoteInstance().getPermissionItem(metaPK, actionPK);
            HashSet<String> orgPKSet = new HashSet<String>();
            CoreBaseInfo coreInfo = null;
            String bizOrgId = null;
            for (int i = 0; i < coll.size(); ++i) {
                coreInfo = coll.get(i);
                IObjectValue value = (IObjectValue)coreInfo.get(uiSupport.getBizOrgProperty(ui.getMainType()));
                bizOrgId = value.get("id").toString();
                orgPKSet.add(bizOrgId);
            }
            Iterator iter = orgPKSet.iterator();
            ObjectUuidPK orgPK = null;
            while (iter.hasNext()) {
                bizOrgId = (String)iter.next();
                orgPK = new ObjectUuidPK(bizOrgId);
                PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, (String)permItemName);
            }
        }
    }

    private IMetaDataPK getActionPK(ItemAction action) {
        assert (action != null);
        String actionName = action.getActionName();
        if (StringUtils.isEmpty((String)actionName) && (actionName = action.getClass().getName()).indexOf("$") >= 0) {
            actionName = actionName.substring(actionName.indexOf("$") + 1);
        }
        return new MetaDataPK(actionName);
    }

    private void afterAction() throws Throwable {
        for (String key : this.services.keySet()) {
            IBindService service = (IBindService)this.services.get(key);
            if (service instanceof PermissionService || service == null || this.serviceContext == null) continue;
            service.afterActionPerformed(this.serviceContext);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.target.addPropertyChangeListener(listener);
    }

    public void addService(IBindService service) {
        this.target.addService(service);
    }

    public void clearServices() {
        this.target.clearServices();
    }

    public String getExtendProperty(String key) {
        return this.target.getExtendProperty(key);
    }

    public ItemAction getItemAction() {
        return this.target.getItemAction();
    }

    public int getItemKind() {
        return this.target.getItemKind();
    }

    public String getItemLogicKey() {
        return this.target.getItemLogicKey();
    }

    public Map getServices() {
        return this.target.getServices();
    }

    public IUIObject getUIObject() {
        return this.target.getUIObject();
    }

    public Object getValue(String key) {
        return this.target.getValue(key);
    }

    public void innerActionPerformed(String contextName, CoreUIObject uiObj, String actionClassName, String actionMethodName, ActionEvent event) {
        this.target.innerActionPerformed(contextName, uiObj, actionClassName, actionMethodName, event);
    }

    public boolean isBindWorkFlow() {
        return this.target.isBindWorkFlow();
    }

    public boolean isDaemonDialog() {
        return this.target.isDaemonDialog();
    }

    public boolean isDaemonRun() {
        return this.target.isDaemonRun();
    }

    public boolean isEnabled() {
        return this.target.isEnabled();
    }

    public boolean isVisible() {
        return this.target.isVisible();
    }

    public void putValue(String key, Object value) {
        this.target.putValue(key, value);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.target.removePropertyChangeListener(listener);
    }

    public void removeServices(IBindService service) {
        this.target.removeServices(service);
    }

    public void setBindWorkFlow(boolean bindWorkFlow) {
        this.target.setBindWorkFlow(bindWorkFlow);
    }

    public void setDaemonDialog(boolean isDaemonDialog) {
        this.target.setDaemonDialog(isDaemonDialog);
    }

    public void setDaemonRun(boolean isDaemonRun) {
        this.target.setDaemonRun(isDaemonRun);
    }

    public void setEnabled(boolean b) {
        this.target.setEnabled(b);
    }

    public void setExtendProperty(String key, String value) {
        this.target.setExtendProperty(key, value);
    }

    public void setItemKind(int i) {
        this.target.setItemKind(i);
    }

    public void setItemLogicKey(String logicKey) {
        this.target.setItemLogicKey(logicKey);
    }

    public void setUIObject(IUIObject uiObj) {
        this.target.setUIObject(uiObj);
    }

    public void setVisible(boolean newValue) {
        this.target.setVisible(newValue);
    }

    public void setActionEvent(ActionEvent e) {
        this.target.setActionEvent(e);
    }

    public ActionEvent getActionEvent() {
        return this.target.getActionEvent();
    }

    public boolean isBatchAction() {
        if (this.target != null) {
            return this.target.isBatchAction();
        }
        return false;
    }

    public void setBatchAction(boolean isBatchAction) {
        if (this.target != null) {
            this.target.setBatchAction(isBatchAction);
        }
    }

    class ActionParams {
        public String uiName = "";
        public String actionName = "";
        public ItemAction action = null;
        public ActionEvent event = null;
        public IUIObject uiObject = null;

        public ActionParams(Object delegate, ActionEvent e) {
            if (IMActionProxy.this.target instanceof ItemAction && IMActionProxy.this.target != null) {
                this.action = (ItemAction)IMActionProxy.this.target;
                this.actionName = this.action.getClass().getName();
                if (this.actionName.indexOf("$") >= 0) {
                    this.actionName = this.actionName.substring(this.actionName.indexOf("$") + 1);
                }
                this.uiObject = this.action.getUIObject();
                this.uiName = this.uiObject.getClass().getName();
            }
            this.event = e;
        }
    }
}

