/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IExpenseType;
import com.kingdee.eas.tm.im.common.calculate.PropertyCalculator;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractImAlgorithm {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.calculate.AbstractImAlgorithm");
    protected Context ctx = null;
    private Map<String, MultiMeasureUnitInfo> mulUnitCache = null;
    private Map<String, MaterialInfo> materialCache = null;
    private Map<String, ExpenseTypeInfo> expenseTypeCache = null;
    private Map<String, MeasureUnitInfo> unitCache = null;

    protected abstract PropertyCalculator getPropertyCalculator(int var1);

    protected abstract int getEntrySize();

    protected abstract boolean isInTax();

    protected abstract ConvertModeEnum getConvertMode();

    protected abstract BigDecimal getExchangeRate();

    public abstract int getLocalAmountPrecision();

    public abstract int getAmountPrecision();

    public abstract int getDiscountRatePrecision(int var1);

    public int getPricePrecision(int i) {
        return this.getMaterial(i) == null ? this.getDefaultPricePrecision(i) : this.getMaterial(i).getPricePrecision();
    }

    public abstract int getDefaultPricePrecision(int var1);

    public int getQtyPrecision(int i) {
        int precision = this.getQtyPrecisionLogic(i, this.getMaterial(i), this.getUnit(i), this.getQty(i));
        return precision;
    }

    protected int getQtyPrecisionLogic(int i, MaterialInfo mi, MeasureUnitInfo mui, BigDecimal qty) {
        MeasureUnitInfo unit;
        int precision = IMConstant.QTY_PRECISION;
        MultiMeasureUnitInfo mulUnit = null;
        try {
            BigDecimal coefficient;
            mulUnit = this.getMulUnit(this.ctx, mui, mi);
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                precision = mulUnit.getQtyPrecision();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (mulUnit == null && !this.isBotp() && (unit = this.getUnit(i)) != null) {
            try {
                unit = this.getUnit(this.ctx, unit.getId().toString());
                precision = unit.getQtyPrecision();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return precision;
    }

    public int getBaseQtyPrecision(int i) {
        int precision = this.getQtyPrecisionLogic(i, this.getMaterial(i), this.getBaseUnit(i), this.getBaseQty(i));
        return precision;
    }

    protected abstract void setTotalAmount(BigDecimal var1);

    protected abstract void setTotalTax(BigDecimal var1);

    protected abstract void setTotalTaxAmount(BigDecimal var1);

    protected abstract void setTotalLocalAmount(BigDecimal var1);

    protected abstract void setTotalLocalTax(BigDecimal var1);

    protected abstract void setTotalLocalTaxAmount(BigDecimal var1);

    protected abstract boolean isRowDiscount100(int var1);

    protected MaterialInfo getMaterial(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        return (MaterialInfo)siCalculator.getValue("material");
    }

    protected MeasureUnitInfo getUnit(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        return (MeasureUnitInfo)siCalculator.getValue("unit");
    }

    protected MeasureUnitInfo getBaseUnit(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        return (MeasureUnitInfo)siCalculator.getValue("baseUnit");
    }

    protected DiscountModeEnum getDiscountType(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        Object value = siCalculator.getValue("discountType");
        DiscountModeEnum discountType = DiscountModeEnum.NULL;
        if (value instanceof DiscountModeEnum) {
            discountType = (DiscountModeEnum)value;
        } else if (value instanceof Integer) {
            discountType = DiscountModeEnum.getEnum((int)((Integer)value));
        }
        return discountType;
    }

    protected BigDecimal getQty(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        return siCalculator.getBigDecimal("qty");
    }

    protected BigDecimal getBaseQty(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        return siCalculator.getBigDecimal("baseQty");
    }

    protected BigDecimal getPrice(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        return siCalculator.getBigDecimal("price");
    }

    protected BigDecimal getTaxPrice(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        return siCalculator.getBigDecimal("taxPrice");
    }

    protected BigDecimal getDiscount(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        return siCalculator.getBigDecimal("discount");
    }

    protected Boolean isIsQtyZero(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        Object value = siCalculator.getValue("isQtyZero");
        return value != null ? (Boolean)value : Boolean.FALSE;
    }

    protected void calQtyByBaseQty(int i) throws EASBizException, BOSException {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        BigDecimal baseQty = siCalculator.getBigDecimal("baseQty");
        BigDecimal qty = SysConstant.BIGZERO;
        if (baseQty != null) {
            qty = baseQty;
        } else {
            baseQty = qty;
        }
        if (baseQty != null && baseQty.compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.setValue("qty", qty);
            return;
        }
        MultiMeasureUnitInfo mulUnit = this.getMulUnit(this.ctx, this.getUnit(i), this.getMaterial(i));
        if (mulUnit != null) {
            BigDecimal coefficient = mulUnit.getBaseConvsRate();
            if (baseQty != null && coefficient != null) {
                int precision = mulUnit.getQtyPrecision();
                qty = baseQty.divide(coefficient, precision, 4);
            }
        } else {
            qty = baseQty;
        }
        siCalculator.setValue("qty", qty);
    }

    protected void calBaseQtyByQty(int i) throws EASBizException, BOSException {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        BigDecimal qty = siCalculator.getBigDecimal("qty");
        BigDecimal baseQty = SysConstant.BIGZERO;
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        if (qty != null && qty.compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.setValue("baseQty", baseQty);
            return;
        }
        MultiMeasureUnitInfo mulUnit = this.getMulUnit(this.ctx, this.getUnit(i), this.getMaterial(i));
        if (mulUnit != null) {
            BigDecimal coefficient = mulUnit.getBaseConvsRate();
            if (qty != null && coefficient != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = this.getMaterial(i).getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = null;
                    im = this.ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)this.ctx);
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(this.getMaterial(i).getId())).getBaseUnit();
                }
                mulUnit = this.getMulUnit(this.ctx, baseUnit, this.getMaterial(i));
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
        } else {
            baseQty = qty;
        }
        siCalculator.setValue("baseQty", baseQty);
    }

    protected MeasureUnitInfo getUnit(Context ctx, String unitID) throws EASBizException, BOSException {
        String key;
        MeasureUnitInfo unit = null;
        if (this.unitCache == null) {
            this.batchFetchUnit();
        }
        if ((unit = this.unitCache.get(key = unitID)) == null) {
            IMeasureUnit immu = null;
            immu = ctx == null ? MeasureUnitFactory.getRemoteInstance() : MeasureUnitFactory.getLocalInstance((Context)ctx);
            unit = immu.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(key));
            this.unitCache.put(key, unit);
        }
        return unit;
    }

    protected void batchFetchUnit() throws EASBizException, BOSException {
        if (this.unitCache == null) {
            this.unitCache = new HashMap<String, MeasureUnitInfo>();
        }
        HashSet<String> unitIdSet = new HashSet<String>();
        for (int i = 0; i < this.getEntrySize(); ++i) {
            if (this.getUnit(i) == null) continue;
            unitIdSet.add(this.getUnit(i).getId().toString());
        }
        if (unitIdSet == null || unitIdSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", unitIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
        IMeasureUnit immu = null;
        immu = this.ctx == null ? MeasureUnitFactory.getRemoteInstance() : MeasureUnitFactory.getLocalInstance((Context)this.ctx);
        MeasureUnitInfo unit = null;
        MeasureUnitCollection coll = immu.getMeasureUnitCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            unit = coll.get(i);
            String key = unit.getId().toString();
            this.unitCache.put(key, unit);
        }
    }

    protected MultiMeasureUnitInfo getMulUnit(Context ctx, MeasureUnitInfo mui, MaterialInfo mi) throws EASBizException, BOSException {
        String key;
        MultiMeasureUnitInfo mulUnit = null;
        if (mui == null || mi == null) {
            return null;
        }
        if (this.mulUnitCache == null) {
            this.batchFetchMulUnit();
        }
        if ((mulUnit = this.mulUnitCache.get(key = mi.getId().toString() + mui.getId().toString())) == null) {
            IMultiMeasureUnit immu = null;
            immu = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            if (mui != null && mi != null) {
                mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
            }
            this.mulUnitCache.put(key, mulUnit);
        }
        return mulUnit;
    }

    protected MaterialInfo getMaterial(Context ctx, String materialID) throws EASBizException, BOSException {
        MaterialInfo material = null;
        if (this.materialCache == null) {
            this.batchFetchMaterial();
        }
        if (StringUtils.isEmpty((String)materialID)) {
            return null;
        }
        String key = materialID;
        material = this.materialCache.get(key);
        if (material == null) {
            IMaterial imaterial = null;
            imaterial = ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)ctx);
            material = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
            this.materialCache.put(key, material);
        }
        return material;
    }

    protected ExpenseTypeInfo getExpenseType(Context ctx, String expenseTypeID) throws EASBizException, BOSException {
        ExpenseTypeInfo expenseType = null;
        if (this.expenseTypeCache == null) {
            this.expenseTypeCache = new HashMap<String, ExpenseTypeInfo>();
        }
        if (StringUtils.isEmpty((String)expenseTypeID)) {
            return null;
        }
        String key = expenseTypeID;
        expenseType = this.expenseTypeCache.get(key);
        if (expenseType == null) {
            IExpenseType iExpenseType = null;
            iExpenseType = ctx == null ? ExpenseTypeFactory.getRemoteInstance() : ExpenseTypeFactory.getLocalInstance((Context)ctx);
            expenseType = iExpenseType.getExpenseTypeInfo((IObjectPK)new ObjectUuidPK(expenseTypeID));
            this.expenseTypeCache.put(key, expenseType);
        }
        return expenseType;
    }

    protected void batchFetchMulUnit() throws EASBizException, BOSException {
        if (this.mulUnitCache == null) {
            this.mulUnitCache = new HashMap<String, MultiMeasureUnitInfo>();
        }
        HashSet<String> matIdSet = new HashSet<String>();
        HashSet<String> unitIdSet = new HashSet<String>();
        for (int i = 0; i < this.getEntrySize(); ++i) {
            if (this.getMaterial(i) == null) continue;
            matIdSet.add(this.getMaterial(i).getId().toString());
            if (this.getUnit(i) == null) continue;
            unitIdSet.add(this.getUnit(i).getId().toString());
        }
        if (unitIdSet == null || unitIdSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", matIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", unitIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBasicUnit", (Object)Boolean.TRUE));
        filter.setMaskString("#0 and (#1 or #2)");
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("measureUnit.id"));
        view.getSelector().add(new SelectorItemInfo("isBasicUnit"));
        view.getSelector().add(new SelectorItemInfo("conversionRate"));
        view.getSelector().add(new SelectorItemInfo("baseConvsRate"));
        view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
        IMultiMeasureUnit immu = null;
        immu = this.ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
        MultiMeasureUnitInfo mulUnit = null;
        MultiMeasureUnitCollection coll = immu.getMultiMeasureUnitCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            mulUnit = coll.get(i);
            String key = mulUnit.getMaterial().getId().toString() + mulUnit.getMeasureUnit().getId().toString();
            this.mulUnitCache.put(key, mulUnit);
        }
    }

    protected void batchFetchMaterial() throws EASBizException, BOSException {
        if (this.materialCache == null) {
            this.materialCache = new HashMap<String, MaterialInfo>();
        }
        HashSet<String> matIdSet = new HashSet<String>();
        for (int i = 0; i < this.getEntrySize(); ++i) {
            if (this.getMaterial(i) == null) continue;
            matIdSet.add(this.getMaterial(i).getId().toString());
        }
        if (matIdSet == null || matIdSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", matIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        IMaterial imaterial = null;
        imaterial = this.ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)this.ctx);
        MaterialInfo material = null;
        MaterialCollection coll = imaterial.getMaterialCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            material = coll.get(i);
            String key = material.getId().toString();
            this.materialCache.put(key, material);
        }
    }

    protected ExchangeRateInfo getDefaultExchangeRateInfo() {
        ExchangeRateInfo defaultExchangeRateInfo = new ExchangeRateInfo();
        ExchangeAuxInfo auxInfo = new ExchangeAuxInfo();
        auxInfo.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        auxInfo.setPrecision(2);
        defaultExchangeRateInfo.setConvertRate(BigDecimal.ONE);
        defaultExchangeRateInfo.setExchangeAux(auxInfo);
        return defaultExchangeRateInfo;
    }

    protected BigDecimal obj2BigDecimal(Object obj, BigDecimal defaultValue) {
        if (null == obj) {
            return defaultValue;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof String) {
            try {
                Object s = BOSLocaleUtil.getNumberFormat().parseObject((String)obj);
                return new BigDecimal(s.toString());
            }
            catch (Exception s) {}
        } else {
            if (obj instanceof Byte) {
                byte b = (Byte)obj;
                return new BigDecimal("" + b);
            }
            if (obj instanceof Short) {
                short s = (Short)obj;
                return new BigDecimal("" + s);
            }
            if (obj instanceof Integer) {
                int i = (Integer)obj;
                return new BigDecimal("" + i);
            }
            if (obj instanceof Long) {
                long l = (Long)obj;
                return new BigDecimal("" + l);
            }
            if (obj instanceof Float) {
                float f = ((Float)obj).floatValue();
                return new BigDecimal("" + f);
            }
            if (obj instanceof Double || obj instanceof Number) {
                double d = ((Number)obj).doubleValue();
                return new BigDecimal("" + d);
            }
        }
        return defaultValue;
    }

    protected BigDecimal nullToZero(BigDecimal value) {
        if (value == null) {
            return SysConstant.BIGZERO;
        }
        return value;
    }

    protected boolean isBotp() {
        return false;
    }
}

