/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.common.comm.AbstractCommunicationSetInfo;
import com.kingdee.eas.tm.im.common.comm.CommunicationSetCollection;
import com.kingdee.eas.tm.im.common.comm.CommunicationSetFactory;
import com.kingdee.eas.tm.im.common.comm.CommunicationSetInfo;
import com.kingdee.eas.tm.im.common.comm.client.AbstractTaxCommunicationSetEditUI;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import org.apache.log4j.Logger;

public class TaxCommunicationSetEditUI
extends AbstractTaxCommunicationSetEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxCommunicationSetEditUI.class);

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isPwyDev"));
        sic.add(new SelectorItemInfo("pwyURL"));
        sic.add(new SelectorItemInfo("pwyDevURL"));
        sic.add(new SelectorItemInfo("pwySocketURL"));
        sic.add(new SelectorItemInfo("defaultTaxNumber"));
        sic.add(new SelectorItemInfo("id"));
        return sic;
    }

    protected IObjectValue createNewData() {
        CommunicationSetInfo communicationSetInfo = new CommunicationSetInfo();
        return communicationSetInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CommunicationSetFactory.getRemoteInstance();
    }

    private void checkRequired() {
        StringBuffer sb = new StringBuffer();
        if (this.txtPwyURL.getText().isEmpty()) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.common.comm.IMCommResource", (String)"PwyURL_NOT_NULL"));
            MsgBox.showWarning((String)sb.toString());
            SysUtil.abort();
        }
        if (this.txtPwyDevURL.getText().isEmpty()) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.common.comm.IMCommResource", (String)"PwyDevURL_NOT_NULL"));
            MsgBox.showWarning((String)sb.toString());
            SysUtil.abort();
        }
        if (this.txtPwySocketURL.getText().isEmpty()) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.common.comm.IMCommResource", (String)"PwySocketURL_NOT_NULL"));
            MsgBox.showWarning((String)sb.toString());
            SysUtil.abort();
        }
        if (!IMUtils.IsUrl(this.txtPwyURL.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.common.comm.IMCommResource", (String)"HttpPwyURL_ERROR"));
            SysUtil.abort();
        }
        if (!IMUtils.IsUrl(this.txtPwyDevURL.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.common.comm.IMCommResource", (String)"HttpPwyDevURL_ERROR"));
            SysUtil.abort();
        }
        if (!IMUtils.IsUrl(this.txtPwySocketURL.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.common.comm.IMCommResource", (String)"HttpPwySocketURL_ERROR"));
            SysUtil.abort();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        CommunicationSetCollection coll = null;
        AbstractCommunicationSetInfo communicationInfo = null;
        view.setSelector(this.getSelectors());
        try {
            coll = CommunicationSetFactory.getRemoteInstance().getCommunicationSetCollection(view);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (coll != null && coll.size() > 0) {
            communicationInfo = coll.get(0);
        }
        if (communicationInfo != null) {
            this.txtPwyURL.setText(communicationInfo.getPwyURL());
            this.txtPwyDevURL.setText(communicationInfo.getPwyDevURL());
            this.txtPwySocketURL.setText(communicationInfo.getPwySocketURL());
            this.txtDefaultTaxNumber.setText(communicationInfo.getDefaultTaxNumber());
            if (communicationInfo.isIsPwyDev()) {
                this.chkIsPwyDev.setSelected(true);
            } else {
                this.chkIsPwyDev.setSelected(false);
            }
            this.editData.setId(communicationInfo.getId());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
    }
}

