/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.common.Resource;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.client.AbstractTaxTransLogDumpUI;
import com.kingdee.eas.tm.im.common.comm.client.TaxTransLogListUI;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class TaxTransLogDumpUI
extends AbstractTaxTransLogDumpUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxTransLogDumpUI.class);
    private TaxTransLogListUI logUI = null;

    public void onLoad() throws Exception {
        super.onLoad();
        try {
            int dumpUpLimit = TaxTransLogFacadeFactory.getRemoteInstance().getDumpPolicy();
            if (dumpUpLimit < 0) {
                dumpUpLimit = 0;
            }
            this.kDFormattedTextFieldDump.setColumns(4);
            this.kDFormattedTextFieldDump.setValue((Object)new Integer(dumpUpLimit));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.init();
    }

    private void init() {
        this.logUI = (TaxTransLogListUI)this.getUIContext().get("logUI");
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        this.enableComponents();
    }

    private void beginProgress() {
        this.disableComponents();
        this.progressBar.setIndeterminate(true);
    }

    private void endProgress() {
        this.enableComponents();
        this.progressBar.setIndeterminate(false);
    }

    private void disableComponents() {
        this.kDButtonConfirm.setEnabled(false);
        this.kDButtonCancel.setEnabled(false);
    }

    private void enableComponents() {
        this.kDButtonConfirm.setEnabled(true);
        this.kDButtonCancel.setEnabled(true);
    }

    @Override
    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        super.kDButtonCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        BigDecimal days = this.kDFormattedTextFieldDump.getBigDecimalValue();
        int d = days.intValue();
        if (d > 10000) {
            MsgBox.showInfo((Component)((Object)this), (String)Resource.RESET_DAYS);
            return;
        }
        new DumpThread(d).start();
    }

    protected JButton getDefaultButton() {
        return this.kDButtonConfirm;
    }

    class DumpThread
    extends Thread {
        private int days;

        public DumpThread(int days) {
            this.days = days;
        }

        @Override
        public void run() {
            try {
                TaxTransLogDumpUI.this.beginProgress();
                TaxTransLogDumpUI.this.progressBar.setString(Resource.ON_DUMPING);
                CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
                IObjectPK logPk = LogUtils.beginLog(null, "setDumpPolicy", BOSObjectType.create((String)"34DD32C1"), null, null, "im_taxTransLog_dump", cuInfo.getId().toString());
                TaxTransLogFacadeFactory.getRemoteInstance().setDumpPolicy(this.days);
                TaxTransLogFacadeFactory.getRemoteInstance().dump(this.days);
                LogUtils.afterLog(null, logPk);
                TaxTransLogDumpUI.this.logUI.refreshList();
            }
            catch (Exception e) {
                TaxTransLogDumpUI.this.handUIException(e);
            }
            finally {
                TaxTransLogDumpUI.this.endProgress();
                TaxTransLogDumpUI.this.getUIWindow().close();
            }
        }
    }
}

