/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.tm.im.FilterCommonStatusEnum;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.common.comm.LogStatusEnum;
import com.kingdee.eas.tm.im.common.comm.client.AbstractTaxTransLogQueryPanelUI;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class TaxTransLogQueryPanelUI
extends AbstractTaxTransLogQueryPanelUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxTransLogQueryPanelUI.class);
    private int flag;
    private CustomerParams customerParams = null;
    private final String SHOW_CURRENT = "1";

    public TaxTransLogQueryPanelUI(int flag) throws Exception {
        this.flag = flag;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() {
        if (this.flag == 1) {
            this.radioCurrent.setSelected(true);
        } else {
            this.radioHistory.setSelected(true);
        }
        this.dateFrom.setTimeEnabled(true);
        this.dateTo.setTimeEnabled(true);
        this.loadStatus();
    }

    private void loadStatus() {
        this.comboLogStatus.removeAllItems();
        this.comboLogStatus.addItem((Object)FilterCommonStatusEnum.NULL);
        this.comboLogStatus.addItems(LogStatusEnum.getEnumList().toArray());
        this.comboLogType.removeAllItems();
        this.comboLogType.addItem((Object)FilterCommonStatusEnum.NULL);
        this.comboLogType.addItems(PwyServiceType.getEnumList().toArray());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getFilterInfo() {
        LogStatusEnum logStatus;
        PwyServiceType pwyServiceType;
        Object value;
        FilterInfo filter = new FilterInfo();
        String maskString = "";
        int index = 0;
        Object data = this.prmtCompany.getData();
        if (data != null) {
            if (data instanceof OrgUnitInfo) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)((OrgUnitInfo)this.prmtCompany.getData()).getId().toString()));
                maskString = maskString + "#" + index;
                ++index;
            }
            if (data instanceof OrgUnitInfo[]) {
                OrgUnitInfo[] infos = (OrgUnitInfo[])data;
                if (infos.length == 1) {
                    filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)infos[0].getId().toString()));
                    maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
                    ++index;
                } else {
                    for (int i = 0; i < infos.length; ++i) {
                        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)infos[i].getId().toString()));
                        maskString = index == 0 ? maskString + "(#" + index : (i == 0 ? maskString + " and (#" + index : (i == infos.length - 1 ? maskString + " or #" + index + ")" : maskString + " or #" + index));
                        ++index;
                    }
                }
            }
        }
        Timestamp fromDate = this.dateFrom.getTimestamp();
        Timestamp toDate = this.dateTo.getTimestamp();
        if (fromDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)fromDate, CompareType.GREATER_EQUALS));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        if (toDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)toDate, CompareType.LESS_EQUALS));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        if ((value = this.comboLogType.getSelectedItem()) instanceof PwyServiceType && (pwyServiceType = (PwyServiceType)((Object)value)) != null) {
            filter.getFilterItems().add(new FilterItemInfo("logType", (Object)pwyServiceType.getValue()));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        if ((value = this.comboLogStatus.getSelectedItem()) instanceof LogStatusEnum && (logStatus = (LogStatusEnum)((Object)value)) != null) {
            filter.getFilterItems().add(new FilterItemInfo("logStatus", (Object)logStatus.getValue()));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        filter.setMaskString(maskString);
        return filter;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterInfo filterInfo = entityViewInfo.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems().size() == 0) {
            return;
        }
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        ArrayList<FullOrgUnitInfo> infoList = new ArrayList<FullOrgUnitInfo>();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            String type;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("company.id")) {
                String cuId = (String)filterItemInfo.getCompareValue();
                try {
                    FullOrgUnitInfo data = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cuId)));
                    infoList.add(data);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("createTime")) {
                if (CompareType.GREATER_EQUALS == filterItemInfo.getCompareType()) {
                    this.dateFrom.setValue(filterItemInfo.getCompareValue());
                } else if (CompareType.LESS_EQUALS == filterItemInfo.getCompareType()) {
                    this.dateTo.setValue(filterItemInfo.getCompareValue());
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("logStatus")) {
                type = (String)filterItemInfo.getCompareValue();
                if ("-1".equals(type)) {
                    this.comboLogStatus.setSelectedItem((Object)FilterCommonStatusEnum.NULL);
                } else {
                    this.comboLogStatus.setSelectedItem((Object)LogStatusEnum.getEnum(type));
                }
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("logType")) continue;
            type = (String)filterItemInfo.getCompareValue();
            if ("-1".equals(type)) {
                this.comboLogType.setSelectedItem((Object)FilterCommonStatusEnum.NULL);
                continue;
            }
            this.comboLogType.setSelectedItem((Object)PwyServiceType.getEnum(type));
        }
        if (infoList.size() > 0) {
            OrgUnitInfo[] infos = new OrgUnitInfo[infoList.size()];
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < infos.length; ++i) {
                infos[i] = (OrgUnitInfo)infoList.get(i);
                idSet.add(infos[i].getId().toString());
            }
            this.prmtCompany.setData((Object)infos);
        }
    }

    public boolean verify() {
        return true;
    }

    public Component getFocusComponent() {
        return null;
    }

    public void clear() {
        this.radioCurrent.setSelected(true);
        this.prmtCompany.setValue(null);
        this.dateFrom.setValue(null);
        this.dateTo.setValue(null);
        this.comboLogType.setSelectedIndex(0);
        this.comboLogStatus.setSelectedIndex(0);
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        this.customerParams = cp;
        if (this.customerParams != null) {
            if ("1".equals(this.customerParams.getCustomerParam("flag"))) {
                this.radioCurrent.setSelected(true);
            } else {
                this.radioHistory.setSelected(true);
            }
        }
    }

    public CustomerParams getCustomerParams() {
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        int logFlag = 1;
        logFlag = this.radioCurrent.isSelected() ? 1 : 2;
        hm.put("flag", new Integer(logFlag));
        this.customerParams = new CustomerParams();
        this.customerParams.setHm(hm);
        return this.customerParams;
    }

    public int getSelectedLogType() {
        if (this.radioCurrent.isSelected()) {
            return 1;
        }
        return 2;
    }
}

