/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.msg;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import org.apache.log4j.Logger;

public class PwyDebugHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.msg.PwyDebugHelper");

    public static String getPwyRespJson(String type) {
        return PwyDebugHelper.getDatafromFile(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDatafromFile(String type) {
        String filePath = "com/kingdee/eas/tm/im/common/comm/msg/resq/" + type + ".json";
        StringBuilder jsonStrBuilder = new StringBuilder();
        InputStream is = null;
        try {
            is = PwyDebugHelper.class.getClassLoader().getResourceAsStream(filePath);
            BufferedReader streamReader = new BufferedReader(new InputStreamReader(is, "GBK"));
            String inputStr = "";
            while ((inputStr = streamReader.readLine()) != null) {
                jsonStrBuilder.append(inputStr);
            }
            String string = PwyDebugHelper.warpJsonStr(type, jsonStrBuilder.toString());
            return string;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    public static String warpJsonStr(String type, String jsonStr) {
        String str = jsonStr;
        if ("V40".equals(type) || "V42".equals(type)) {
            str = String.format(jsonStr, PwyDebugHelper.getInvoiceCodeRandom(), PwyDebugHelper.getInvoiceNoRandom());
        }
        return str;
    }

    public static String getInvoiceCodeRandom() {
        return PwyDebugHelper.getRandomNumber(12);
    }

    public static String getInvoiceNoRandom() {
        return PwyDebugHelper.getRandomNumber(8);
    }

    public static String getRandomNumber(int length) {
        String factor = "0123456789";
        StringBuffer sb = new StringBuffer();
        SecureRandom secureRandom = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            sb.append(factor.charAt(secureRandom.nextInt(10)));
        }
        return sb.toString();
    }
}

