/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.msg.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.invoicePool.TMCheckStatus;
import com.kingdee.eas.tm.common.utils.TMJsonParser;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.InvResourceType;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.common.comm.msg.parser.AbstractIncomeInvoiceParser;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckInvoiceParser
extends AbstractIncomeInvoiceParser {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.msg.parser.CheckInvoiceParser");

    public IncomeInvoiceCollection parse(Context ctx, Map params) throws BOSException, EASBizException, JSONException {
        String billid = (String)params.get("billid");
        String orgid = (String)params.get("orgid");
        String retInfo = (String)params.get("retInfo");
        IncomeInvoiceInfo info = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceInfo((IObjectPK)new ObjectUuidPK(billid));
        String data = new JSONObject(retInfo).get("data").toString();
        JSONObject jsonData = new JSONObject(data);
        String serialNo = this.getStringValue(jsonData, "serialNo");
        info.setSerialNo(serialNo);
        String invoiceCode = this.getStringValue(jsonData, "invoiceCode");
        info.setInvoiceCode(invoiceCode);
        String invoiceNo = this.getStringValue(jsonData, "invoiceNo");
        info.setInvoiceNumber(invoiceNo);
        info.setCheckStatus(TMCheckStatus.PASS);
        String invoiceDate = this.getStringValue(jsonData, "invoiceDate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            info.setBizDate(sdf.parse(invoiceDate));
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        String checkCode = this.getStringValue(jsonData, "checkCode");
        info.setCheckCode(checkCode);
        String salerName = this.getStringValue(jsonData, "salerName");
        info.setBillingCompany(salerName);
        String salerTaxNo = this.getStringValue(jsonData, "salerTaxNo");
        info.setTaxNumber(salerTaxNo);
        String salerAddressPhone = this.getStringValue(jsonData, "salerAddressPhone");
        info.setContact(salerAddressPhone);
        String salerAccount = this.getStringValue(jsonData, "salerAccount");
        info.setBankInformation(salerAccount);
        String buyerName = this.getStringValue(jsonData, "buyerName");
        info.setBuyerName(buyerName);
        String buyerTaxNo = this.getStringValue(jsonData, "buyerTaxNo");
        info.setBuyerTaxNo(buyerTaxNo);
        String buyerAddressPhone = this.getStringValue(jsonData, "buyerAddressPhone");
        info.setBuyerAddressPhone(buyerAddressPhone);
        String buyerAccount = this.getStringValue(jsonData, "buyerAccount");
        info.setBuyerAccount(buyerAccount);
        String amount = this.getStringValue(jsonData, "amount");
        if (amount == null || "".equals(amount.trim())) {
            info.setAmount(BigDecimal.ZERO);
        } else {
            info.setAmount(new BigDecimal(amount));
        }
        String headTaxAmount = this.getStringValue(jsonData, "taxAmount");
        if (headTaxAmount == null || "".equals(headTaxAmount.trim())) {
            info.setTax(BigDecimal.ZERO);
        } else {
            info.setTax(new BigDecimal(headTaxAmount));
        }
        String totalAmount = this.getStringValue(jsonData, "totalAmount");
        if (totalAmount == null || "".equals(totalAmount.trim())) {
            info.setAmountTax(BigDecimal.ZERO);
        } else {
            info.setAmountTax(new BigDecimal(totalAmount));
        }
        String remark = TMJsonParser.handleDescription((String)this.getStringValue(jsonData, "remark"));
        info.setDescription(remark);
        String machineNo = this.getStringValue(jsonData, "machineNo");
        info.setMachineNo(machineNo);
        String cancelMark = this.getStringValue(jsonData, "cancelMark");
        if (cancelMark != null && "Y".equals(cancelMark.trim())) {
            info.setStatus(IncomeStatusEnum.CANCEL);
        } else {
            String status = jsonData.getString("invoiceStatus");
            IncomeStatusEnum statusEnum = this.getIncomeStatusEnum(status);
            if (statusEnum != null) {
                info.setStatus(statusEnum);
            }
        }
        String proxyMark = this.getStringValue(jsonData, "proxyMark");
        if (proxyMark != null && "1".equals(proxyMark.trim())) {
            info.setIsIssue(true);
        } else {
            info.setIsIssue(false);
        }
        if (jsonData.has("downloadUrl") && !StringUtils.isEmpty((String)jsonData.getString("downloadUrl"))) {
            info.setPdfUrl(jsonData.getString("downloadUrl"));
        } else if (jsonData.has("snapshotUrl") && !StringUtils.isEmpty((String)jsonData.getString("snapshotUrl"))) {
            info.setPdfUrl(jsonData.getString("snapshotUrl"));
        }
        String invoiceType = this.getStringValue(jsonData, "invoiceType");
        PayInvoiceTypeEnum invoiceTypeEnum = this.getInvoiceType(invoiceType);
        if (invoiceTypeEnum == null) {
            logger.debug((Object)("Ignore! not vat invoice,type : " + invoiceType));
            return null;
        }
        String drawer = this.getStringValue(jsonData, "drawer");
        info.setDrawer(drawer);
        String reviewer = this.getStringValue(jsonData, "reviewer");
        info.setReviewer(reviewer);
        String payee = this.getStringValue(jsonData, "payee");
        info.setPayee(payee);
        boolean needUpdateEntry = false;
        needUpdateEntry = info.getResourceType() != InvResourceType.INV_DOWNLOAD || info.getEntries().size() <= 0;
        if (needUpdateEntry) {
            IncomeInvoiceEntryCollection entryColl = new IncomeInvoiceEntryCollection();
            IncomeInvoiceEntryInfo entry = null;
            JSONArray items = new JSONObject(data).getJSONArray("items");
            for (int i = 0; i < items.length(); ++i) {
                JSONObject item = items.getJSONObject(i);
                BigDecimal unitPrice = new BigDecimal(this.transformString(item.getString("unitPrice")));
                BigDecimal taxRate = BigDecimal.ZERO;
                try {
                    taxRate = new BigDecimal(this.transformString(item.getString("taxRate").split("%")[0]));
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                String unit = item.getString("unit");
                BigDecimal num = new BigDecimal(this.transformString(item.getString("num")));
                BigDecimal detailAmount = new BigDecimal(this.transformString(item.getString("detailAmount")));
                String specModel = item.getString("specModel");
                BigDecimal taxAmount = new BigDecimal(this.transformString(item.getString("taxAmount")));
                String goodsName = item.getString("goodsName");
                String goodsCode = item.getString("goodsCode");
                entry = new IncomeInvoiceEntryInfo();
                entry.setTaxClassificationNumber(goodsCode);
                if (entry.getTaxClassificationNumber() != null) {
                    EntityViewInfo taxClassView = new EntityViewInfo();
                    FilterInfo taxClassFilter = new FilterInfo();
                    taxClassFilter.getFilterItems().add(new FilterItemInfo("mergeCode", (Object)entry.getTaxClassificationNumber(), CompareType.EQUALS));
                    taxClassView.setFilter(taxClassFilter);
                    TaxClassificationCodeCollection taxClassColl = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(taxClassView);
                    if (taxClassColl != null && taxClassColl.size() > 0) {
                        TaxClassificationCodeInfo taxClassInfo = taxClassColl.get(0);
                        entry.setTaxClassificationCode(taxClassInfo);
                    }
                }
                entry.setTaxExcluded(unitPrice.setScale(10, 4));
                entry.setTaxRate(taxRate.divide(new BigDecimal(100)).setScale(4, 4));
                entry.setUnitName(unit);
                entry.setQuantity(num);
                entry.setMoney(detailAmount.setScale(2, 4));
                entry.setSpecs(specModel);
                entry.setTaxAmt(taxAmount.setScale(2, 4));
                entry.setProductName(goodsName);
                entry.setIncomeInvoice(info);
                entry.setId(BOSUuid.create((String)"5966C535"));
                BigDecimal taxTotal = taxAmount.add(detailAmount);
                entry.setTaxTotal(taxTotal.setScale(2, 4));
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    entry.setTaxPrice(taxTotal.divide(num, 4).setScale(10, 4));
                } else {
                    entry.setTaxPrice(BigDecimal.ZERO);
                }
                entryColl.add(entry);
            }
            info.getEntries().clear();
            info.getEntries().addCollection(entryColl);
        }
        IncomeInvoiceCollection invoiceColl = new IncomeInvoiceCollection();
        invoiceColl.add(info);
        return invoiceColl;
    }

    private String transformString(String str) {
        if (str != null && str.length() > 0 && !"null".equals(str)) {
            return str;
        }
        return "0";
    }
}

