/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.msg.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IncomeAuthenticateEnum;
import com.kingdee.eas.tm.im.IncomeAuthenticateStatusEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.InvResourceType;
import com.kingdee.eas.tm.im.common.comm.msg.parser.AbstractIncomeInvoiceParser;
import java.util.Map;
import org.apache.log4j.Logger;

@Deprecated
public class IncomeInvoiceDownloadAuthBillParser
extends AbstractIncomeInvoiceParser {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.msg.parser.IncomeInvoiceDownloadAuthBillParser");

    public IncomeInvoiceCollection parse(Context ctx, Map params) throws BOSException, EASBizException, JSONException {
        String orgid = (String)params.get("orgid");
        String retInfo = (String)params.get("retInfo");
        JSONObject dataJson = new JSONObject(retInfo);
        IncomeInvoiceCollection invoiceColl = new IncomeInvoiceCollection();
        String errcode = this.getStringValue(dataJson, "errcode");
        if (this.getSuccessCode().equals(errcode)) {
            JSONArray jsonArray = this.getJSONArray(dataJson, "invoice");
            int size = jsonArray.length();
            for (int i = 0; i < size; ++i) {
                IncomeInvoiceInfo invoiceInfo = this.parseHead(ctx, orgid, jsonArray.getJSONObject(i));
                if (invoiceInfo == null) continue;
                invoiceColl.add(invoiceInfo);
            }
        }
        return invoiceColl;
    }

    private IncomeInvoiceInfo parseHead(Context ctx, String orgid, JSONObject invoiceObject) throws BOSException, EASBizException {
        String invoiceState;
        String invoiceType = this.getStringValue(invoiceObject, "invoice_type");
        if (!invoiceType.equals("01")) {
            return null;
        }
        String invoiceCode = this.getStringValue(invoiceObject, "invoice_code");
        String invoiceNumber = this.getStringValue(invoiceObject, "invoice_num");
        IncomeInvoiceInfo invoiceInfo = this.getIncomeInvoiceInfo(ctx, invoiceCode, invoiceNumber);
        invoiceInfo.setNumber(invoiceCode + "_" + invoiceNumber);
        invoiceInfo.setInvoiceCode(invoiceCode);
        invoiceInfo.setInvoiceNumber(invoiceNumber);
        invoiceInfo.setBizDate(this.getDateValue(this.getStringValue(invoiceObject, "billdate")));
        invoiceInfo.setBillingCompany(this.getStringValue(invoiceObject, "sellername"));
        invoiceInfo.setAmount(this.getBigDecimalValue(this.getStringValue(invoiceObject, "moneyamount")));
        invoiceInfo.setTax(this.getBigDecimalValue(this.getStringValue(invoiceObject, "tax")));
        invoiceInfo.setAmountTax(invoiceInfo.getAmount().add(invoiceInfo.getTax()));
        String checkdate = this.getStringValue(invoiceObject, "checkdate");
        String authentype = this.getStringValue(invoiceObject, "authentype");
        if ("1".equals(authentype)) {
            invoiceInfo.setAuthenticateDate(this.getDateValue(checkdate));
            invoiceInfo.setAuthenticateWay(IncomeAuthenticateEnum.MANUAL);
        } else if ("2".equals(authentype)) {
            invoiceInfo.setAuthenticateDate(this.getDateValue(checkdate));
            invoiceInfo.setAuthenticateWay(IncomeAuthenticateEnum.SCAN);
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        invoiceInfo.setCompany(companyInfo);
        String taxBelong = this.getStringValue(invoiceObject, "taxbelong");
        if (taxBelong != null) {
            int year = Integer.parseInt(taxBelong.substring(0, 4));
            int number = Integer.parseInt(taxBelong.substring(4, 6));
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)year, (int)number, (CompanyOrgUnitInfo)companyInfo);
            invoiceInfo.setBelongTaxPeriod(periodInfo);
        }
        if ("0".equals(invoiceState = this.getStringValue(invoiceObject, "invoice_state"))) {
            invoiceInfo.setStatus(IncomeStatusEnum.NORMAL);
        } else if ("1".equals(invoiceState)) {
            invoiceInfo.setStatus(IncomeStatusEnum.LOSECONTROL);
        } else if ("2".equals(invoiceState)) {
            invoiceInfo.setStatus(IncomeStatusEnum.CANCEL);
        } else if ("3".equals(invoiceState)) {
            invoiceInfo.setStatus(IncomeStatusEnum.CREDIT);
        } else if ("4".equals(invoiceState)) {
            invoiceInfo.setStatus(IncomeStatusEnum.UNUSUAL);
        } else if ("5".equals(invoiceState)) {
            invoiceInfo.setStatus(IncomeStatusEnum.UNNORMAL);
        } else if ("6".equals(invoiceState)) {
            invoiceInfo.setStatus(IncomeStatusEnum.UNCONFIRMRED);
        } else if ("7".equals(invoiceState)) {
            invoiceInfo.setStatus(IncomeStatusEnum.PARTLYRED);
        } else if ("8".equals(invoiceState)) {
            invoiceInfo.setStatus(IncomeStatusEnum.FULLRED);
        }
        invoiceInfo.setAuthenticateStatus(IncomeAuthenticateStatusEnum.PASSED);
        invoiceInfo.setInvoiceType(PayInvoiceTypeEnum.VALUEADDEDTAXINV);
        invoiceInfo.setResourceType(InvResourceType.INV_DOWNLOAD);
        invoiceInfo.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        return invoiceInfo;
    }
}

