/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.msg.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.utils.TMDBMutexHelper;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.InvResourceType;
import com.kingdee.eas.tm.im.common.comm.msg.parser.AbstractIncomeInvoiceParser;
import com.kingdee.eas.tm.im.common.comm.msg.parser.IncomeInvoiceParser;
import com.kingdee.eas.tm.im.common.comm.service.util.IncomeInvoicePwyHelper;
import com.kingdee.eas.tm.im.param.InvoiceHelperParam;
import com.kingdee.eas.tm.im.util.CheckAbsUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class WebDownloadBySnParser
extends AbstractIncomeInvoiceParser {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.msg.parser.WebDownloadBySnParser");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncomeInvoiceCollection parse(Context ctx, Map params) throws BOSException, EASBizException, JSONException {
        logger.error((Object)"exit method WebDownloadBySnParser parse.");
        CompanyOrgUnitInfo company = null;
        if (params.get("CompanyOrgUnitInfo") != null && params.get("CompanyOrgUnitInfo") instanceof CompanyOrgUnitInfo) {
            company = (CompanyOrgUnitInfo)params.get("CompanyOrgUnitInfo");
        }
        SupplierInfo supplier = null;
        if (params.get("currAcctSupplier") != null && params.get("currAcctSupplier") instanceof SupplierInfo) {
            supplier = (SupplierInfo)params.get("currAcctSupplier");
        }
        String operation = (String)params.get("operation");
        JSONObject dataJson = new JSONObject((String)params.get("retInfo"));
        String errcode = this.getStringValue(dataJson, "errcode");
        IncomeInvoiceCollection invoiceColl = new IncomeInvoiceCollection();
        IncomeInvoiceInfo invoiceInfo = null;
        IncomeInvoiceParser parser = null;
        String mutex = null;
        boolean lock = false;
        if (this.getSuccessCode().equals(errcode)) {
            JSONArray jsonArray = this.getJSONArray(dataJson, "data");
            int size = jsonArray.length();
            for (int i = 0; i < size; ++i) {
                block20: {
                    block19: {
                        block18: {
                            parser = new IncomeInvoiceParser(ctx, jsonArray.getJSONObject(i));
                            mutex = parser.getMutex();
                            lock = TMDBMutexHelper.requestDBMutex((Context)ctx, (String)mutex);
                            if (lock) break block18;
                            if (!lock) continue;
                            TMDBMutexHelper.releaseDBMutex((Context)ctx, (String)mutex);
                            lock = false;
                            continue;
                        }
                        invoiceInfo = parser.getIncomeInvoiceInfo();
                        if (invoiceInfo != null) break block19;
                        if (!lock) continue;
                        TMDBMutexHelper.releaseDBMutex((Context)ctx, (String)mutex);
                        lock = false;
                        continue;
                    }
                    if (!this.filterInvoice(invoiceInfo, params)) break block20;
                    if (!lock) continue;
                    TMDBMutexHelper.releaseDBMutex((Context)ctx, (String)mutex);
                    lock = false;
                    continue;
                }
                try {
                    if (InvoiceHelperParam.OPR_DOWNLOAD.equals(operation)) {
                        invoiceInfo.setCompany(company);
                        invoiceInfo.setCurrAcctSupplier(supplier);
                    } else {
                        CompanyOrgUnitInfo org = this.getCompanyOrgUnit(ctx, invoiceInfo.getBuyerTaxNo());
                        invoiceInfo.setCompany(org);
                    }
                    if (IncomeInvoicePwyHelper.isCQPurCloudReceive(params)) {
                        invoiceInfo.setIsPurchaseSyn(true);
                        invoiceInfo.setIsAccept(true);
                        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                        invoiceInfo.setAcceptUser(userInfo);
                        invoiceInfo.setAcceptInvoiceDate(new Date());
                        if (params.get("supplierID") != null) {
                            supplier = new SupplierInfo();
                            supplier.setId(BOSUuid.read((String)params.get("supplierID").toString()));
                            invoiceInfo.setCurrAcctSupplier(supplier);
                        }
                    }
                    if (invoiceInfo.getCompany() == null) {
                        invoiceInfo.setCompany(company);
                    }
                    if (invoiceInfo.getCheckAbs() != null && invoiceInfo.getCheckAbs().get("taxPeriodStr") != null) {
                        invoiceInfo.getCheckAbs().setTaxPeriod(CheckAbsUtil.getPeriodInfo(ctx, (String)invoiceInfo.getCheckAbs().get("taxPeriodStr"), invoiceInfo.getCompany()));
                    }
                    invoiceInfo.setResourceType(InvResourceType.INV_DOWNLOAD);
                    IncomeInvoiceFactory.getLocalInstance(ctx).save((CoreBaseInfo)invoiceInfo);
                    invoiceColl.add(invoiceInfo);
                    if (!lock) continue;
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)e);
                        if (!lock) continue;
                    }
                    catch (Throwable throwable) {
                        if (lock) {
                            TMDBMutexHelper.releaseDBMutex((Context)ctx, mutex);
                            lock = false;
                        }
                        throw throwable;
                    }
                    TMDBMutexHelper.releaseDBMutex((Context)ctx, (String)mutex);
                    lock = false;
                    continue;
                }
                TMDBMutexHelper.releaseDBMutex((Context)ctx, (String)mutex);
                lock = false;
                continue;
            }
        }
        return invoiceColl;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, String taxNo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        CompanyOrgUnitInfo company = null;
        String sql = "select fid from T_ORG_Company where RTRIM(LTRIM(FtaxNumber)) = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{taxNo});
        String id = null;
        try {
            while (rs.next() && !(id = rs.getString("fid")).equals(curCompany.getId().toString())) {
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (!StringUtils.isEmpty(id)) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
        }
        if (company == null) {
            company = curCompany;
        }
        return company;
    }
}

