/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.msg.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.utils.TMDBMutexHelper;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.InvResourceType;
import com.kingdee.eas.tm.im.common.comm.msg.parser.AbstractIncomeInvoiceParser;
import com.kingdee.eas.tm.im.common.comm.msg.parser.IncomeInvoiceParser;
import com.kingdee.eas.tm.im.common.comm.service.util.IncomeInvoicePwyHelper;
import com.kingdee.eas.tm.im.param.TaxNoSumResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WebDownloadParser
extends AbstractIncomeInvoiceParser {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.msg.parser.WebDownloadParser");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncomeInvoiceCollection parse(Context ctx, Map params) throws BOSException, EASBizException, JSONException {
        String retInfo = (String)params.get("retInfo");
        TaxNoSumResult sumRet = null;
        if (params.get("sumRet") instanceof TaxNoSumResult) {
            sumRet = (TaxNoSumResult)params.get("sumRet");
        } else if (params.get("sumRet") instanceof Map) {
            sumRet = (TaxNoSumResult)JSONUtils.convertJsonToObject((Context)ctx, (String)JSONUtils.convertObjectToJson((Context)ctx, (Object)((Map)params.get("sumRet"))), TaxNoSumResult.class);
        }
        Map<String, CompanyOrgUnitInfo> companyMap = IncomeInvoicePwyHelper.matchPwySettingCompany(sumRet);
        JSONObject dataJson = new JSONObject(retInfo);
        String errcode = this.getStringValue(dataJson, "errcode");
        IncomeInvoiceCollection invoiceColl = new IncomeInvoiceCollection();
        IncomeInvoiceInfo invoiceInfo = null;
        IncomeInvoiceParser parser = null;
        String mutex = null;
        boolean lock = false;
        if (this.getSuccessCode().equals(errcode)) {
            JSONArray jsonArray = this.getJSONArray(dataJson, "data");
            if (jsonArray == null) {
                return invoiceColl;
            }
            int size = jsonArray.length();
            for (int i = 0; i < size; ++i) {
                block17: {
                    block16: {
                        block15: {
                            parser = new IncomeInvoiceParser(ctx, jsonArray.getJSONObject(i));
                            mutex = parser.getMutex();
                            lock = TMDBMutexHelper.requestDBMutex((Context)ctx, (String)mutex);
                            if (lock) break block15;
                            if (!lock) continue;
                            TMDBMutexHelper.releaseDBMutex((Context)ctx, (String)mutex);
                            lock = false;
                            continue;
                        }
                        invoiceInfo = parser.getIncomeInvoiceInfo();
                        if (invoiceInfo != null) break block16;
                        if (!lock) continue;
                        TMDBMutexHelper.releaseDBMutex((Context)ctx, (String)mutex);
                        lock = false;
                        continue;
                    }
                    if (!this.filterInvoice(invoiceInfo, params)) break block17;
                    if (!lock) continue;
                    TMDBMutexHelper.releaseDBMutex((Context)ctx, (String)mutex);
                    lock = false;
                    continue;
                }
                try {
                    IncomeInvoicePwyHelper.handleCompany(ctx, invoiceInfo, companyMap);
                    IncomeInvoicePwyHelper.handleSupplier(ctx, invoiceInfo);
                    if (invoiceInfo != null) {
                        invoiceInfo.setResourceType(InvResourceType.INV_DOWNLOAD);
                        IncomeInvoiceFactory.getLocalInstance(ctx).save((CoreBaseInfo)invoiceInfo);
                        invoiceColl.add(invoiceInfo);
                    }
                    if (!lock) continue;
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)e);
                        if (!lock) continue;
                    }
                    catch (Throwable throwable) {
                        if (lock) {
                            TMDBMutexHelper.releaseDBMutex((Context)ctx, mutex);
                            lock = false;
                        }
                        throw throwable;
                    }
                    TMDBMutexHelper.releaseDBMutex((Context)ctx, (String)mutex);
                    lock = false;
                    continue;
                }
                TMDBMutexHelper.releaseDBMutex((Context)ctx, (String)mutex);
                lock = false;
                continue;
            }
        }
        return invoiceColl;
    }

    @Override
    protected Map getFilterMap(Map params) {
        Map pwyData = (Map)params.get("pwyData");
        if (pwyData == null) {
            return null;
        }
        HashMap filterMap = new HashMap();
        filterMap.put("invoiceNumber", pwyData.get("invoiceNumber"));
        filterMap.put("invoiceCode", pwyData.get("invoiceCode"));
        filterMap.put("invoiceNo", pwyData.get("invoiceNo"));
        filterMap.put("status", params.get("status"));
        filterMap.put("invoiceTypes", pwyData.get("invoiceTypes"));
        return filterMap;
    }
}

