/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.msg.result;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.common.comm.msg.result.DownloadResult;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class IncomeInvoiceDownloadResult
extends DownloadResult {
    private static String KEY_AMOUNT = "amount";
    private static String KEY_TAX = "tax";
    private static String KEY_DETIAL = "detial";
    private Map<String, Map<String, BigDecimal>> specialInvoice = new HashMap<String, Map<String, BigDecimal>>();
    private Map<String, Map<String, BigDecimal>> commonInvoice = new HashMap<String, Map<String, BigDecimal>>();
    private Map<String, Map<String, BigDecimal>> elecInvoice = new HashMap<String, Map<String, BigDecimal>>();
    private Map<String, Map<String, BigDecimal>> elecSpecialInvoice = new HashMap<String, Map<String, BigDecimal>>();
    private int specialCount = 0;
    private BigDecimal specialAmount = BigDecimal.ZERO;
    private BigDecimal specialTax = BigDecimal.ZERO;
    private BigDecimal specialDetialCount = BigDecimal.ZERO;
    private int commonCount = 0;
    private BigDecimal commonAmount = BigDecimal.ZERO;
    private BigDecimal commonTax = BigDecimal.ZERO;
    private BigDecimal commonDetialCount = BigDecimal.ZERO;
    private int elecCount = 0;
    private BigDecimal elecAmount = BigDecimal.ZERO;
    private BigDecimal elecTax = BigDecimal.ZERO;
    private BigDecimal elecDetialCount = BigDecimal.ZERO;
    private int elecSpecialCount = 0;
    private BigDecimal elecSpecialAmount = BigDecimal.ZERO;
    private BigDecimal elecSpecialTax = BigDecimal.ZERO;
    private BigDecimal elecSpecialDetialCount = BigDecimal.ZERO;

    @Override
    public void add(IObjectValue objectValue) {
        IncomeInvoiceInfo invoiceInfo = (IncomeInvoiceInfo)objectValue;
        PayInvoiceTypeEnum invoiceType = invoiceInfo.getInvoiceType();
        String id = invoiceInfo.getId().toString();
        HashMap<String, BigDecimal> inf = new HashMap<String, BigDecimal>();
        inf.put(KEY_AMOUNT, invoiceInfo.getAmount());
        inf.put(KEY_TAX, invoiceInfo.getTax());
        inf.put(KEY_DETIAL, new BigDecimal(invoiceInfo.getEntries().size()));
        if (PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)invoiceType)) {
            this.specialInvoice.put(id, inf);
        } else if (PayInvoiceTypeEnum.COMMONINVOICE.equals((Object)invoiceType)) {
            this.commonInvoice.put(id, inf);
        } else if (PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)invoiceType)) {
            this.elecInvoice.put(id, inf);
        } else if (PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)invoiceType)) {
            this.elecSpecialInvoice.put(id, inf);
        }
    }

    @Override
    public void merge(DownloadResult result) {
        IncomeInvoiceDownloadResult ret = (IncomeInvoiceDownloadResult)result;
        this.specialInvoice.putAll(ret.getSpecialInvoice());
        this.commonInvoice.putAll(ret.getCommonInvoice());
        this.elecInvoice.putAll(ret.getElecInvoice());
        this.elecSpecialInvoice.putAll(ret.getElecSpecialInvoice());
        this.errMsgList.addAll(ret.getErrMsgList());
    }

    @Override
    public void calculate() {
        this.specialCount = this.specialInvoice.keySet().size();
        for (Map<String, BigDecimal> inf : this.specialInvoice.values()) {
            this.specialAmount = this.specialAmount.add(inf.get(KEY_AMOUNT));
            this.specialTax = this.specialTax.add(inf.get(KEY_TAX));
            this.specialDetialCount = this.specialDetialCount.add(inf.get(KEY_DETIAL));
        }
        this.commonCount = this.commonInvoice.keySet().size();
        for (Map<String, BigDecimal> inf : this.commonInvoice.values()) {
            this.commonAmount = this.commonAmount.add(inf.get(KEY_AMOUNT));
            this.commonTax = this.commonTax.add(inf.get(KEY_TAX));
            this.commonDetialCount = this.commonDetialCount.add(inf.get(KEY_DETIAL));
        }
        this.elecCount = this.elecInvoice.keySet().size();
        for (Map<String, BigDecimal> inf : this.elecInvoice.values()) {
            this.elecAmount = this.elecAmount.add(inf.get(KEY_AMOUNT));
            this.elecTax = this.elecTax.add(inf.get(KEY_TAX));
            this.elecDetialCount = this.elecDetialCount.add(inf.get(KEY_DETIAL));
        }
        this.elecSpecialCount = this.elecSpecialInvoice.keySet().size();
        for (Map<String, BigDecimal> inf : this.elecSpecialInvoice.values()) {
            this.elecSpecialAmount = this.elecSpecialAmount.add(inf.get(KEY_AMOUNT));
            this.elecSpecialTax = this.elecSpecialTax.add(inf.get(KEY_TAX));
            this.elecSpecialDetialCount = this.elecSpecialDetialCount.add(inf.get(KEY_DETIAL));
        }
    }

    @Override
    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    @Override
    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public Map<String, Map<String, BigDecimal>> getSpecialInvoice() {
        return this.specialInvoice;
    }

    public void setSpecialInvoice(Map<String, Map<String, BigDecimal>> specialInvoice) {
        this.specialInvoice = specialInvoice;
    }

    public Map<String, Map<String, BigDecimal>> getCommonInvoice() {
        return this.commonInvoice;
    }

    public void setCommonInvoice(Map<String, Map<String, BigDecimal>> commonInvoice) {
        this.commonInvoice = commonInvoice;
    }

    public Map<String, Map<String, BigDecimal>> getElecInvoice() {
        return this.elecInvoice;
    }

    public void setElecInvoice(Map<String, Map<String, BigDecimal>> eleclInvoice) {
        this.elecInvoice = eleclInvoice;
    }

    public int getSpecialCount() {
        return this.specialCount;
    }

    public void setSpecialCount(int specialCount) {
        this.specialCount = specialCount;
    }

    public BigDecimal getSpecialAmount() {
        return this.specialAmount;
    }

    public void setSpecialAmount(BigDecimal specialAmount) {
        this.specialAmount = specialAmount;
    }

    public BigDecimal getSpecialTax() {
        return this.specialTax;
    }

    public void setSpecialTax(BigDecimal specialTax) {
        this.specialTax = specialTax;
    }

    public BigDecimal getSpecialDetialCount() {
        return this.specialDetialCount;
    }

    public void setSpecialDetialCount(BigDecimal specialDetialCount) {
        this.specialDetialCount = specialDetialCount;
    }

    public int getCommonCount() {
        return this.commonCount;
    }

    public void setCommonCount(int commonCount) {
        this.commonCount = commonCount;
    }

    public BigDecimal getCommonAmount() {
        return this.commonAmount;
    }

    public void setCommonAmount(BigDecimal commonAmount) {
        this.commonAmount = commonAmount;
    }

    public BigDecimal getCommonTax() {
        return this.commonTax;
    }

    public void setCommonTax(BigDecimal commonTax) {
        this.commonTax = commonTax;
    }

    public BigDecimal getCommonDetialCount() {
        return this.commonDetialCount;
    }

    public void setCommonDetialCount(BigDecimal commonDetialCount) {
        this.commonDetialCount = commonDetialCount;
    }

    public int getElecCount() {
        return this.elecCount;
    }

    public void setElecCount(int elecCount) {
        this.elecCount = elecCount;
    }

    public BigDecimal getElecAmount() {
        return this.elecAmount;
    }

    public void setElecAmount(BigDecimal elecAmount) {
        this.elecAmount = elecAmount;
    }

    public BigDecimal getElecTax() {
        return this.elecTax;
    }

    public void setElecTax(BigDecimal elecTax) {
        this.elecTax = elecTax;
    }

    public BigDecimal getElecDetialCount() {
        return this.elecDetialCount;
    }

    public void setElecDetialCount(BigDecimal elecDetialCount) {
        this.elecDetialCount = elecDetialCount;
    }

    public Map<String, Map<String, BigDecimal>> getElecSpecialInvoice() {
        return this.elecSpecialInvoice;
    }

    public void setElecSpecialInvoice(Map<String, Map<String, BigDecimal>> elecSpecialInvoice) {
        this.elecSpecialInvoice = elecSpecialInvoice;
    }

    public int getElecSpecialCount() {
        return this.elecSpecialCount;
    }

    public void setElecSpecialCount(int elecSpecialCount) {
        this.elecSpecialCount = elecSpecialCount;
    }

    public BigDecimal getElecSpecialAmount() {
        return this.elecSpecialAmount;
    }

    public void setElecSpecialAmount(BigDecimal elecSpecialAmount) {
        this.elecSpecialAmount = elecSpecialAmount;
    }

    public BigDecimal getElecSpecialTax() {
        return this.elecSpecialTax;
    }

    public void setElecSpecialTax(BigDecimal elecSpecialTax) {
        this.elecSpecialTax = elecSpecialTax;
    }

    public BigDecimal getElecSpecialDetialCount() {
        return this.elecSpecialDetialCount;
    }

    public void setElecSpecialDetialCount(BigDecimal elecSpecialDetialCount) {
        this.elecSpecialDetialCount = elecSpecialDetialCount;
    }

    @Override
    public Set<String> getErrMsgList() {
        return this.errMsgList;
    }

    @Override
    public void setErrMsgList(Set<String> errMsgList) {
        this.errMsgList = errMsgList;
    }
}

