/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.ierp.api;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.common.comm.IMFreeMarkerInfo;
import com.kingdee.eas.tm.im.common.comm.LogStatusEnum;
import com.kingdee.eas.tm.im.common.comm.RemoteServiceInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.TransDestSystemEnum;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.model.ReqMsg;
import com.kingdee.eas.tm.im.common.comm.model.ResqMsg;
import com.kingdee.eas.tm.im.common.comm.msg.HttpSender4IERP;
import com.kingdee.eas.tm.im.common.comm.msg.template.TemplateUtil;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.LogService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.IERPLoginUtil;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractIERPService
implements IPwyService {
    private static Logger logger = Logger.getLogger((String)AbstractIERPService.class.getName());
    private Context ctx;
    private PwyInvokeParam invokeParam = null;
    private LogService logService = null;
    private int retryTimes = 0;
    private boolean isLogRetry = false;

    public AbstractIERPService(Context ctx, PwyInvokeParam invokeParam) {
        this.ctx = ctx;
        this.invokeParam = invokeParam;
        this.logService = new LogService();
    }

    public AbstractIERPService(Context ctx, TaxTransLogInfo pwyLog) {
        this.ctx = ctx;
        this.initInvokeParam(pwyLog);
        this.logService = new LogService();
        this.isLogRetry = true;
    }

    private void initInvokeParam(TaxTransLogInfo pwyLog) {
        try {
            String companyId = pwyLog.getCompany() != null ? pwyLog.getCompany().getId().toString() : null;
            PwyInvokeParam invokeParam = new PwyInvokeParam(pwyLog.getLogType(), pwyLog.getSrcSystem(), companyId, pwyLog.getInvoices(), null);
            invokeParam.setPwyLog(pwyLog);
            invokeParam.setUrl(pwyLog.getUrl());
            invokeParam.setSendMsg(pwyLog.getSendMsg());
            invokeParam.setRequestMsg(this.isNeedEncrypt() ? this.encryptData(pwyLog.getSendMsg()) : pwyLog.getSendMsg());
            invokeParam.setRevMsg(pwyLog.getRevMsg());
            this.invokeParam = invokeParam;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.invokeParam.setSuccess(false);
            this.invokeParam.setPartSuccess(false);
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    public void buildPwyParam(boolean isWriteLog) throws BOSException, EASBizException {
        if (this.invokeParam.getCommSettingInfo() == null) {
            this.invokeParam.setCommSettingInfo(PwyServiceHelper.getCommSetting(this.ctx));
        }
        if (this.invokeParam.getRemoteServiceInfo() == null) {
            this.invokeParam.setRemoteServiceInfo(this.getRemoteService());
        }
        if (this.invokeParam.getMsgSettingInfo() == null) {
            String msgType = this.invokeParam.getMsgType();
            if (!StringUtils.isEmpty((String)this.getPwyCzlx())) {
                msgType = this.getPwyCzlx();
            }
            this.invokeParam.setMsgSettingInfo(PwyServiceHelper.getMsgSetting(this.ctx, msgType));
        }
        if (this.getInvokeParam().getCompany() == null && !StringUtils.isEmpty((String)this.invokeParam.getOrgId())) {
            CompanyOrgUnitInfo org = BizInterfaceFactory.getCompanyOrgUnit(this.getCtx()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.invokeParam.getOrgId()));
            this.getInvokeParam().setCompany(org);
        }
        if (this.getInvokeParam().getCompany() != null) {
            FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
            fullOrgUnitInfo.setId(BOSUuid.read((String)this.getInvokeParam().getCompany().getId().toString()));
            this.invokeParam.setOrgUnit(fullOrgUnitInfo);
        }
        this.verify();
        this.invokeParam.setNeedEncrypt(this.isNeedEncrypt());
        this.invokeParam.setSendMode(this.getSendMode());
        this.invokeParam.setUrl(this.getPwyURL());
        if (this.invokeParam.getSendMsg() == null) {
            Map data = this.getPwyData();
            this.resolveSendData(data);
            this.invokeParam.setRequestMsg(this.isNeedEncrypt() ? this.encryptData(this.invokeParam.getSendMsg()) : this.invokeParam.getSendMsg());
        }
        this.invokeParam.setRetryTimes(this.getRetryTimes());
        TaxTransLogInfo pwyLog = null;
        pwyLog = this.createPwyLog();
        this.invokeParam.setPwyLog(pwyLog);
        this.invokeParam.setInit(true);
        if (isWriteLog) {
            this.updatePwyLog();
        }
    }

    protected abstract void verify() throws EASBizException, BOSException;

    protected void resolveSendData(Map data) throws EASBizException, BOSException {
        String sendMsg = null;
        sendMsg = this.getSendTemplate() != null && !StringUtils.isEmpty((String)this.getSendTemplate().getContext()) ? TemplateUtil.resolveTemplate(this.getSendTemplate(), data) : Kson.getGson().toJson((Object)data);
        this.invokeParam.setSendMsg(sendMsg);
    }

    @Override
    public void buildPwyParam() throws BOSException, EASBizException {
        this.buildPwyParam(true);
    }

    public String getPwyURL() throws EASBizException, BOSException {
        String url = this.getBaseURL() + this.getInterfacePath();
        if (this.isNeedToken() && !StringUtils.isEmpty((String)IERPLoginUtil.getCacheToken(this.getCtx(), this.getRemoteService()))) {
            url = url + "?access_token=" + IERPLoginUtil.getCacheToken(this.getCtx(), this.getRemoteService());
        }
        return url;
    }

    protected abstract Map getPwyData() throws EASBizException, BOSException;

    protected TaxTransLogInfo createPwyLog() throws EASBizException, BOSException {
        TaxTransLogInfo pwyLog = this.invokeParam.getPwyLog();
        if (pwyLog == null) {
            pwyLog = BizInterfaceFactory.getTaxTransLog(this.ctx).createNewData();
            pwyLog.setCompany(this.invokeParam.getOrgUnit());
            pwyLog.setUrl(this.invokeParam.getUrl());
            pwyLog.setSendMsg(this.invokeParam.getSendMsg());
            pwyLog.setLogType(PwyServiceType.getEnum(this.invokeParam.getMsgType()));
            pwyLog.setSrcSystem(TransSrcSystemEnum.getEnum(this.invokeParam.getOwnerSystem()));
            pwyLog.setDestSystem(TransDestSystemEnum.ifpy);
            pwyLog.setInvoices(this.invokeParam.getInvoices());
        }
        return pwyLog;
    }

    protected int getSendMode() {
        return 2;
    }

    protected int getRequestMode() {
        return 1;
    }

    protected LogService getLogService() {
        return this.logService;
    }

    public abstract String getBaseURL() throws EASBizException, BOSException;

    public String getInterfacePath() {
        if (this.invokeParam.getMsgSettingInfo() != null) {
            return this.invokeParam.getMsgSettingInfo().getInterfacePath() == null ? "" : this.invokeParam.getMsgSettingInfo().getInterfacePath();
        }
        return this.getDefaultInterfacePath();
    }

    public String getDefaultInterfacePath() {
        return "";
    }

    @Override
    public void updatePwyLog() throws EASBizException, BOSException {
        if (this.isNeedWriterLog()) {
            this.getLogService().updatePwyLog(this.ctx, this.invokeParam.getPwyLog());
        }
    }

    protected boolean isNeedWriterLog() {
        return this.invokeParam.isNeedWriterLog();
    }

    @Override
    public void invoke() throws BOSException, EASBizException {
        try {
            this.buildPwyParam();
            this.invokePwy();
            this.invokeAction();
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            this.invokeParam.setSuccess(false);
            this.invokeParam.setPartSuccess(false);
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    public void doInvoke() {
        try {
            this.invokePwy();
            this.invokeAction();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.invokeParam.setSuccess(false);
            this.invokeParam.setPartSuccess(false);
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    public void invokePwy() throws EASBizException, BOSException {
        this.retryTimes = this.getRetryTimes();
        do {
            ResqMsg msg = this.sendReq();
            this.resolveResp(msg);
            this.updatePwyLog();
            if ("3".equals(this.invokeParam.getPwyLog().getLogStatus().getValue())) {
                --this.retryTimes;
                continue;
            }
            this.retryTimes = 0;
        } while (this.isNeedRetry());
    }

    @Override
    public void reBuildPwyParam() throws BOSException, EASBizException {
        this.invokeParam.setUrl(this.getPwyURL());
        this.invokeParam.getPwyLog().setUrl(this.invokeParam.getUrl());
        this.updatePwyLog();
    }

    @Override
    public void invokeAction() throws EASBizException, BOSException {
        if ("2".equals(this.invokeParam.getPwyLog().getLogStatus().getValue())) {
            this.handleSuccess();
            this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.FINISH);
            this.updatePwyLog();
        }
    }

    @Override
    public void invokeAfter() {
        try {
            HashMap<String, String> resp = new HashMap<String, String>();
            resp.put("result", this.invokeParam.getRevMsg());
            ResqMsg msg = new ResqMsg();
            msg.setResp(resp);
            if (resp.get("errcode") != null) {
                msg.setRevMsg(Kson.getGson().toJson(resp));
                msg.setErrcode((String)resp.get("errcode"));
                msg.setDescription((String)resp.get("description"));
            } else {
                msg.setRevMsg((String)resp.get("result"));
                JSONObject retJson = new JSONObject(msg.getRevMsg());
                if (retJson.has("errcode")) {
                    msg.setErrcode(retJson.getString("errcode"));
                }
                if (retJson.has("description")) {
                    msg.setDescription(retJson.getString("description"));
                }
            }
            this.resolveResp(msg);
            this.updatePwyLog();
            this.invokeAction();
        }
        catch (Exception e2) {
            IMException e2;
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            if (e2 instanceof JSONException) {
                e2 = new IMException(IMException.CON_TIME_OUT);
            }
            this.invokeParam.setSuccess(false);
            this.invokeParam.setPartSuccess(false);
            this.setReturn(this.getUnKownCode(), ((Throwable)((Object)e2)).getMessage());
        }
    }

    @Override
    public boolean isSuccess() {
        return this.getSuccessCode().equals(this.invokeParam.getErrcode());
    }

    protected abstract void handleSuccess() throws EASBizException, BOSException;

    protected int getRetryTimes() {
        if (this.invokeParam.getMsgSettingInfo() != null) {
            return this.invokeParam.getMsgSettingInfo().getSendCount();
        }
        return this.getDefaultRetryTimes();
    }

    protected int getDefaultRetryTimes() {
        return 0;
    }

    protected boolean isNeedRetry() {
        return this.retryTimes > 0;
    }

    protected boolean isEnableCacheToken() {
        return true;
    }

    protected boolean isNeedToken() {
        return true;
    }

    protected ResqMsg sendReq() throws EASBizException, BOSException {
        if (this.isNeedToken() && (!this.isEnableCacheToken() || StringUtils.isEmpty((String)IERPLoginUtil.getCacheToken(this.getCtx(), this.getRemoteService())))) {
            IERPLoginUtil.login(this.ctx, this.getRemoteService(), this.invokeParam.getMsgSettingInfo().isIsDebug());
            this.reBuildPwyParam();
        }
        this.invokeParam.getPwyLog().setIsSended(true);
        this.updatePwyLog();
        HttpSender4IERP sender = new HttpSender4IERP();
        ResqMsg resqMsg = null;
        try {
            this.invokeParam.setSendTime(IMUtils.getCurrentTime());
            resqMsg = sender.send(this.ctx, this.buildReqMsg(this.invokeParam));
            if (this.isNeedToken() && IERPLoginUtil.isNotLogin(resqMsg.getRevMsgMap())) {
                IERPLoginUtil.login(this.ctx, this.getRemoteService(), this.invokeParam.getMsgSettingInfo().isIsDebug());
                this.reBuildPwyParam();
                resqMsg = this.sendReq();
            }
            this.invokeParam.setRevTime(IMUtils.getCurrentTime());
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            throw new BOSException(e);
        }
        return resqMsg;
    }

    protected ReqMsg buildReqMsg(PwyInvokeParam invokeParam) {
        return new ReqMsg(invokeParam);
    }

    protected boolean isNeedEncrypt() {
        return false;
    }

    protected String encryptData(String data) throws EASBizException, BOSException {
        if (this.getRemoteService() == null || StringUtils.isEmpty((String)this.getRemoteService().getPublicKey())) {
            return data;
        }
        return BizInterfaceFactory.getIMInvoiceFacade(this.ctx).encryptAES(data, this.getRemoteService().getPublicKey());
    }

    protected void resolveResp(ResqMsg msg) throws EASBizException, BOSException {
        try {
            this.preResoleResp(msg);
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        this.invokeParam.setResqMsg(msg);
        this.invokeParam.setRevMsg(msg.getRevMsg());
        this.invokeParam.getPwyLog().setRevMsg(msg.getRevMsg());
        if (this.invokeParam.getSendTime() != null) {
            this.invokeParam.getPwyLog().setSendTime(new Timestamp(this.invokeParam.getSendTime().getTime()));
        }
        if (this.invokeParam.getRevTime() != null) {
            this.invokeParam.getPwyLog().setRevTime(new Timestamp(this.invokeParam.getRevTime().getTime()));
        }
        this.invokeParam.setErrcode(msg.getErrcode());
        this.invokeParam.setDescription(msg.getDescription());
        if (this.getSuccessCode().equals(msg.getErrcode())) {
            this.invokeParam.setSuccess(true);
            this.resolveSuccess();
            if (this.isNeedReverse()) {
                this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.SUCCESS);
            } else {
                this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.FINISH);
                this.invokeParam.getPwyLog().setDescription(null);
            }
        } else if (this.getUnKownCode().equals(msg.getErrcode())) {
            this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.FAILURE);
            this.invokeParam.getPwyLog().setDescription(msg.getDescription());
        } else {
            this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.FAILURE);
        }
    }

    protected void preResoleResp(ResqMsg msg) throws JSONException {
    }

    protected void setReturn(String errorCode, String description) {
        this.invokeParam.setErrcode(errorCode);
        this.invokeParam.setDescription(description);
    }

    protected String getUnKownCode() {
        return "60000";
    }

    protected void resolveSuccess() throws EASBizException, BOSException {
    }

    protected void resolvePartSuccess() throws EASBizException, BOSException {
    }

    protected boolean isNeedReverse() {
        return false;
    }

    public abstract String getPwyCzlx();

    public RemoteServiceInfo getRemoteService() throws EASBizException, BOSException {
        if (this.invokeParam.getMsgSettingInfo() != null && this.invokeParam.getMsgSettingInfo().getRemoteService() != null) {
            return this.invokeParam.getMsgSettingInfo().getRemoteService();
        }
        return null;
    }

    public IMFreeMarkerInfo getSendTemplate() {
        if (this.invokeParam.getMsgSettingInfo() != null && this.invokeParam.getMsgSettingInfo().getSendTemplate() != null) {
            return this.invokeParam.getMsgSettingInfo().getSendTemplate();
        }
        return null;
    }

    public IMFreeMarkerInfo getResultTemplate() {
        if (this.invokeParam.getMsgSettingInfo() != null && this.invokeParam.getMsgSettingInfo().getResultTemplate() != null) {
            return this.invokeParam.getMsgSettingInfo().getResultTemplate();
        }
        return null;
    }

    public abstract String getSuccessCode();

    @Override
    public PwyInvokeParam getInvokeParam() {
        return this.invokeParam;
    }

    public void setInvokeParam(PwyInvokeParam invokeParam) {
        this.invokeParam = invokeParam;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void setLogService(LogService logService) {
        this.logService = logService;
    }

    public boolean isLogRetry() {
        return this.isLogRetry;
    }

    public void setLogRetry(boolean isLogRetry) {
        this.isLogRetry = isLogRetry;
    }
}

