/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.ierp.callback;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.ServiceException;
import com.kingdee.eas.tm.im.common.comm.TaxMsgSettingCollection;
import com.kingdee.eas.tm.im.common.comm.TaxMsgSettingInfo;
import com.kingdee.eas.tm.im.common.comm.service.ICallBackService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;

public class IERPCallBackFactory {
    private static Logger logger = Logger.getLogger(IERPCallBackFactory.class);

    public static ICallBackService getSIMCallBackService(Context ctx, String interfaceCode) throws EASBizException, BOSException {
        ICallBackService callBackService = null;
        TaxMsgSettingInfo settingInfo = IERPCallBackFactory.getSIMMsgSetting(ctx, interfaceCode);
        if (settingInfo != null && !StringUtils.isEmpty((String)settingInfo.getInterfaceImpClass())) {
            try {
                Class<?> interfaceImpClass = Class.forName(settingInfo.getInterfaceImpClass());
                Constructor<?> constructor = interfaceImpClass.getDeclaredConstructor(Context.class, TaxMsgSettingInfo.class);
                callBackService = (ICallBackService)constructor.newInstance(ctx, settingInfo);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (callBackService == null) {
            throw new ServiceException(ServiceException.EPX_INTERFACECODE_NOTHANDLER, new Object[]{interfaceCode});
        }
        return callBackService;
    }

    public static TaxMsgSettingInfo getSIMMsgSetting(Context ctx, String interfacaceCode) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("interfacaceCode", (Object)interfacaceCode, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("msgType", (Object)"sim1%", CompareType.LIKE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("sendTemplate.*");
        sic.add("resultTemplate.*");
        sic.add("remoteService.*");
        sic.add("remoteService.localService.*");
        view.setSelector(sic);
        TaxMsgSettingCollection coll = BizInterfaceFactory.getTaxMsgSetting(ctx).getTaxMsgSettingCollection(view);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }
}

