/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.incomeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.incomeinvoice.IncomeInvoiceDiskPwyService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class IncomeInvoiceBatchPwyService
extends IncomeInvoiceDiskPwyService {
    private List<IncomeInvoiceInfo> invoices;
    private List<IncomeInvoiceInfo> successInvoices = new ArrayList<IncomeInvoiceInfo>();
    private List<IncomeInvoiceInfo> failInvoices = new ArrayList<IncomeInvoiceInfo>();
    private Map<String, IncomeInvoiceInfo> invoiceMap = new HashMap<String, IncomeInvoiceInfo>();

    public IncomeInvoiceBatchPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public IncomeInvoiceBatchPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public void buildPwyParam(boolean isWriteLog) throws EASBizException, BOSException {
        super.buildPwyParam(isWriteLog);
        this.invoices = this.getInvokeParam().getValues();
        this.successInvoices.addAll(this.invoices);
        IncomeInvoiceInfo invoice2 = null;
        for (IncomeInvoiceInfo invoice2 : this.invoices) {
            this.invoiceMap.put(invoice2.getInvoiceNumber() + "-" + invoice2.getInvoiceCode(), invoice2);
        }
    }

    protected String getInvoiceIds() {
        StringBuffer invoiceIds = new StringBuffer();
        IncomeInvoiceInfo invoice = null;
        for (int i = 0; i < this.getInvoices().size(); ++i) {
            invoice = this.getInvoices().get(i);
            if (i > 0) {
                invoiceIds.append(",");
            }
            invoiceIds.append(invoice.getId().toString());
        }
        return invoiceIds.toString();
    }

    public List<IncomeInvoiceInfo> getInvoices() {
        return this.invoices;
    }

    public void setInvoices(List<IncomeInvoiceInfo> invoices) {
        this.invoices = invoices;
    }

    public List<IncomeInvoiceInfo> getSuccessInvoices() {
        return this.successInvoices;
    }

    public void setSuccessInvoices(List<IncomeInvoiceInfo> successInvoices) {
        this.successInvoices = successInvoices;
    }

    public List<IncomeInvoiceInfo> getFailInvoices() {
        return this.failInvoices;
    }

    public void setFailInvoices(List<IncomeInvoiceInfo> failInvoices) {
        this.failInvoices = failInvoices;
    }

    public Map<String, IncomeInvoiceInfo> getInvoiceMap() {
        List invoices = null;
        try {
            invoices = this.getValues();
            IncomeInvoiceInfo invoice2 = null;
            for (IncomeInvoiceInfo invoice2 : invoices) {
                this.invoiceMap.put(invoice2.getInvoiceNumber() + "-" + invoice2.getInvoiceCode(), invoice2);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return this.invoiceMap;
    }

    public void setInvoiceMap(Map<String, IncomeInvoiceInfo> invoiceMap) {
        this.invoiceMap = invoiceMap;
    }
}

