/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.incomeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.tm.im.IIMFacade;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.incomeinvoice.IncomeInvoiceWebPwyService;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.util.Map;
import org.apache.log4j.Logger;

public class IncomeInvoiceExpenseService
extends IncomeInvoiceWebPwyService {
    private static final Logger logger = Logger.getLogger(IncomeInvoiceExpenseService.class);

    public IncomeInvoiceExpenseService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public IncomeInvoiceExpenseService(Context ctx, TaxTransLogInfo logInfo) {
        super(ctx, logInfo);
    }

    @Override
    protected Map getPwyData() throws EASBizException, BOSException {
        return this.getInvokeParam().getParams();
    }

    @Override
    public String getBaseURL() {
        return null;
    }

    @Override
    public String getPwyCzlx() {
        return "9007";
    }

    @Override
    protected boolean isNeedEncrypt() {
        return false;
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    public String getDefaultInterfacePath() {
        return "/m4/bill/fpzs/expense/invoices/query/temp";
    }

    @Override
    public void invoke() {
        try {
            TaxTransLogInfo pwyLog = this.getInvokeParam().getPwyLog();
            if (pwyLog == null || StringUtils.isEmpty((String)pwyLog.getLogDetail())) {
                logger.error((Object)"pwyLog is null");
                this.getInvokeParam().setSuccess(false);
                this.getInvokeParam().setDescription(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "pwylog_bizBillIDIsNull", IMUtils.getLocale()));
                return;
            }
            String bizBillID = pwyLog.getLogDetail();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)bizBillID, CompareType.INCLUDE));
            CoreBaseCollection collection = null;
            IIMFacade imFacade = null;
            imFacade = this.getCtx() == null ? IMFacadeFactory.getRemoteInstance() : IMFacadeFactory.getLocalInstance(this.getCtx());
            collection = imFacade.getCollectionByBosType(BOSUuid.read((String)bizBillID).getType().toString(), filter);
            if (collection != null && collection.size() > 0) {
                imFacade.downloadInvoiceByBXD(collection.get(0));
            } else {
                this.getInvokeParam().setSuccess(false);
                this.getInvokeParam().setDescription(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "bizAccountBill_notFound", IMUtils.getLocale(), new Object[]{pwyLog.getInvoiceNumber()}));
            }
            this.getInvokeParam().setSuccess(true);
        }
        catch (Exception e) {
            this.getInvokeParam().setSuccess(false);
            this.getInvokeParam().setPartSuccess(false);
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    protected boolean isNeedWriterLog() {
        return false;
    }
}

