/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.incomeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.AddSyncMsg;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.pool.PoolWebPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.common.logger.IMLoggerFactory;
import com.kingdee.eas.tm.im.common.logger.IMTraceLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvoiceAddBatchNoPwyService
extends PoolWebPwyService {
    private static IMTraceLogger logger = IMLoggerFactory.getTraceLogger("InvoiceAddBatchNoPwyService");
    private InvoiceAddBatchNoPwyService nextService = null;
    private int totalPage = 0;
    private int currentPage = 0;
    private List<AddSyncMsg> addSyncList = new ArrayList<AddSyncMsg>();

    public InvoiceAddBatchNoPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public InvoiceAddBatchNoPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public String getPwyCzlx() {
        return "1004";
    }

    @Override
    public List getValues() throws EASBizException, BOSException {
        return null;
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    protected Map getPwyData() throws EASBizException, BOSException {
        Object currentPage;
        Object pageSize;
        Map pwyDataMap = (Map)this.getInvokeParam().getParams().get("pwyData");
        if (pwyDataMap.containsKey("pageSize") && (pageSize = pwyDataMap.get("pageSize")) != null) {
            int pageSizeNum = Double.valueOf(pageSize.toString()).intValue();
            pwyDataMap.put("pageSize", pageSizeNum);
        }
        if (pwyDataMap.containsKey("currentPage") && (currentPage = pwyDataMap.get("currentPage")) != null) {
            int currentPageNum = Double.valueOf(currentPage.toString()).intValue();
            pwyDataMap.put("currentPage", currentPageNum);
        }
        return pwyDataMap;
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        logger.error("enter InvoiceAddLogsPwyService handleSuccess.");
        this.invokeNextPage();
        logger.error("exit InvoiceAddLogsPwyService handleSuccess.");
    }

    private void handleResult() {
        Map pwyDataMap = (Map)this.getInvokeParam().getParams().get("pwyData");
        String taxNo = (String)pwyDataMap.get("taxNo");
        try {
            JSONObject queryResultJson = new JSONObject(this.getInvokeParam().getRevMsg());
            String errorCode = queryResultJson.getString("errcode");
            if ("0000".equals(errorCode)) {
                JSONArray invoiceArray = queryResultJson.getJSONArray("data");
                int size = invoiceArray.length();
                for (int i = 0; i < size; ++i) {
                    AddSyncMsg addSyncMsg = new AddSyncMsg();
                    addSyncMsg.setBatchNo(invoiceArray.getString(i));
                    addSyncMsg.setTaxNo(taxNo);
                    addSyncMsg.setOrgId(this.getInvokeParam().getOrgId());
                    addSyncMsg.setParams(this.getInvokeParam().getParams());
                    this.addSyncList.add(addSyncMsg);
                }
            }
        }
        catch (JSONException e) {
            logger.error("InvoiceAddBatchNoPwyService: parse error " + (Object)((Object)e));
        }
        Map ret = this.getInvokeParam().getInvokeActionMap();
        if (!ret.isEmpty()) {
            List retAddSyncList = (List)ret.get("addSyncList");
            retAddSyncList.addAll(this.addSyncList);
            ret.put("addSyncList", retAddSyncList);
        } else {
            ret.put("addSyncList", this.addSyncList);
        }
        this.getInvokeParam().setInvokeActionMap(ret);
    }

    @Override
    protected void resolveSuccess() {
        JSONObject retJson = null;
        try {
            retJson = new JSONObject(this.getInvokeParam().getRevMsg());
            if ("0000".equals(retJson.get("errcode"))) {
                this.totalPage = retJson.getInt("totalPage");
                this.currentPage = retJson.getInt("currentPage");
            }
        }
        catch (JSONException e) {
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    protected void invokeNextPage() throws BOSException, EASBizException {
        this.handleResult();
        ++this.currentPage;
        if (this.currentPage <= this.totalPage) {
            Map pwyData = this.getPwyData();
            pwyData.put("currentPage", this.currentPage);
            HashMap<String, Map> newParams = new HashMap<String, Map>();
            newParams.putAll(this.getInvokeParam().getParams());
            newParams.put("pwyData", pwyData);
            PwyInvokeParam invokeParam = PwyInvokeParam.newPwyInvokeParam(this.getInvokeParam());
            invokeParam.setParams(newParams);
            invokeParam.setInit(true);
            invokeParam.setInvokeActionMap(this.getInvokeParam().getInvokeActionMap());
            this.nextService = (InvoiceAddBatchNoPwyService)PwyServiceHelper.getPwyService(this.getCtx(), invokeParam);
            this.nextService.invoke();
        }
    }

    public InvoiceAddBatchNoPwyService getNextService() {
        return this.nextService;
    }

    public void setNextService(InvoiceAddBatchNoPwyService nextService) {
        this.nextService = nextService;
    }
}

