/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.incomeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.incomeinvoice.IncomeInvoiceDiskPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class InvoiceQueryAuthDetailPwyService
extends IncomeInvoiceDiskPwyService {
    public InvoiceQueryAuthDetailPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public InvoiceQueryAuthDetailPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public String getDefaultInterfacePath() {
        return "/invdataauth";
    }

    @Override
    public Map getPwyData() {
        PwyInvokeParam invokeParam = this.getInvokeParam().getBeforeInvokeParam().get("9004");
        if (invokeParam != null && invokeParam.isSuccess()) {
            this.getInvokeParam().setToken(invokeParam.getToken());
        }
        Map map = this.getInvokeParam().getParams();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("access_token", this.getInvokeParam().getToken());
        body.put("fphm", (String)map.get("fphm"));
        body.put("fpdm", (String)map.get("fpdm"));
        body.put("startdate", (String)map.get("rq_q"));
        body.put("enddate", (String)map.get("rq_z"));
        body.put("fplx", "-1");
        body.put("fpzt", "-1");
        String taxNo = this.getInvokeParam().getCompany().getTaxNumber();
        if (!StringUtils.isEmpty((String)taxNo)) {
            taxNo = taxNo.trim();
        }
        body.put("nsrsbh", taxNo);
        return body;
    }

    @Override
    public String getPwyCzlx() {
        return "8009";
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    public boolean isNeedToken() {
        return true;
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("retInfo", this.getInvokeParam().getRevMsg());
        params.put("orgid", this.getInvokeParam().getOrgId());
        params.put("parserClass", "com.kingdee.eas.tm.im.common.comm.msg.parser.IncomeInvoiceDownloadDetailParser");
        Map retValue = BizInterfaceFactory.getIncomeInvoiceReWriteFacade(this.getCtx()).billQueryDownload(params);
        this.getInvokeParam().setInvokeActionMap(retValue);
    }
}

