/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.makeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.PaperPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RedInvoiceQueryPwyService
extends PaperPwyService {
    public RedInvoiceQueryPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public RedInvoiceQueryPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public void buildPwyParam(boolean isWriteLog) throws BOSException, EASBizException {
        super.buildPwyParam(isWriteLog);
        PwyInvokeParam invokeParam = new PwyInvokeParam();
        invokeParam.setMsgType("9");
        invokeParam.setOwnerSystem(this.getInvokeParam().getOwnerSystem());
        invokeParam.setOrgId(this.getInvokeParam().getOrgId());
        invokeParam.setSetting(this.getInvokeParam().getSetting());
        invokeParam.setClientId(this.getInvokeParam().getClientId());
        invokeParam.setClientSecret(this.getInvokeParam().getClientSecret());
        invokeParam.setInit(true);
        IPwyService service = PwyServiceHelper.getPwyService(this.getCtx(), invokeParam);
        service.buildPwyParam();
        this.getInvokeParam().getBeforeInvokeParam().put(invokeParam.getMsgType(), invokeParam);
    }

    @Override
    public Map getPwySjd() throws EASBizException, BOSException {
        Map params = this.getInvokeParam().getParams();
        String deviceNum = null;
        String invoiceDeviceNo = null;
        String qynsrsbh = null;
        PwyInvokeParam invokeParam = this.getInvokeParam().getBeforeInvokeParam().get("9");
        if (invokeParam != null && invokeParam.isSuccess()) {
            try {
                JSONObject jsonObj = new JSONObject(invokeParam.getRevMsg());
                String sjd = jsonObj.get("sjd").toString();
                JSONObject sjdJson = new JSONObject(sjd);
                if (sjdJson.has("jsph")) {
                    deviceNum = sjdJson.get("jsph").toString();
                }
                if (sjdJson.has("jspjh")) {
                    invoiceDeviceNo = sjdJson.get("jspjh").toString();
                }
                qynsrsbh = sjdJson.get("qynsrsbh").toString();
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage());
            }
        }
        if (StringUtils.isEmpty(deviceNum)) {
            deviceNum = this.getNotNullValue(params, "deviceNum");
        }
        if (StringUtils.isEmpty(invoiceDeviceNo)) {
            invoiceDeviceNo = this.getNotNullValue(params, "invoiceDeviceNo");
        }
        if (StringUtils.isEmpty(qynsrsbh)) {
            qynsrsbh = this.getNotNullValue(params, "qynsrsbh");
        }
        String beginDate = this.getNotNullValue(params, "beginDate");
        String endDate = this.getNotNullValue(params, "endDate");
        String purchaserTaxNum = this.getNotNullValue(params, "purchaserTaxNum");
        String salesTaxNum = this.getNotNullValue(params, "salesTaxNum");
        String infoNum = this.getNotNullValue(params, "infoNum");
        HashMap<String, String> sjdMap = new HashMap<String, String>();
        sjdMap.put("kjf_jh", invoiceDeviceNo);
        sjdMap.put("kjf_nsrsbh", salesTaxNum);
        sjdMap.put("kjf_sbbh", deviceNum);
        sjdMap.put("qstkrq", beginDate);
        sjdMap.put("jstkrq", endDate);
        sjdMap.put("xhf_nsrsbh", salesTaxNum);
        sjdMap.put("ghf_nsrsbh", purchaserTaxNum);
        sjdMap.put("xxbbh", infoNum);
        sjdMap.put("xzfw", "2");
        sjdMap.put("yqzt", "N");
        if (!StringUtils.isEmpty((String)qynsrsbh)) {
            sjdMap.put("kjf_nsrsbh", qynsrsbh);
        }
        sjdMap.put("pageno", "1");
        sjdMap.put("pagesize", "99999");
        return sjdMap;
    }

    protected String getNotNullValue(Map data, String key) {
        String valueStr;
        String value = "";
        if (data.get(key) != null && (valueStr = data.get(key).toString()) != null && valueStr.length() > 0) {
            value = valueStr;
        }
        return value;
    }

    @Override
    public String getPwyCzlx() {
        return "18";
    }

    @Override
    public String getSuccessCode() {
        return "0000";
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        ArrayList<Object> redJson = new ArrayList<Object>();
        redJson.add(this.getInvokeParam().getCompany());
        redJson.add(this.getInvokeParam().getRevMsg());
        Map result = BizInterfaceFactory.getIMInvoiceFacade(this.getCtx()).downLoadRedInvoice(redJson);
        this.getInvokeParam().setInvokeActionMap(result);
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }
}

