/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.poolsync;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.common.comm.IMCommException;
import com.kingdee.eas.tm.im.common.comm.LogStatusEnum;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.TransDestSystemEnum;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.constant.PoolSyncConstant;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.model.ReqMsg;
import com.kingdee.eas.tm.im.common.comm.model.ResqMsg;
import com.kingdee.eas.tm.im.common.comm.msg.HttpSender;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.LogService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.PoolSyncLoginUtil;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.ws.app.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class PoolSyncPwyService
implements IPwyService {
    private static Logger logger = Logger.getLogger((String)PoolSyncPwyService.class.getName());
    private Context ctx;
    private PwyInvokeParam invokeParam = new PwyInvokeParam();
    private LogService logService = null;
    private int retryTimes = 0;

    public PoolSyncPwyService(Context ctx, PwyInvokeParam invokeParam) {
        this.ctx = ctx;
        this.logService = new LogService();
        this.invokeParam = invokeParam;
    }

    public PoolSyncPwyService(Context ctx, TaxTransLogInfo pwyLog) throws BOSException {
        this.ctx = ctx;
        this.logService = new LogService();
        this.invokeParam = this.createInvokeParamByLog(pwyLog);
    }

    protected PwyInvokeParam createInvokeParamByLog(TaxTransLogInfo pwyLog) throws BOSException {
        Map paramMap = new HashMap();
        String logDetail = pwyLog.getLogDetail();
        if (!StringUtils.isEmpty((String)logDetail)) {
            paramMap = (Map)JSONUtils.convertJsonToObject((Context)this.ctx, (String)logDetail, Map.class);
        }
        String companyId = pwyLog.getCompany() != null ? pwyLog.getCompany().getId().toString() : null;
        PwyInvokeParam invokeParam = new PwyInvokeParam(pwyLog.getLogType(), pwyLog.getSrcSystem(), companyId, pwyLog.getInvoices(), paramMap);
        invokeParam.setPwyLog(pwyLog);
        return invokeParam;
    }

    @Override
    public void invoke() {
        try {
            this.buildPwyParam();
            this.invokePwy();
            this.invokeAction();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            try {
                this.updatePwyLog();
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
            this.invokeParam.setSuccess(false);
            this.invokeParam.setPartSuccess(false);
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    public void buildPwyParam() throws BOSException, EASBizException {
        this.invokeParam.setCommSettingInfo(PwyServiceHelper.getCommSetting(this.ctx));
        String msgType = this.invokeParam.getMsgType();
        this.invokeParam.setMsgSettingInfo(PwyServiceHelper.getMsgSetting(this.ctx, msgType));
        this.invokeParam.setCompany(BizInterfaceFactory.getCompanyOrgUnit(this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.getInvokeParam().getOrgId())));
        FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
        orgUnitInfo.setId(BOSUuid.read((String)this.getInvokeParam().getOrgId()));
        this.invokeParam.setOrgUnit(orgUnitInfo);
        this.initPwySetting();
        this.invokeParam.setNeedEncrypt(this.isNeedEncrypt());
        this.invokeParam.setSendMode(this.getSendMode());
        this.invokeParam.setUrl(this.getPwyURL());
        Object data = this.getPwyData();
        String sendMsg = Kson.getGson().toJson(data);
        this.invokeParam.setSendMsg(sendMsg);
        this.invokeParam.setRetryTimes(this.getRetryTimes());
        this.createPwyLog();
        this.invokeParam.setRequestMsg(this.isNeedEncrypt() ? this.encryptData(this.invokeParam.getSendMsg()) : this.invokeParam.getSendMsg());
    }

    protected void createPwyLog() throws BOSException, EASBizException {
        TaxTransLogInfo pwyLog = this.invokeParam.getPwyLog();
        if (pwyLog == null) {
            pwyLog = BizInterfaceFactory.getTaxTransLog(this.ctx).createNewData();
            this.invokeParam.setPwyLog(pwyLog);
        }
        pwyLog.setCompany(this.invokeParam.getOrgUnit());
        pwyLog.setUrl(this.invokeParam.getUrl());
        pwyLog.setSendMsg(this.invokeParam.getSendMsg());
        pwyLog.setLogType(PwyServiceType.getEnum(this.invokeParam.getMsgType()));
        pwyLog.setSrcSystem(TransSrcSystemEnum.getEnum(this.invokeParam.getOwnerSystem()));
        pwyLog.setDestSystem(TransDestSystemEnum.pwy);
        pwyLog.setInvoices(this.invokeParam.getInvoices());
        if (this.invokeParam.getParams() != null) {
            if (this.invokeParam.getParams().get("billInfo") != null && this.invokeParam.getParams().get("billInfo") instanceof CoreBillBaseInfo) {
                CoreBillBaseInfo info = (CoreBillBaseInfo)this.invokeParam.getParams().get("billInfo");
                this.invokeParam.getParams().put("billInfo", info.getNumber());
            }
            pwyLog.setLogDetail(Kson.getGson().toJson((Object)this.invokeParam.getParams()));
            String billnumber = (String)this.getInvokeParam().getParams().get("bizBillNumber");
            pwyLog.setInvoiceNumber(billnumber);
        }
        this.updatePwyLog();
    }

    protected void initPwySetting() throws EASBizException, BOSException {
        Map params = this.invokeParam.getParams();
        String sourceType = (String)params.get("sourceType");
        CompanyOrgUnitInfo company = this.invokeParam.getCompany();
        if (PoolSyncConstant.SourceTypeEnum.OTHERBILL.equals(sourceType)) {
            PwySettingInfo setting = BizInterfaceFactory.getPwySetting(this.ctx).getCollectionByCompany(this.invokeParam.getOrgId(), OPTypeEnum.RecInvoice, null, null);
            if (setting == null) {
                throw new IMException(IMException.ERRORMSG, new Object[]{company.getName() + IMUtils.getIMResource(this.getCtx(), "NO_PWYSETTING", new String[0])});
            }
            this.getInvokeParam().setClientId(setting.getClientId());
            this.getInvokeParam().setClientSecret(setting.getClientSecret());
            this.getInvokeParam().setPublicKey(setting.getSecretKey());
        } else if (PoolSyncConstant.SourceTypeEnum.EXPENSE.equals(sourceType)) {
            this.getInvokeParam().setClientId(company.getAuthorizationCode());
            this.getInvokeParam().setClientSecret(company.getAuthorizationKey());
        }
        if (StringUtils.isEmpty((String)this.getInvokeParam().getClientId()) || StringUtils.isEmpty((String)this.getInvokeParam().getClientSecret())) {
            throw new IMCommException(IMCommException.EXP_AUTHORIZATION_ISNULL);
        }
    }

    protected String encryptData(String data) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)this.invokeParam.getPublicKey())) {
            return BizInterfaceFactory.getIMInvoiceFacade(this.ctx).encryptAES(data, this.invokeParam.getPublicKey());
        }
        return data;
    }

    @Override
    public void invokePwy() throws EASBizException, BOSException {
        this.retryTimes = this.getRetryTimes();
        do {
            ResqMsg msg = this.sendReq();
            this.resolveResp(msg);
            this.updatePwyLog();
            if ("3".equals(this.invokeParam.getPwyLog().getLogStatus().getValue())) {
                --this.retryTimes;
                continue;
            }
            this.retryTimes = 0;
        } while (this.isNeedRetry());
    }

    protected ResqMsg sendReq() throws EASBizException, BOSException {
        if (this.isNeedToken() && StringUtils.isEmpty((String)PoolSyncLoginUtil.getToken(this.getCtx(), this.invokeParam))) {
            PoolSyncLoginUtil.login(this.ctx, this.invokeParam);
            this.reBuildPwyParam();
        }
        this.invokeParam.getPwyLog().setIsSended(true);
        this.updatePwyLog();
        HttpSender sender = new HttpSender();
        ResqMsg resqMsg = null;
        try {
            this.invokeParam.setSendTime(IMUtils.getCurrentTime());
            resqMsg = sender.send(this.ctx, new ReqMsg(this.invokeParam));
            if (this.isNeedToken() && PoolSyncLoginUtil.isNotLogin(resqMsg)) {
                PoolSyncLoginUtil.login(this.ctx, this.invokeParam);
                this.reBuildPwyParam();
                resqMsg = this.sendReq();
            }
            this.invokeParam.setRevTime(IMUtils.getCurrentTime());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return resqMsg;
    }

    @Override
    public void reBuildPwyParam() throws BOSException, EASBizException {
        this.invokeParam.setUrl(this.getPwyURL());
        this.invokeParam.getPwyLog().setUrl(this.invokeParam.getUrl());
        this.updatePwyLog();
    }

    protected void resolveResp(ResqMsg msg) {
        this.invokeParam.setResqMsg(msg);
        this.invokeParam.setRevMsg(msg.getRevMsg());
        this.invokeParam.getPwyLog().setRevMsg(msg.getRevMsg());
        if (this.invokeParam.getSendTime() != null) {
            this.invokeParam.getPwyLog().setSendTime(new Timestamp(this.invokeParam.getSendTime().getTime()));
        }
        if (this.invokeParam.getRevTime() != null) {
            this.invokeParam.getPwyLog().setRevTime(new Timestamp(this.invokeParam.getRevTime().getTime()));
        }
        this.invokeParam.setErrcode(msg.getErrcode());
        this.invokeParam.setDescription(msg.getDescription());
        if (this.getSuccessCode().equals(msg.getErrcode())) {
            this.invokeParam.setSuccess(true);
            this.resolveSuccess();
            if (this.isNeedReverse()) {
                this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.SUCCESS);
            } else {
                this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.FINISH);
                this.invokeParam.getPwyLog().setDescription(null);
            }
        } else if (this.getPartSuccessCode() != null && this.getPartSuccessCode().equals(msg.getErrcode())) {
            this.invokeParam.setPartSuccess(true);
            this.resolvePartSuccess();
            if (this.isNeedReverse()) {
                this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.SUCCESS);
            } else {
                this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.FINISH);
                this.invokeParam.getPwyLog().setDescription(null);
            }
        } else if (this.getUnKownCode().equals(msg.getErrcode())) {
            this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.FAILURE);
            this.invokeParam.getPwyLog().setDescription(msg.getDescription());
        } else {
            this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.FAILURE);
        }
    }

    @Override
    public void invokeAction() throws EASBizException, BOSException {
        if ("2".equals(this.invokeParam.getPwyLog().getLogStatus().getValue())) {
            this.handleSuccess();
            this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.FINISH);
            this.updatePwyLog();
        }
    }

    protected boolean isNeedToken() {
        return false;
    }

    public String getPwyURL() {
        String url = this.getBaseURL() + this.getInterfacePath();
        if (this.isNeedToken() && !StringUtils.isEmpty((String)PoolSyncLoginUtil.getToken(this.getCtx(), this.invokeParam))) {
            url = url + "?access_token=" + PoolSyncLoginUtil.getToken(this.getCtx(), this.invokeParam);
        }
        return url;
    }

    protected abstract Object getPwyData() throws EASBizException, BOSException;

    protected int getSendMode() {
        return 2;
    }

    protected int getRequestMode() {
        return 1;
    }

    protected LogService getLogService() {
        return this.logService;
    }

    public String getBaseURL() {
        return PwyServiceHelper.getBaseUrl(this.getInvokeParam().getCommSettingInfo());
    }

    public String getInterfacePath() {
        if (this.invokeParam.getMsgSettingInfo() != null) {
            return this.invokeParam.getMsgSettingInfo().getInterfacePath() == null ? "" : this.invokeParam.getMsgSettingInfo().getInterfacePath();
        }
        return this.getDefaultInterfacePath();
    }

    public String getDefaultInterfacePath() {
        return "";
    }

    @Override
    public void updatePwyLog() throws EASBizException, BOSException {
        if (this.isNeedWriterLog()) {
            this.getLogService().updatePwyLog(this.ctx, this.invokeParam.getPwyLog());
        }
    }

    protected boolean isNeedWriterLog() {
        return this.invokeParam.isNeedWriterLog();
    }

    @Override
    public boolean isSuccess() {
        return this.getSuccessCode().equals(this.invokeParam.getErrcode());
    }

    public boolean isPartSuccess() {
        return this.getPartSuccessCode() != null && this.getPartSuccessCode().equals(this.invokeParam.getErrcode());
    }

    protected void handleSuccess() throws EASBizException, BOSException {
    }

    protected int getRetryTimes() {
        if (this.invokeParam.getMsgSettingInfo() != null) {
            return this.invokeParam.getMsgSettingInfo().getSendCount();
        }
        return this.getDefaultRetryTimes();
    }

    protected int getDefaultRetryTimes() {
        return 0;
    }

    protected boolean isNeedRetry() {
        return this.retryTimes > 0;
    }

    protected boolean isNeedEncrypt() {
        return false;
    }

    protected void setReturn(String errorCode, String description) {
        this.invokeParam.setErrcode(errorCode);
        this.invokeParam.setDescription(description);
    }

    protected String getUnKownCode() {
        return "60000";
    }

    protected void resolveSuccess() {
    }

    protected void resolvePartSuccess() {
    }

    protected boolean isNeedReverse() {
        return false;
    }

    public abstract String getPwyCzlx();

    public String getSuccessCode() {
        return "0000";
    }

    public String getPartSuccessCode() {
        return null;
    }

    @Override
    public PwyInvokeParam getInvokeParam() {
        return this.invokeParam;
    }

    public void setInvokeParam(PwyInvokeParam invokeParam) {
        this.invokeParam = invokeParam;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void buildPwyParam(boolean isWriteLog) throws BOSException, EASBizException {
    }

    @Override
    public void invokeAfter() {
    }

    @Override
    public void doInvoke() {
    }
}

