/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.usedCarMakeInvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.usedCarMakeInvoice.AbstractUsedCarPwyService;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class UsedCarDiskPwyService
extends AbstractUsedCarPwyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.service.usedCarMakeInvoice.UsedCarDiskPwyService");

    public UsedCarDiskPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public UsedCarDiskPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    protected Map getPwyData() throws EASBizException, BOSException {
        Map jsonMap = this.getPwyHead();
        jsonMap.put("sfrz", this.getPwySfrz());
        Map pwySjd = this.getPwySjd();
        jsonMap.put("sjd", pwySjd);
        return jsonMap;
    }

    protected Map getPwyHead() {
        String czlx = this.getPwyCzlx().substring(1, this.getPwyCzlx().length());
        String authCode = this.getAuthcode();
        String tid = this.getTid();
        return this.getPwyHelper().getHead(czlx, authCode, tid);
    }

    protected Map getPwySfrz() {
        return this.getPwyHelper().getSfrzForMakeInvoice(this.getInvokeParam().getSetting());
    }

    @Override
    public String getBaseURL() throws EASBizException, BOSException {
        return this.getInvokeParam().getSetting().getHttpAddress();
    }

    public abstract Map getPwySjd() throws EASBizException, BOSException;

    @Override
    public abstract String getPwyCzlx();

    public String getAuthcode() {
        return "";
    }

    public String getTid() {
        return "";
    }

    protected JSONObject getJSONObject(JSONObject data, String key) {
        JSONObject value = null;
        if (data.has(key)) {
            try {
                value = data.getJSONObject(key);
            }
            catch (JSONException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    protected String getStringValue(JSONObject data, String key) {
        String value = null;
        if (data.has(key)) {
            try {
                String valueStr = data.getString(key);
                if (valueStr != null && valueStr.length() > 0 && !"null".equals(valueStr)) {
                    value = valueStr;
                }
            }
            catch (JSONException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }
}

