/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.usedCarMakeInvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.UsedCarMakeInvoiceInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.usedCarMakeInvoice.UsedCarDiskPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.UsedCarPwyHelper;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UsedCarMakeInvoicePwyService
extends UsedCarDiskPwyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.service.usedCarMakeInvoice.UsedCarMakeInvoicePwyService");

    public UsedCarMakeInvoicePwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public UsedCarMakeInvoicePwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    protected Map getPwyData() throws EASBizException, BOSException {
        UsedCarMakeInvoiceInfo invoice = this.getInvoice();
        Map jsonMap = this.getPwyHead();
        jsonMap.put("sfrz", this.getPwySfrz());
        Map pwySjd = this.getPwySjd();
        jsonMap.put("sjd", pwySjd);
        return jsonMap;
    }

    @Override
    public Map getPwySjd() throws EASBizException, BOSException {
        UsedCarMakeInvoiceInfo invoice = this.getInvoice();
        Map jsonMap = UsedCarPwyHelper.getMakeInvoiceSjd(this.getCtx(), invoice);
        return jsonMap;
    }

    @Override
    public String getPwyCzlx() {
        return "U43";
    }

    @Override
    protected int getDefaultRetryTimes() {
        return 3;
    }

    @Override
    public String getTid() {
        if (this.getInvokeParam().getCompany() != null) {
            String taxNo = this.getInvokeParam().getCompany().getTaxNumber();
            if (!StringUtils.isEmpty((String)taxNo)) {
                taxNo = taxNo.trim();
            }
            return taxNo;
        }
        return "";
    }

    @Override
    protected void resolveSuccess() {
        JSONObject resultJson = null;
        try {
            JSONObject deviceInfo;
            resultJson = new JSONObject(this.getInvokeParam().getRevMsg());
            JSONObject invoiceJson = this.getJSONObject(resultJson, "sjd");
            if (invoiceJson != null) {
                this.getInvokeParam().getPwyLog().setInvoiceNum(this.getStringValue(invoiceJson, "fphm"));
                this.getInvokeParam().getPwyLog().setInvoiceCode(this.getStringValue(invoiceJson, "fpdm"));
            }
            if ((deviceInfo = this.getJSONObject(resultJson, "device_info")) != null) {
                Map invokeActionMap = this.getInvokeParam().getInvokeActionMap();
                invokeActionMap.put("taxbureau_code", this.getStringValue(deviceInfo, "taxbureau_code"));
                invokeActionMap.put("taxbureau_name", this.getStringValue(deviceInfo, "taxbureau_name"));
                invokeActionMap.put("card_no", this.getStringValue(deviceInfo, "card_no"));
                invokeActionMap.put("subid", this.getStringValue(deviceInfo, "subid"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("invoiceNo", this.getInvokeParam().getPwyLog().getInvoiceNum());
        param.put("invoiceNum", this.getInvokeParam().getPwyLog().getInvoiceCode());
        param.put("taxbureau_code", (String)this.getInvokeParam().getInvokeActionMap().get("taxbureau_code"));
        param.put("taxbureau_name", (String)this.getInvokeParam().getInvokeActionMap().get("taxbureau_name"));
        param.put("card_no", (String)this.getInvokeParam().getInvokeActionMap().get("card_no"));
        param.put("subid", (String)this.getInvokeParam().getInvokeActionMap().get("subid"));
        BizInterfaceFactory.getUsedCarMakeInvoice(this.getCtx()).afterMakeInvoice(this.getInvoice().getId().toString(), param);
    }

    @Override
    public String getSuccessCode() {
        return "0";
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }
}

