/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.Kson;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.httpClient.SSLClientConfig;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.common.comm.RemoteServiceInfo;
import com.kingdee.eas.tm.im.common.comm.ServiceException;
import com.kingdee.eas.tm.im.common.comm.msg.PwyDebugHelper;
import com.kingdee.eas.tm.im.common.comm.service.util.IERPOpenApiHelper;
import com.kingdee.eas.tm.im.httpClient.HttpClientUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.ws.ResultInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class IERPLoginUtil {
    private static Logger logger = Logger.getLogger((String)IERPLoginUtil.class.getName());
    public static Map<String, String> tokenMap = new HashMap<String, String>();

    public static String getActualToken(Context ctx, RemoteServiceInfo info) throws BOSException, EASBizException {
        return IERPLoginUtil.login(ctx, info, false);
    }

    public static String getCacheToken(Context ctx, RemoteServiceInfo info) {
        return tokenMap.get(IERPLoginUtil.getCacheTokenKey(ctx, info));
    }

    public static boolean isNotLogin(Object returnData) {
        return ((Map)returnData).get("error_code") != null && "1".equals(((Map)returnData).get("error_code").toString());
    }

    public static String login(Context ctx, RemoteServiceInfo info, boolean isDebug) throws EASBizException, BOSException {
        String appToken = IERPLoginUtil.getAppToken(ctx, info, isDebug);
        try {
            String url = info.getServiceURL() + info.getLoginUrl();
            Map map = IERPOpenApiHelper.getLoginData(info, appToken);
            String param = Kson.getGson().toJson((Object)map);
            String response = "";
            if (isDebug) {
                response = PwyDebugHelper.getPwyRespJson("ierplogin");
            } else {
                SSLClientConfig config = SSLClientConfig.custom().setConfig(ctx).build();
                response = HttpClientUtil.doPost1(url, param, config);
            }
            Map result = (Map)JSONObject.parseObject((String)response, Map.class);
            ResultInfo resultInfo = IERPLoginUtil.parseResult(ctx, result);
            if (!resultInfo.isSuccess()) {
                throw new IMException(IMException.ERRORMSG, new Object[]{resultInfo.getMsg()});
            }
            String accessToken = null;
            Map data = (Map)result.get("data");
            if (data != null) {
                accessToken = (String)data.get("access_token");
                tokenMap.put(IERPLoginUtil.getCacheTokenKey(ctx, info), accessToken);
            }
            return accessToken;
        }
        catch (Throwable e) {
            if (e.getCause() != null) {
                logger.error((Object)e.getCause().getMessage(), e.getCause());
                throw new ServiceException(ServiceException.EPX_LOGIN_FAILURE, new Object[]{e.getCause().getMessage()});
            }
            logger.error((Object)e.getMessage(), e);
            throw new ServiceException(ServiceException.EPX_LOGIN_FAILURE, new Object[]{e.getMessage()});
        }
    }

    private static String getAppToken(Context ctx, RemoteServiceInfo info, boolean isDebug) throws EASBizException, BOSException {
        String url = "";
        String param = "";
        String response = "";
        try {
            url = info.getServiceURL() + info.getTokenUrl();
            Map map = IERPOpenApiHelper.getAppTokenData(info);
            param = Kson.getGson().toJson((Object)map);
            if (isDebug) {
                response = PwyDebugHelper.getPwyRespJson("ierpapptoken");
            } else {
                SSLClientConfig config = SSLClientConfig.custom().setConfig(ctx).setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).build();
                response = HttpClientUtil.doPost1(url, param, config);
            }
            Map result = (Map)JSONObject.parseObject((String)response, Map.class);
            ResultInfo resultInfo = IERPLoginUtil.parseResult(ctx, result);
            if (!resultInfo.isSuccess()) {
                throw new IMException(IMException.ERRORMSG, new Object[]{resultInfo.getMsg()});
            }
            String appToken = null;
            Map data = (Map)result.get("data");
            if (data != null) {
                appToken = (String)data.get("app_token");
            }
            return appToken;
        }
        catch (Throwable e) {
            logger.error((Object)("getAppToken url:" + url + " param:" + param + " response:" + response));
            if (e.getCause() != null) {
                logger.error((Object)e.getCause().getMessage(), e.getCause());
                throw new ServiceException(ServiceException.EPX_GET_APPTOKEN_FAILURE, new Object[]{e.getCause().getMessage()});
            }
            logger.error((Object)e.getMessage(), e);
            throw new ServiceException(ServiceException.EPX_GET_APPTOKEN_FAILURE, new Object[]{e.getMessage()});
        }
    }

    public static void logout(Context ctx, RemoteServiceInfo info, boolean isDebug) throws EASBizException, BOSException {
        try {
            String url = info.getServiceURL() + "/api/logout.do";
            Map map = IERPOpenApiHelper.getLogoutData(info.getAccessToken());
            String param = Kson.getGson().toJson((Object)map);
            String response = "";
            if (isDebug) {
                response = PwyDebugHelper.getPwyRespJson("ierplogout");
            } else {
                SSLClientConfig config = SSLClientConfig.custom().setConfig(ctx).build();
                response = HttpClientUtil.doPost1(url, param, config);
            }
            Map result = (Map)JSONObject.parseObject((String)response, Map.class);
            ResultInfo resultInfo = IERPLoginUtil.parseResult(ctx, result);
            if (!resultInfo.isSuccess()) {
                throw new IMException(IMException.ERRORMSG, new Object[]{resultInfo.getMsg()});
            }
        }
        catch (Throwable e) {
            if (e.getCause() != null) {
                logger.error((Object)e.getCause().getMessage(), e.getCause());
                throw new ServiceException(ServiceException.EPX_LOGOUT_FAILURE, new Object[]{e.getCause().getMessage()});
            }
            logger.error((Object)e.getMessage(), e);
            throw new ServiceException(ServiceException.EPX_LOGOUT_FAILURE, new Object[]{e.getMessage()});
        }
    }

    public static void switchorg(Context ctx, RemoteServiceInfo info, boolean isDebug) throws EASBizException, BOSException {
        try {
            String url = info.getServiceURL() + "/kapi/app/bdm/switchorg?access_token=" + info.getAccessToken();
            Map map = IERPOpenApiHelper.getSwitchOrgData(info.getCompanyNumber());
            String param = Kson.getGson().toJson((Object)map);
            String response = "";
            if (isDebug) {
                response = PwyDebugHelper.getPwyRespJson("ierpswitchorg");
            } else {
                SSLClientConfig config = SSLClientConfig.custom().setConfig(ctx).build();
                response = HttpClientUtil.doPost1(url, param, config);
            }
            Map result = (Map)JSONObject.parseObject((String)response, Map.class);
            String errorCode = (String)result.get("errorCode");
            String message = (String)result.get("message");
            if (!"0000".equals(errorCode)) {
                logger.error((Object)response);
                throw new IMException(IMException.ERRORMSG, new Object[]{message});
            }
        }
        catch (Throwable e) {
            if (e.getCause() != null) {
                logger.error((Object)e.getCause().getMessage(), e.getCause());
                throw new ServiceException(ServiceException.EPX_SWITCHORG_FAILURE, new Object[]{e.getCause().getMessage()});
            }
            logger.error((Object)e.getMessage(), e);
            throw new ServiceException(ServiceException.EPX_SWITCHORG_FAILURE, new Object[]{e.getMessage()});
        }
    }

    private static ResultInfo parseResult(Context ctx, Map result) {
        ResultInfo resultInfo = new ResultInfo();
        String state = (String)result.get("state");
        if ("success".equals(state)) {
            Map data = (Map)result.get("data");
            if (data == null) {
                String errorMsg = IMUtils.getString("com.kingdee.eas.tm.im.common.comm.IMCommResource", "RetrueMsgError", ctx.getLocale());
                resultInfo.setStatus(0);
                resultInfo.setMsg(errorMsg);
            }
            String errorCode = (String)data.get("error_code");
            String errorDesc = (String)data.get("error_desc");
            if ("0".equals(errorCode)) {
                resultInfo.setStatus(0);
            } else {
                resultInfo.setStatus(2);
                resultInfo.setMsg(errorDesc);
            }
        } else {
            String errorCode = (String)result.get("errorCode");
            String message = (String)result.get("message");
            if ("0000".equals(errorCode)) {
                resultInfo.setStatus(0);
            } else {
                resultInfo.setStatus(2);
                resultInfo.setMsg(message);
            }
        }
        return resultInfo;
    }

    private static String getCacheTokenKey(Context ctx, RemoteServiceInfo info) {
        return info.getServiceURL() + "_" + info.getAccountId() + "_" + info.getUser();
    }
}

