/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.util;

import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PoolPwyHelper {
    public static String CONNECTOR = "=";

    public static List getDiskDownloadParams(Map searchOpt, String serialNo, int dataFromIndex, String dataIndex) {
        String invoiceType = (String)searchOpt.get("invoiceType");
        String[] invoiceTypes = invoiceType.split(",");
        ArrayList paramList = new ArrayList();
        HashMap<String, Object> param = null;
        HashMap<String, String> paramOpt = null;
        for (int i = 0; i < invoiceTypes.length; ++i) {
            param = new HashMap<String, Object>();
            paramOpt = new HashMap<String, String>();
            paramOpt.putAll(searchOpt);
            paramOpt.put("invoiceType", invoiceTypes[i]);
            param.put("searchOpt", paramOpt);
            param.put("serialNo", serialNo);
            param.put("dataFromIndex", dataFromIndex);
            param.put("dataIndex", dataIndex);
            paramList.add(param);
        }
        return paramList;
    }

    public static Map getCSCheckPwyData(List<CheckAbsInfo> checkAbsInfo, Map param) {
        HashMap<String, Serializable> body = new HashMap<String, Serializable>();
        ArrayList invoiceList = new ArrayList();
        for (int i = 0; i < checkAbsInfo.size(); ++i) {
            CheckAbsInfo info = checkAbsInfo.get(i);
            HashMap<String, Object> invoiceMap = new HashMap<String, Object>();
            if (!StringUtils.isEmpty((String)info.getInvoiceCode())) {
                invoiceMap.put("invoiceCode", info.getInvoiceCode());
            } else {
                invoiceMap.put("invoiceCode", "");
            }
            invoiceMap.put("invoiceNo", info.getInvoiceNo());
            invoiceMap.put("invoiceType", info.getInvoiceType().getValue());
            invoiceMap.put("invoiceDate", PoolPwyHelper.dealDateString(info.getInvoiceDate()));
            invoiceMap.put("invoiceAmount", info.getAmount());
            invoiceMap.put("totalTaxAmount", info.getTaxAmt());
            invoiceMap.put("effectiveTaxAmount", info.getEffectiveTaxAmt().setScale(2, RoundingMode.HALF_UP));
            invoiceMap.put("salerName", info.getSalerName());
            invoiceMap.put("salerTaxNo", info.getSalerTaxNo());
            if (info.getNotDeductibleType() != null) {
                invoiceMap.put("notDeductibleType", info.getNotDeductibleType().getValue());
            }
            invoiceList.add(invoiceMap);
        }
        body.put("invoices", invoiceList);
        body.put("asyncFlag", Integer.valueOf(-1));
        body.put("taxNo", (Serializable)param.get("taxNo"));
        body.put("authenticateFlag", Integer.valueOf((Boolean)param.get("isUndo") != false ? 0 : 1));
        return body;
    }

    public static Map getFpdkCSCheckPwyData(List<CheckAbsInfo> checkAbsInfo, Map param) {
        HashMap<String, Serializable> body = new HashMap<String, Serializable>();
        ArrayList invoiceList = new ArrayList();
        for (int i = 0; i < checkAbsInfo.size(); ++i) {
            CheckAbsInfo info = checkAbsInfo.get(i);
            HashMap<String, Object> invoiceMap = new HashMap<String, Object>();
            if (!StringUtils.isEmpty((String)info.getInvoiceCode())) {
                invoiceMap.put("invoiceCode", info.getInvoiceCode());
            } else {
                invoiceMap.put("invoiceCode", "");
            }
            invoiceMap.put("invoiceNo", info.getInvoiceNo());
            invoiceMap.put("invoiceDate", PoolPwyHelper.dealDateString(info.getInvoiceDate()));
            if (info.getNotDeductibleType() != null) {
                invoiceMap.put("notDeductibleType", info.getNotDeductibleType().getValue());
            }
            invoiceMap.put("effectiveTaxAmount", info.getEffectiveTaxAmt().setScale(2, RoundingMode.HALF_UP));
            invoiceList.add(invoiceMap);
        }
        body.put("invoices", invoiceList);
        body.put("requestId", (Serializable)param.get("requestId"));
        body.put("asyncFlag", Integer.valueOf(-1));
        body.put("taxNo", (Serializable)param.get("taxNo"));
        body.put("deductibleMode", (Serializable)param.get("deductibleMode"));
        return body;
    }

    private static String dealDateString(Date value) {
        if (value == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(value);
    }

    public static Map getCSConfirmPwyData(PwySettingInfo setting, String requestId) {
        HashMap<String, String> body = new HashMap<String, String>();
        if (setting.isFpdkType()) {
            body.put("password", setting.getConfirmPassword());
            body.put("requestId", requestId);
        } else {
            body.put("caPass", setting.getCaPassword());
        }
        return body;
    }

    public static Map getCSPeriodPwyData(PwySettingInfo setting) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("caPass", setting.getCaPassword());
        return body;
    }

    public static Map getCSRptQueryPwyData(PwySettingInfo setting, String requestId) {
        HashMap<String, String> body = new HashMap<String, String>();
        if (setting.isFpdkType()) {
            body.put("caPass", setting.getCaPassword());
            body.put("requestId", requestId);
        } else {
            body.put("caPass", setting.getCaPassword());
        }
        return body;
    }

    public static Map getCSRptCreatePwyData(PwySettingInfo setting, String requestId) {
        HashMap<String, String> body = new HashMap<String, String>();
        if (setting.isFpdkType()) {
            body.put("caPass", setting.getCaPassword());
            body.put("requestId", requestId);
        } else {
            body.put("caPass", setting.getCaPassword());
        }
        return body;
    }

    public static Map getCSRptCancelPwyData(PwySettingInfo setting, String requestId) {
        HashMap<String, String> body = new HashMap<String, String>();
        if (setting.isFpdkType()) {
            body.put("caPass", setting.getCaPassword());
            body.put("requestId", requestId);
        } else {
            body.put("caPass", setting.getCaPassword());
        }
        return body;
    }
}

