/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.common.comm.CommunicationSetCollection;
import com.kingdee.eas.tm.im.common.comm.CommunicationSetInfo;
import com.kingdee.eas.tm.im.common.comm.ServiceException;
import com.kingdee.eas.tm.im.common.comm.TaxMsgSettingCollection;
import com.kingdee.eas.tm.im.common.comm.TaxMsgSettingInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.util.BOSResourceBundle;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class PwyServiceHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper");
    private static Map<String, Class<IPwyService>> interfaceImpClassMap = null;
    public static Map<String, Integer> seqMap = new HashMap<String, Integer>();

    public static PwyInvokeParam invoke(Context ctx, PwyInvokeParam invokeParam) throws EASBizException, BOSException {
        return PwyServiceHelper.invoke(ctx, invokeParam, null);
    }

    public static PwyInvokeParam invoke(Context ctx, PwyInvokeParam invokeParam, List<PwyInvokeParam> invokeChain) throws EASBizException, BOSException {
        boolean isNeedReBuild = false;
        if (invokeParam.getBeforeInvokeParam().size() > 0) {
            PwyInvokeParam beforeInvokeParam = null;
            String msgType2 = null;
            for (String msgType2 : invokeParam.getBeforeInvokeParam().keySet()) {
                beforeInvokeParam = invokeParam.getBeforeInvokeParam().get(msgType2);
                IPwyService pwyService = PwyServiceHelper.getPwyService(ctx, beforeInvokeParam);
                pwyService.doInvoke();
                beforeInvokeParam = pwyService.getInvokeParam();
                invokeParam.getBeforeInvokeParam().put(msgType2, beforeInvokeParam);
                if (beforeInvokeParam.isSuccess()) continue;
                return beforeInvokeParam;
            }
            isNeedReBuild = true;
        }
        IPwyService pwyService = PwyServiceHelper.getPwyService(ctx, invokeParam);
        if (isNeedReBuild) {
            pwyService.reBuildPwyParam();
        }
        pwyService.doInvoke();
        invokeParam = pwyService.getInvokeParam();
        if (!invokeParam.isSuccess()) {
            return invokeParam;
        }
        if (invokeParam.getNextInvokeParam() != null) {
            if (invokeChain != null) {
                invokeChain.add(invokeParam);
            }
            PwyServiceHelper.invoke(ctx, invokeParam.getNextInvokeParam(), invokeChain);
        }
        return invokeParam;
    }

    public static IPwyService getPwyService(Context ctx, PwyInvokeParam invokeParam) throws EASBizException, BOSException {
        IPwyService pwyService = null;
        String serviceType = invokeParam.getMsgType();
        TaxMsgSettingInfo msgSettingInfo = PwyServiceHelper.getMsgSetting(ctx, serviceType);
        if (msgSettingInfo != null && !StringUtils.isEmpty((String)msgSettingInfo.getInterfaceImpClass())) {
            try {
                Class<?> c = Class.forName(msgSettingInfo.getInterfaceImpClass());
                Constructor<?> c1 = c.getDeclaredConstructor(Context.class, PwyInvokeParam.class);
                pwyService = (IPwyService)c1.newInstance(ctx, invokeParam);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            PwyServiceHelper.registerServices();
            Class<IPwyService> serviceClass = interfaceImpClassMap.get(invokeParam.getMsgType());
            if (serviceClass != null) {
                try {
                    Constructor<IPwyService> c1 = serviceClass.getDeclaredConstructor(Context.class, PwyInvokeParam.class);
                    pwyService = c1.newInstance(ctx, invokeParam);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            } else {
                throw new ServiceException(ServiceException.EPX_INTERFACE_SERVICE_NOTFLOUD);
            }
        }
        return pwyService;
    }

    public static IPwyService getPwyService(Context ctx, TaxTransLogInfo pwyLog, TaxMsgSettingInfo msgSettingInfo) throws BOSException {
        IPwyService pwyService = null;
        PwyServiceType logType = pwyLog.getLogType();
        if (msgSettingInfo != null && !StringUtils.isEmpty((String)msgSettingInfo.getInterfaceImpClass())) {
            try {
                Class<?> c = Class.forName(msgSettingInfo.getInterfaceImpClass());
                Constructor<?> c1 = c.getDeclaredConstructor(Context.class, TaxTransLogInfo.class);
                pwyService = (IPwyService)c1.newInstance(ctx, pwyLog);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            PwyServiceHelper.registerServices();
            Class<IPwyService> serviceClass = interfaceImpClassMap.get(pwyLog.getLogType().getValue());
            if (serviceClass != null) {
                try {
                    Constructor<IPwyService> c1 = serviceClass.getDeclaredConstructor(Context.class, TaxTransLogInfo.class);
                    pwyService = c1.newInstance(ctx, pwyLog);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            } else {
                throw new BOSException("PwyService Not Found !");
            }
        }
        return pwyService;
    }

    public static IPwyService getPwyService(Context ctx, TaxTransLogInfo pwyLog) throws BOSException {
        IPwyService pwyService = null;
        PwyServiceType logType = pwyLog.getLogType();
        TaxMsgSettingInfo msgSettingInfo = PwyServiceHelper.getMsgSetting(ctx, logType.getValue());
        if (msgSettingInfo != null && !StringUtils.isEmpty((String)msgSettingInfo.getInterfaceImpClass())) {
            try {
                Class<?> c = Class.forName(msgSettingInfo.getInterfaceImpClass());
                Constructor<?> c1 = c.getDeclaredConstructor(Context.class, TaxTransLogInfo.class);
                pwyService = (IPwyService)c1.newInstance(ctx, pwyLog);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            PwyServiceHelper.registerServices();
            Class<IPwyService> serviceClass = interfaceImpClassMap.get(pwyLog.getLogType().getValue());
            if (serviceClass != null) {
                try {
                    Constructor<IPwyService> c1 = serviceClass.getDeclaredConstructor(Context.class, TaxTransLogInfo.class);
                    pwyService = c1.newInstance(ctx, pwyLog);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            } else {
                throw new BOSException("PwyService Not Found !");
            }
        }
        return pwyService;
    }

    public static TaxMsgSettingInfo getMsgSetting(Context ctx, String msgType) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("msgType", (Object)msgType, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("sendTemplate.*");
        sic.add("resultTemplate.*");
        sic.add("remoteService.*");
        sic.add("remoteService.localService.*");
        view.setSelector(sic);
        TaxMsgSettingCollection coll = BizInterfaceFactory.getTaxMsgSetting(ctx).getTaxMsgSettingCollection(view);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public static Map<String, TaxMsgSettingInfo> getMsgSettingMap(Context ctx, List msgTypes) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("msgType", new HashSet(msgTypes), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("sendTemplate.*");
        sic.add("resultTemplate.*");
        sic.add("remoteService.*");
        sic.add("remoteService.localService.*");
        view.setSelector(sic);
        HashMap<String, TaxMsgSettingInfo> msgSettingInfoMap = new HashMap<String, TaxMsgSettingInfo>();
        TaxMsgSettingCollection coll = BizInterfaceFactory.getTaxMsgSetting(ctx).getTaxMsgSettingCollection(view);
        TaxMsgSettingInfo settingInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            settingInfo = coll.get(i);
            msgSettingInfoMap.put(settingInfo.getMsgType().getValue(), settingInfo);
        }
        return msgSettingInfoMap;
    }

    public static final String getNumberString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String newsNo = "NUM" + df.format(new Date());
        return newsNo;
    }

    public static synchronized String getNewNumberString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String key = df.format(new Date());
        int seq = 0;
        if (seqMap.containsKey(key)) {
            seq = seqMap.get(key) + 1;
        } else {
            seqMap.clear();
            seq = 1;
        }
        seqMap.put(key, seq);
        String number = key + seq;
        return number;
    }

    public static CommunicationSetInfo getCommSetting(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        CommunicationSetCollection coll = BizInterfaceFactory.getCommunicationSet(ctx).getCommunicationSetCollection(view);
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        CommunicationSetInfo setInfo = new CommunicationSetInfo();
        setInfo.setPwyURL("https://api.piaozone.com");
        setInfo.setPwyDevURL("https://api-dev.piaozone.com");
        setInfo.setPwySocketURL("https://wss.piaozone.com/bill-websocket/invoicewebsocket/push");
        setInfo.setIsPwyDev(true);
        setInfo.setDumpUpLimit(30);
        return setInfo;
    }

    public static String getBaseUrl(CommunicationSetInfo commSettingInfo) {
        return commSettingInfo.isIsPwyDev() ? commSettingInfo.getPwyURL() : commSettingInfo.getPwyDevURL();
    }

    protected static synchronized void registerServices() {
        if (interfaceImpClassMap != null) {
            return;
        }
        interfaceImpClassMap = new HashMap<String, Class<IPwyService>>();
        PwyServiceHelper.registeFromResource();
    }

    protected static void registeFromResource() {
        String resClassName = "com.kingdee.eas.tm.im.common.comm.service.PwyServiceImpClass";
        try {
            ResourceBundle resBundle = BOSResourceBundle.getBundle((String)resClassName, (Locale)new Locale("l1"));
            Enumeration<String> keyIter = resBundle.getKeys();
            while (keyIter.hasMoreElements()) {
                String msgType = keyIter.nextElement();
                String className = resBundle.getString(msgType);
                if (className == null) continue;
                PwyServiceHelper.registService(msgType, className);
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
    }

    private static void registService(String msgType, String className) {
        if (interfaceImpClassMap.containsKey(msgType)) {
            logger.error((Object)("msg type " + msgType + " existed."));
            return;
        }
        Class<IPwyService> clz = PwyServiceHelper.getClass(className);
        if (clz != null) {
            interfaceImpClassMap.put(msgType, clz);
        }
    }

    private static Class<IPwyService> getClass(String className) {
        Class<IPwyService> clz = null;
        try {
            clz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return clz;
    }
}

