/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.common.comm.ServiceException;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.util.LowTimer;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SIMOpenApiUtil {
    private static Logger logger = Logger.getLogger(SIMOpenApiUtil.class);

    public static Map invokeSIMOpenApi(Context ctx, PwyServiceType serviceType, CompanyOrgUnitInfo company, Map params) throws BOSException, EASBizException {
        try {
            LowTimer timer = new LowTimer();
            boolean isFromWeb = SIMOpenApiUtil.isFromWeb(params);
            TransSrcSystemEnum ownerSystem = isFromWeb ? TransSrcSystemEnum.easweb : TransSrcSystemEnum.easgui;
            String companyId = company == null ? null : company.getId().toString();
            PwyActionParam actionParam = new PwyActionParam(serviceType, ownerSystem, companyId, params == null ? new HashMap() : params);
            PwyInvokeParam invokeParam = new PwyInvokeParam(actionParam);
            IPwyService pwyService = PwyServiceHelper.getPwyService(ctx, invokeParam);
            pwyService.invoke();
            if (!pwyService.isSuccess()) {
                throw new IMException(IMException.ERRORMSG, new Object[]{pwyService.getInvokeParam().getDescription()});
            }
            logger.debug((Object)("\u3010SIMOpenApiUtil.invokeSIMOpenApi\u3011 take time\uff1a" + timer.msValue()));
            return pwyService.getInvokeParam().getInvokeActionMap();
        }
        catch (Throwable e) {
            if (e.getCause() != null) {
                logger.error((Object)e.getCause().getMessage(), e.getCause());
                throw new ServiceException(ServiceException.EPX_INVOKESERVICE_ERROR, new Object[]{serviceType.getAlias(), e.getCause().getMessage()});
            }
            logger.error((Object)e.getMessage(), e);
            throw new ServiceException(ServiceException.EPX_INVOKESERVICE_ERROR, new Object[]{serviceType.getAlias(), e.getMessage()});
        }
    }

    private static boolean isFromWeb(Map params) {
        if (params == null) {
            return false;
        }
        return params.get("isFromWeb") == null ? false : (Boolean)params.get("isFromWeb");
    }
}

