/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.tm.im.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.im.PwyHelper;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.VehicleMakeInvoiceInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class VehiclePwyHelper {
    public static Map getMakeInvoiceSjd(Context ctx, VehicleMakeInvoiceInfo info) throws BOSException {
        HashMap<String, Object> sjdMap = new HashMap<String, Object>();
        sjdMap.put("ori_code", "");
        sjdMap.put("ori_num", "");
        sjdMap.put("orderid", PwyHelper.md5(info.getId().toString()));
        sjdMap.put("business_id", info.getId().toString());
        sjdMap.put("buyercode", VehiclePwyHelper.dealNullString(info.getBuyerTaxNo()));
        sjdMap.put("buyername", info.getBuyerName());
        sjdMap.put("idcard", info.getBuyerCardNo());
        sjdMap.put("veh_kind", info.getVehicleType());
        sjdMap.put("brand", info.getFacPlateModel());
        sjdMap.put("place", info.getOrigin());
        sjdMap.put("cert", VehiclePwyHelper.dealNullString(info.getCertificateNum()));
        sjdMap.put("imp_cert", VehiclePwyHelper.dealNullString(info.getImportCertificate()));
        sjdMap.put("com_inspect_no", VehiclePwyHelper.dealNullString(info.getCommodityInspectionNum()));
        sjdMap.put("engine_no", VehiclePwyHelper.dealNullString(info.getEngineNum()));
        sjdMap.put("veh_no", info.getVehicleIdentificationCode());
        sjdMap.put("vd_name", VehiclePwyHelper.dealNullString(info.getProductionEnterprise()));
        sjdMap.put("total", VehiclePwyHelper.bigDecimalToString(info.getPriceTaxTotal()));
        sjdMap.put("taxrate", info.getTaxRate().intValue());
        sjdMap.put("sellercode", info.getSalerTaxNo());
        sjdMap.put("sellername", info.getSalerName());
        sjdMap.put("sellerphone", VehiclePwyHelper.dealNullString(info.getSalerPhone()));
        sjdMap.put("selleracc", VehiclePwyHelper.dealNullString(info.getSalerAccount()));
        sjdMap.put("selleraddr", VehiclePwyHelper.dealNullString(info.getSalerAddress()));
        sjdMap.put("sellerbank", VehiclePwyHelper.dealNullString(info.getSalerBankName()));
        sjdMap.put("tonnage", VehiclePwyHelper.dealNullString(info.getTonnage()));
        sjdMap.put("people_limit", VehiclePwyHelper.dealNullString(info.getLimitPopulation()));
        sjdMap.put("remark", "");
        UserInfo user = null;
        user = ctx != null ? (UserInfo)ctx.get((Object)"UserInfo") : SysContext.getSysContext().getCurrentUserInfo();
        sjdMap.put("biller", info.getDrawertxt() != null ? info.getDrawertxt() : user.getName());
        Map taxcode = VehiclePwyHelper.getMakeInvoiceTaxcode(ctx, info);
        sjdMap.put("taxcode", taxcode);
        return sjdMap;
    }

    private static Map getMakeInvoiceTaxcode(Context ctx, VehicleMakeInvoiceInfo info) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mergeCode", (Object)info.getTaxClassificationCode()));
        view.setFilter(filter);
        CoreBaseCollection coll = null;
        coll = ctx != null ? TaxClassificationCodeFactory.getLocalInstance(ctx).getCollection(view) : TaxClassificationCodeFactory.getRemoteInstance().getCollection(view);
        TaxClassificationCodeInfo taxClassificationCode = null;
        if (coll.size() > 0) {
            taxClassificationCode = (TaxClassificationCodeInfo)coll.get(0);
        }
        HashMap<String, String> taxcode = new HashMap<String, String>();
        taxcode.put("deduction", "");
        if (info.getTaxRate().compareTo(BigDecimal.ZERO) == 0) {
            if (info.isHasPreferential()) {
                if (PreferentialPoliciesEnum.DutyFree.equals((Object)info.getPreferentialPolicies())) {
                    taxcode.put("zerotag", "1");
                } else if (PreferentialPoliciesEnum.NoTaxation.equals((Object)info.getPreferentialPolicies())) {
                    taxcode.put("zerotag", "2");
                }
            } else {
                taxcode.put("zerotag", "3");
            }
        } else {
            taxcode.put("zerotag", "");
        }
        taxcode.put("epno", "");
        if (taxClassificationCode != null) {
            taxcode.put("code", taxClassificationCode.getMergeCode().toString());
        }
        taxcode.put("taxpre", info.isHasPreferential() ? "1" : "0");
        taxcode.put("taxprecont", info.getPreferentialPolicies() == null ? "" : info.getPreferentialPolicies().getAlias());
        return taxcode;
    }

    public static Map getMakeRedInvoiceSjd(Context ctx, VehicleMakeInvoiceInfo info) {
        HashMap<String, String> sjdMap = new HashMap<String, String>();
        sjdMap.put("fpdm", info.getBlueVoiceCode());
        sjdMap.put("fphm", info.getBlueVoiceNum());
        sjdMap.put("kpzl", "12");
        return sjdMap;
    }

    public static Map getCancelInvoiceSjd(VehicleMakeInvoiceInfo info) {
        HashMap<String, String> sjdMap = new HashMap<String, String>();
        sjdMap.put("fpdm", info.getInvoiceNumber());
        sjdMap.put("fphm", info.getInvoiceNo());
        sjdMap.put("kpzl", "12");
        return sjdMap;
    }

    public static Map getPrintInvoiceSjd(VehicleMakeInvoiceInfo info) {
        HashMap<String, String> sjdMap = new HashMap<String, String>();
        sjdMap.put("fpdm", info.getInvoiceNumber());
        sjdMap.put("fphm", info.getInvoiceNo());
        sjdMap.put("kpzl", "12");
        sjdMap.put("ylbz", "0");
        return sjdMap;
    }

    public static String dealNullString(Object value) {
        return value == null ? "" : value.toString();
    }

    public static String bigDecimalToString(BigDecimal value) {
        if (value == null || value.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        return value.toString();
    }
}

