/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.formula.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.formula.api.BaseFormulaFunctions;
import com.kingdee.bos.service.formula.api.BuilderResourceUtil;
import com.kingdee.bos.service.formula.builder.bosmeta.AbsBOSMetaModel;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObj;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.tm.im.common.formula.builder.FormulaBuilderUtil;
import com.kingdee.eas.tm.im.common.formula.builder.FormulaEleInfo;
import com.kingdee.eas.tm.im.common.formula.builder.TreeModelBOSTypes;
import com.kingdee.eas.tm.im.common.formula.builder.bosmeta.BOSObjEntity;
import com.kingdee.eas.tm.im.common.formula.builder.bosmeta.BOSObjProp;
import com.kingdee.eas.tm.im.common.formula.client.AbstractEntityFormulaUI;
import com.kingdee.eas.tm.im.common.formula.model.EntityFormula;
import com.kingdee.eas.tm.im.common.formula.model.FunctionInfo;
import com.kingdee.eas.tm.im.common.formula.util.EntityFormulaVerifier;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class EntityFormulaUI
extends AbstractEntityFormulaUI {
    private static final Logger logger = CoreUIObject.getLogger(EntityFormulaUI.class);
    private static final String RESOURCE = "com.kingdee.eas.scm.framework.bizflow.WriteBackFilterConfigResource";
    private String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.common.formula.FormulaResource", (String)"prompt_msg");
    protected String txtMsg = EASResource.getString((String)"com.kingdee.eas.scm.framework.bizflow.WriteBackFilterConfigResource", (String)"refer_msg");
    private static final long serialVersionUID = 1L;
    private static final String KEY_ALIAS = "KEY_ALIAS";
    protected boolean isCancel;
    private boolean isCheckFormual;
    private EntityObjectInfo srcEntity;
    private EntityObjectInfo destEntity;
    protected EntityFormula formualInfo;
    protected ActionListener actionListener;
    private TreeModelBOSTypes modelBOSTypes = new TreeModelBOSTypes(null);

    public EntityFormulaUI() throws Exception {
        this.tblPanelEdit.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EntityFormulaUI.this.tabbedPaneOutmost_stateChanged(e);
            }
        });
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityFormulaUI.this.actionOPButton_actionPerformed(e);
            }
        };
        this.btnAdd.addActionListener(this.actionListener);
        this.btnSub.addActionListener(this.actionListener);
        this.btnMul.addActionListener(this.actionListener);
        this.btnDiv.addActionListener(this.actionListener);
        this.btnGreat.addActionListener(this.actionListener);
        this.btnGreatEqual.addActionListener(this.actionListener);
        this.btnLess.addActionListener(this.actionListener);
        this.btnLessEqual.addActionListener(this.actionListener);
        this.btnEqual.addActionListener(this.actionListener);
        this.btnNotEqual.addActionListener(this.actionListener);
        this.btnAnd.addActionListener(this.actionListener);
        this.btnOr.addActionListener(this.actionListener);
        this.btnLeftBra.addActionListener(this.actionListener);
        this.btnRigthBra.addActionListener(this.actionListener);
        this.btnBra.addActionListener(this.actionListener);
        this.btnClear.addActionListener(this.actionListener);
        this.btnIf.addActionListener(this.actionListener);
        this.btnIfElse.addActionListener(this.actionListener);
        this.btnIfElseIf.addActionListener(this.actionListener);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.formualInfo = (EntityFormula)this.getUIContext().get("InitDataObject");
        if (this.formualInfo == null) {
            this.formualInfo = new EntityFormula(null, null);
        }
        if (this.getUIContext().get("IsCheckFormual") != null) {
            this.isCheckFormual = (Boolean)this.getUIContext().get("IsCheckFormual");
        }
        this.srcEntity = this.formualInfo.getSrcEntity();
        this.destEntity = this.formualInfo.getDestEntity();
        this.updateEntityAlias();
        if (this.getUIContext().get("ChildUI") == null) {
            this.txtAreaFormula.setText(this.formualInfo.getFormualAlias());
        } else {
            this.txtAreaFormula.setText(this.formualInfo.getValueExpression());
        }
        this.txtFormulaExpr.setText(this.formualInfo.getValueExpression());
        this.txtAreaFormula.setFont(new Font("SansSerif", 0, 13));
        this.txtFormulaExpr.setFont(new Font("SansSerif", 0, 15));
        this.txtFuncDescription.setEditable(false);
        this.txtFieldDesc.setEditable(false);
        if (this.getUIContext().get("isBDSyncFilterConfigUI") != null && StringUtils.isEmpty((String)this.txtAreaFormula.getText())) {
            this.txtAreaFormula.setForeground(new Color(165, 165, 165));
            this.txtAreaFormula.setFont(new Font("SansSerif", 2, 13));
            this.txtAreaFormula.setText(this.msg);
            this.txtAreaFormula.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                }

                @Override
                public void focusGained(FocusEvent e) {
                    if (EntityFormulaUI.this.msg.equals(EntityFormulaUI.this.txtAreaFormula.getText())) {
                        EntityFormulaUI.this.txtAreaFormula.setText("");
                        EntityFormulaUI.this.txtAreaFormula.setForeground(new Color(0, 0, 0));
                        EntityFormulaUI.this.txtAreaFormula.setFont(new Font("SansSerif", 0, 13));
                    }
                }
            });
        }
        this.initEntityTree();
        this.initFunctionTree();
    }

    protected void updateEntityAlias() {
        if (this.srcEntity != null) {
            this.srcEntity.setString(KEY_ALIAS, this.srcEntity.getAlias());
            this.srcEntity.setAlias(ResourceUtil.getMessage((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"92_WriteBackFormulaUI", (String[])new String[]{this.srcEntity.getAlias()}));
        }
        if (this.destEntity != null) {
            this.destEntity.setString(KEY_ALIAS, this.destEntity.getAlias());
            this.destEntity.setAlias(ResourceUtil.getMessage((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"93_WriteBackFormulaUI", (String[])new String[]{this.destEntity.getAlias()}));
        }
    }

    protected void restoreEntityAlias() {
        if (this.srcEntity != null) {
            this.srcEntity.setAlias(this.srcEntity.getString(KEY_ALIAS));
        }
        if (this.destEntity != null) {
            this.destEntity.setAlias(this.destEntity.getString(KEY_ALIAS));
        }
    }

    private void initEntityTree() {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        BusinessObjectInfo[] metaObjs = new BusinessObjectInfo[]{this.srcEntity, this.destEntity};
        this.modelBOSTypes.setMetaDataObjs(metaObjs, loader);
        this.treeBizObject.setModel((TreeModel)this.modelBOSTypes);
        this.treeBizObject.setRootVisible(false);
        this.treeBizObject.setToggleClickCount(1);
        this.treeBizObject.expandOnLevel(3);
        this.treeBizObject.getSelectionModel().setSelectionMode(1);
        this.treeBizObject.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EntityFormulaUI.this.treeBizObject_mouseClicked(e);
            }
        });
        this.treeBizObject.updateUI();
    }

    private void initFunctionTree() throws BOSException {
        this.treeFunc.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.getFunctionRoot()));
        this.treeFunc.setRootVisible(false);
        this.treeFunc.setToggleClickCount(1);
        this.treeFunc.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EntityFormulaUI.this.treeFuncs_mouseClicked(e);
            }
        });
    }

    private DefaultKingdeeTreeNode getFunctionRoot() throws BOSException {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"Function");
        Map<String, List<FunctionInfo>> baseFuncMap = this.getBaseFormualFunctionList();
        for (Map.Entry<String, List<FunctionInfo>> entry : baseFuncMap.entrySet()) {
            this.addCategoryFunction(root, entry.getKey(), entry.getValue());
        }
        return root;
    }

    private void addCategoryFunction(DefaultKingdeeTreeNode root, String category, List<FunctionInfo> functions) {
        DefaultKingdeeTreeNode treeNode = null;
        treeNode = new DefaultKingdeeTreeNode((Object)category);
        treeNode.setText(category);
        root.add((MutableTreeNode)treeNode);
        if (functions == null || functions.size() == 0) {
            return;
        }
        for (int i = 0; i < functions.size(); ++i) {
            this.addTreeNode(treeNode, functions.get(i));
        }
    }

    private Map<String, List<FunctionInfo>> getBaseFormualFunctionList() {
        HashMap<String, List<FunctionInfo>> baseFuncMap = new HashMap<String, List<FunctionInfo>>();
        BaseFormulaFunctions baseFunc = new BaseFormulaFunctions();
        String[] funcName = baseFunc.getAllFuncNames();
        String name = null;
        String category = null;
        ArrayList<FunctionInfo> functionList = null;
        for (int i = 0; i < funcName.length; ++i) {
            name = funcName[i];
            category = baseFunc.getFuncCategory(funcName[i]);
            functionList = (ArrayList<FunctionInfo>)baseFuncMap.get(category);
            if (functionList == null) {
                functionList = new ArrayList<FunctionInfo>();
                baseFuncMap.put(category, functionList);
            }
            functionList.add(new FunctionInfo(this.getLocale(), name, category, baseFunc.getFuncDesc(name)));
        }
        return baseFuncMap;
    }

    private void addTreeNode(DefaultKingdeeTreeNode parent, FunctionInfo function) {
        DefaultKingdeeTreeNode treeNode = null;
        treeNode = new DefaultKingdeeTreeNode((Object)function);
        treeNode.setText(function.getFuncName());
        parent.add((MutableTreeNode)treeNode);
    }

    private void treeFuncs_mouseClicked(MouseEvent e) {
        DefaultKingdeeTreeNode treeNode;
        Object obj;
        TreePath tp = this.treeFunc.getSelectionPath();
        boolean selectResult = this.selectTreeFuncs(tp);
        if (e.getClickCount() == 2 && selectResult && (obj = (treeNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent()).getUserObject()) instanceof FunctionInfo) {
            String s = "";
            s = s + ((FunctionInfo)obj).getFuncName();
            s = s + "( )";
            s = " " + s + " ";
            this.addText(s);
        }
    }

    private void treeBizObject_mouseClicked(MouseEvent e) {
        TreePath tp = this.treeBizObject.getSelectionPath();
        if (tp == null) {
            return;
        }
        boolean selectResult = this.selectBizObjectField(tp);
        DefaultKingdeeTreeNode currNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
        assert (currNode instanceof BOSObjProp);
        if (currNode instanceof BOSObjProp) {
            BOSObjEntity entity;
            BOSObjProp nodeTemp = (BOSObjProp)currNode;
            Object bosObjTemp = null;
            if (nodeTemp.getLinkProp() != null) {
                bosObjTemp = nodeTemp.isFirstDealing() ? nodeTemp.dealLinkProp() : nodeTemp.getBOSObjEntity();
            }
            if ((entity = (BOSObjEntity)((Object)bosObjTemp)) != null && currNode.getChildCount() == 0) {
                Vector _bosPropsInner = entity.getBosProps();
                for (int m = 0; m < _bosPropsInner.size(); ++m) {
                    BOSObjProp childNode = (BOSObjProp)_bosPropsInner.get(m);
                    if (!FormulaBuilderUtil.isCanInsertTreeNode(currNode, childNode)) continue;
                    this.treeBizObject.insertNodeInto((MutableTreeNode)((Object)childNode), (MutableTreeNode)currNode, currNode.getChildCount());
                }
            }
        }
        this.treeBizObject.updateUI();
        String str = " ";
        if (e.getClickCount() == 2 && selectResult) {
            if (tp.getLastPathComponent() instanceof BOSObj) {
                return;
            }
            Vector objEles = FormulaEleInfo.cloneMultiEles();
            for (int i = 0; i < objEles.size(); ++i) {
                FormulaEleInfo currEle = ((FormulaEleInfo)objEles.get(i)).cloneMe();
                String dispTemp = currEle.getDispStr();
                str = str + dispTemp;
            }
            this.addText(str);
        }
    }

    private boolean selectTreeFuncs(TreePath tp) {
        if (tp == null) {
            return false;
        }
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
        Object obj = treeNode.getUserObject();
        if (obj instanceof FunctionInfo) {
            String description = ((FunctionInfo)obj).getFuncDesc();
            description = description.replaceAll("\\<br\\>\\<\\/br\\>", "\n");
            this.txtFuncDescription.setText(description);
            return true;
        }
        this.txtFuncDescription.setText("");
        return false;
    }

    private boolean selectBizObjectField(TreePath tp) {
        if (tp.getLastPathComponent() instanceof AbsBOSMetaModel) {
            this.txtFieldDesc.setText(((AbsBOSMetaModel)tp.getLastPathComponent()).getDesc());
            Vector<Object> paths = new Vector<Object>();
            boolean afterValid = false;
            for (int i = 0; i < tp.getPathCount(); ++i) {
                if (tp.getPathComponent(i) instanceof BOSObj) {
                    afterValid = true;
                }
                if (!afterValid) continue;
                paths.add(tp.getPathComponent(i));
            }
            if (paths.size() > 0) {
                FormulaEleInfo.setSelectedEle(FormulaEleInfo.createObjEles(paths));
                return true;
            }
        }
        return false;
    }

    protected void actionOPButton_actionPerformed(ActionEvent e) {
        KDWorkButton butten = (KDWorkButton)e.getSource();
        String text = "";
        if (butten.equals(this.btnClear)) {
            this.txtAreaFormula.setText(text);
        } else {
            text = butten.equals(this.btnBra) ? " ( )" : (butten.equals(this.btnIf) ? BuilderResourceUtil.getString((String)"FormulaBuilderPanelBean_displayIf") : (butten.equals(this.btnIfElse) ? BuilderResourceUtil.getString((String)"FormulaBuilderPanelBean_displayIfElse") : (butten.equals(this.btnIfElseIf) ? BuilderResourceUtil.getString((String)"FormulaBuilderPanelBean_displayTwoIfElse") : " " + butten.getText())));
        }
        this.addText(text);
    }

    public void tabbedPaneOutmost_stateChanged(ChangeEvent e) {
        if (this.tblPanelEdit.getSelectedComponent() == this.txtFormulaExpr) {
            String formulaAlias = this.txtAreaFormula.getText().trim();
            try {
                this.txtFormulaExpr.setText(this.formualInfo.getFormualExprByAlias(formulaAlias));
            }
            catch (ParserException ex) {
                FormulaBuilderUtil.showMessageDialog((Component)((Object)this), ex.getMessage());
            }
        }
    }

    protected void addText(String text) {
        StringBuffer sb = new StringBuffer();
        String str = this.txtAreaFormula.getText();
        int caretPo = this.txtAreaFormula.getCaretPosition();
        if (!StringUtils.isEmpty((String)str) && (str.equals(this.msg) || str.equals(this.txtMsg))) {
            str = "";
            caretPo = 0;
        }
        String left = str.substring(0, caretPo);
        String right = str.substring(caretPo);
        sb.append(left);
        sb.append(text);
        sb.append(right);
        this.txtAreaFormula.setText(sb.toString());
        this.txtAreaFormula.requestFocus();
        this.txtAreaFormula.setSelectionStart(caretPo);
        this.txtAreaFormula.setSelectionEnd(caretPo + text.length());
    }

    public EntityFormula getEntityFormula() {
        return this.formualInfo;
    }

    private void innerStoreFormual() throws ParserException {
        String formulaAlias = this.txtAreaFormula.getText().trim();
        this.formualInfo.getFormualExprByAlias(formulaAlias);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        try {
            this.innerStoreFormual();
            if (this.verify()) {
                this.disposeUIWindow();
            }
        }
        catch (ParserException ex) {
            String msg = com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"94_WriteBackFormulaUI");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)ex.getMessage(), (int)1);
        }
    }

    protected void disposeUIWindow() {
        this.restoreEntityAlias();
        super.disposeUIWindow();
    }

    private boolean verify() throws ParserException {
        if (this.formualInfo.getValueExpression() == null || this.formualInfo.getValueExpression().length() == 0) {
            return true;
        }
        EntityFormulaVerifier verifier = new EntityFormulaVerifier();
        boolean flag = verifier.isCompatibleWithBOSFormula(this.formualInfo.getValueExpression());
        if (!flag) {
            MsgBox.showWarning((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"94_WriteBackFormulaUI"));
            return false;
        }
        if (this.isCheckFormual && !(flag = verifier.isBooleanFormual(this.formualInfo.getValueExpression()))) {
            MsgBox.showWarning((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"95_WriteBackFormulaUI"));
            return false;
        }
        return true;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.disposeUIWindow();
    }
}

