/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.formula.model;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.formula.builder.TableVarInfo;
import com.kingdee.eas.scm.framework.bizflow.formula.WriteBackFormulaTransformer;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.tm.im.common.formula.util.EntityFormulaTransformer;
import com.kingdee.eas.util.client.EASResource;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Vector;

public class EntityFormula {
    public static final String FORMULA_SRC = "Formula_Src:";
    public static final String FORMULA_DEST = "Formula_Dest:";
    public static final String FORMULA_EXPR = "Formula_Expr:";
    private EntityObjectInfo srcEntity;
    private EntityObjectInfo destEntity;
    private String valueExpression;
    private String formulaStr;

    public EntityFormula(String formualStr) throws Exception {
        this.formulaStr = formualStr;
        this.parse();
    }

    public EntityFormula(EntityObjectInfo srcEntity, EntityObjectInfo destEntity) {
        this(srcEntity, destEntity, null);
    }

    public EntityFormula(EntityObjectInfo srcEntity, EntityObjectInfo destEntity, String valueExpression) {
        this.srcEntity = srcEntity;
        this.destEntity = destEntity;
        if (srcEntity != null && srcEntity == destEntity) {
            this.destEntity = (EntityObjectInfo)destEntity.trueClone();
        }
        this.valueExpression = valueExpression;
    }

    private void parse() throws Exception {
        LineNumberReader lnr = new LineNumberReader(new StringReader(this.formulaStr));
        String srcEntityName = null;
        String destEntityName = null;
        String line = lnr.readLine();
        while (line != null) {
            int pos = line.indexOf(FORMULA_SRC);
            if (pos >= 0) {
                pos = line.indexOf(":");
                srcEntityName = line.substring(pos + 1);
            }
            if ((pos = line.indexOf(FORMULA_DEST)) >= 0) {
                pos = line.indexOf(":");
                destEntityName = line.substring(pos + 1);
            }
            if ((pos = line.indexOf(FORMULA_EXPR)) >= 0) {
                pos = line.indexOf(":");
                this.valueExpression = line.substring(pos + 1);
            }
            line = lnr.readLine();
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(null);
        if (!StringUtil.isEmpty(srcEntityName)) {
            this.srcEntity = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)srcEntityName.trim()));
        }
        if (!StringUtil.isEmpty(destEntityName)) {
            this.destEntity = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)destEntityName.trim()));
        }
    }

    public String getFormulaStr() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(FORMULA_SRC);
        if (this.srcEntity != null) {
            buffer.append(this.srcEntity.getFullName());
        }
        buffer.append("\r\n");
        buffer.append(FORMULA_DEST);
        if (this.destEntity != null) {
            buffer.append(this.destEntity.getFullName());
        }
        buffer.append("\r\n");
        buffer.append(FORMULA_EXPR);
        if (StringUtil.isEmpty((String)this.valueExpression)) {
            buffer.append(this.valueExpression);
        }
        buffer.append("\r\n");
        this.formulaStr = buffer.toString();
        return this.formulaStr;
    }

    public String getFormualExprByAlias(String formulaAlias) throws ParserException {
        WriteBackFormulaTransformer transfrmer = new WriteBackFormulaTransformer(this.getEntityVarInfo());
        BusinessObjectInfo[] bizObjArray = new BusinessObjectInfo[]{this.srcEntity, this.destEntity};
        transfrmer.addBOSObjects(bizObjArray);
        this.valueExpression = transfrmer.transforme(formulaAlias);
        return this.valueExpression;
    }

    public String getFormualAlias() throws ParserException {
        if (StringUtil.isEmpty((String)this.valueExpression)) {
            return null;
        }
        EntityFormulaTransformer transfrmer = new EntityFormulaTransformer(this.getEntityVarInfo());
        BusinessObjectInfo[] bizObjArray = new BusinessObjectInfo[]{this.srcEntity, this.destEntity};
        transfrmer.addBOSObjects(bizObjArray);
        String formulaAlias = transfrmer.reverseTransform(this.valueExpression);
        return formulaAlias;
    }

    protected Vector getEntityVarInfo() {
        Vector<TableVarInfo> result = new Vector<TableVarInfo>(2);
        String alias = this.srcEntity.getAlias();
        if (alias.indexOf(EASResource.getString((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"126_WriteBackFormula")) < 0) {
            alias = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"92_WriteBackFormulaUI", (String[])new String[]{alias});
        }
        TableVarInfo srcEntityVar = new TableVarInfo("_Src", alias, this.srcEntity.getObjectValueClass(), null, null, null, -1);
        alias = this.destEntity.getAlias();
        if (alias.indexOf(EASResource.getString((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"127_WriteBackFormula")) < 0) {
            alias = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.framework.bizflow.BIZFLOWAutoGenerateResource", (String)"93_WriteBackFormulaUI", (String[])new String[]{alias});
        }
        TableVarInfo destEntityVar = new TableVarInfo("_Dest", alias, this.destEntity.getObjectValueClass(), null, null, null, -1);
        result.add(srcEntityVar);
        result.add(destEntityVar);
        return result;
    }

    public EntityObjectInfo getSrcEntity() {
        return this.srcEntity;
    }

    public void setSrcEntity(EntityObjectInfo srcEntity) {
        this.srcEntity = srcEntity;
    }

    public EntityObjectInfo getDestEntity() {
        return this.destEntity;
    }

    public void setDestEntity(EntityObjectInfo destEntity) {
        this.destEntity = destEntity;
    }

    public String getValueExpression() {
        return this.valueExpression;
    }

    public void setValueExpression(String valueExpression) {
        this.valueExpression = valueExpression;
    }
}

