/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.uihelper;

import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPasswordField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.tm.im.basedata.PrivateFieldSchemeInfo;
import com.kingdee.eas.tm.im.common.uihelper.PrivateComponentLayout;
import com.kingdee.eas.tm.im.common.uihelper.TextFieldProxy;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class PrivateComponent {
    private static Map<String, Icon> iconMap = new HashMap<String, Icon>();
    private static final String CIPHER = "******";
    private KDLabelContainer labelContainer = null;
    private KDTextField publicField = null;
    private KDPasswordField privateField = null;
    private KDWorkButton showBtn = null;
    private PrivateFieldSchemeInfo schemeInfo = null;
    private EditUI ui;
    private PrivateComponentLayout layout = null;
    public static final int VIEW_PRIVATE = 0;
    public static final int VIEW_PUBLIC = 1;
    private int viewState = 0;

    public PrivateComponent(EditUI ui, PrivateFieldSchemeInfo schemeInfo) {
        this.ui = ui;
        this.schemeInfo = schemeInfo;
    }

    public void init() {
        KDLayout.Constraints cons;
        Component component = this.ui.getDataBinder().getComponetByField(this.schemeInfo.getFieldName());
        if (component == null) {
            return;
        }
        if (!(component instanceof KDTextField)) {
            return;
        }
        Container container = component.getParent();
        if (!(container instanceof KDLabelContainer)) {
            return;
        }
        this.labelContainer = (KDLabelContainer)container;
        this.publicField = (KDTextField)this.labelContainer.getBoundEditor();
        this.privateField = new KDPasswordField();
        this.showBtn = new KDWorkButton();
        this.showBtn.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent var1) {
                PrivateComponent.this.toggle();
            }
        });
        if (this.schemeInfo != null && !this.schemeInfo.isIsShowBtn()) {
            this.showBtn.setVisible(false);
        }
        if ((cons = (KDLayout.Constraints)((JComponent)container).getClientProperty("KDLayoutConstraints")) != null) {
            container.getParent().setLayout((LayoutManager)((Object)this.getLayout()));
            container.getParent().add((Component)this.privateField, null);
            container.getParent().add((Component)this.showBtn, null);
        } else {
            this.layout();
            container.getParent().add((Component)this.privateField, null);
            container.getParent().add((Component)this.showBtn, null);
        }
        this.publicField.setVisible(false);
        this.clone((JTextField)this.publicField, (JTextField)this.privateField);
        this.ui.getDataBinder().unRegisterBinding(this.schemeInfo.getFieldName(), String.class, (Component)this.publicField, "text");
        this.ui.getDataBinder().registerBinding(this.schemeInfo.getFieldName(), String.class, (Component)this.privateField, "text");
        this.viewState = 0;
        this.setUIByViewState();
    }

    public void toggle() {
        this.viewState = this.viewState == 0 ? 1 : 0;
        this.setUIByViewState();
    }

    public void setUIByViewState() {
        if (this.viewState == 0) {
            this.privateField.setEchoChar('*');
            Icon icon = PrivateComponent.findIconByPath("image/eye-hide.png");
            this.showBtn.setIcon(icon);
            this.publicField.setText(this.getStringEncrypt(this.ui.getDataObject().getString(this.schemeInfo.getFieldName())));
            if (this.ui.getOprtState().equals(OprtState.VIEW)) {
                this.privateField.setVisible(false);
                this.publicField.setVisible(true);
            } else {
                this.privateField.setVisible(true);
                this.publicField.setVisible(false);
            }
        } else {
            this.privateField.setEchoChar('\u0000');
            Icon icon = PrivateComponent.findIconByPath("image/eye-show.png");
            this.showBtn.setIcon(icon);
            this.publicField.setVisible(false);
            this.privateField.setVisible(true);
        }
    }

    private String getStringEncrypt(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        if (str.length() < 9) {
            return CIPHER;
        }
        return str.substring(0, 4) + CIPHER + str.substring(str.length() - 4, str.length());
    }

    private void clone(JTextField field1, JTextField field2) {
        TextFieldProxy field1Proxy = new TextFieldProxy(field1);
        TextFieldProxy field2Proxy = new TextFieldProxy(field2);
        field2Proxy.setText(field1Proxy.getText());
        field2Proxy.setEditable(field1Proxy.isEditable());
        field2Proxy.setRequired(field1Proxy.isRequired());
        field2Proxy.repaint();
    }

    public void layout() {
        Rectangle contBounds = this.labelContainer.getBounds();
        if (this.showBtn.isVisible()) {
            contBounds.width -= 21;
        }
        this.labelContainer.setBounds(contBounds);
        Rectangle privateBounds = new Rectangle();
        privateBounds.x = contBounds.x + this.labelContainer.getBoundLabelLength();
        privateBounds.y = contBounds.y;
        privateBounds.width = contBounds.width - this.labelContainer.getBoundLabelLength() + 1;
        privateBounds.height = contBounds.height;
        this.privateField.setBounds(privateBounds);
        Rectangle showBtnBounds = new Rectangle();
        showBtnBounds.x = contBounds.x + contBounds.width;
        showBtnBounds.y = contBounds.y;
        showBtnBounds.width = 22;
        showBtnBounds.height = contBounds.height;
        this.showBtn.setBounds(showBtnBounds);
    }

    public static Icon findIconByPath(String relativePath) {
        Icon icon = iconMap.get(relativePath);
        if (icon == null) {
            URL url = PrivateComponent.class.getResource(relativePath);
            icon = url != null ? new ImageIcon(url) : new ImageIcon(EASResource.getImage((String)"imgTbtn_find"));
        }
        return icon;
    }

    public KDTextField getPublicField() {
        return this.publicField;
    }

    public void setPublicField(KDTextField publicField) {
        this.publicField = publicField;
    }

    public KDPasswordField getPrivateField() {
        return this.privateField;
    }

    public void setPrivateField(KDPasswordField privateField) {
        this.privateField = privateField;
    }

    public KDWorkButton getShowBtn() {
        return this.showBtn;
    }

    public void setShowBtn(KDWorkButton showBtn) {
        this.showBtn = showBtn;
    }

    public KDLabelContainer getLabelContainer() {
        return this.labelContainer;
    }

    public void setLabelContainer(KDLabelContainer labelContainer) {
        this.labelContainer = labelContainer;
    }

    public PrivateFieldSchemeInfo getSchemeInfo() {
        return this.schemeInfo;
    }

    public void setSchemeInfo(PrivateFieldSchemeInfo schemeInfo) {
        this.schemeInfo = schemeInfo;
    }

    public PrivateComponentLayout getLayout() {
        return this.layout;
    }

    public void setLayout(PrivateComponentLayout layout) {
        this.layout = layout;
    }
}

