/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.uihelper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.tm.im.SpecificInformationEntryCollection;
import com.kingdee.eas.tm.im.SpecificInformationEntryInfo;
import com.kingdee.eas.tm.im.SpecificInformationFactory;
import com.kingdee.eas.tm.im.SpecificInformationInfo;
import com.kingdee.eas.tm.im.client.AbstractSpecificInformationEditUI;
import com.kingdee.eas.tm.im.client.SpecificInformationEditUI;
import com.kingdee.eas.tm.im.common.uihelper.ISpecInfoEditUI;
import com.kingdee.eas.tm.im.common.uihelper.SpecificServiceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;

public class SpecificInformationEditUIHelper {
    private EditUI ui = null;
    private ISpecInfoEditUI specEditUI = null;
    private SpecificInformationEditUI specInfoUI = null;
    private ResourceBundleHelper resHelper = new ResourceBundleHelper(AbstractSpecificInformationEditUI.class.getName());

    public SpecificInformationEditUIHelper(EditUI ui) {
        this.ui = ui;
        this.specEditUI = (ISpecInfoEditUI)ui;
    }

    public void initUI() throws EASBizException, BOSException {
        try {
            SpecificServiceUtils.refreshSpecServiceFieldMap();
            this.clearSpecInfoPanel();
            UIContext uiContext = new UIContext((Object)this.ui);
            String oprtState = this.ui.getOprtState();
            ObjectBaseInfo o = (ObjectBaseInfo)this.ui.getDataObject().get(this.specEditUI.getSpecFieldName());
            if (o != null && o instanceof SpecificInformationInfo && ((SpecificInformationInfo)o).getId() != null) {
                if (OprtState.ADDNEW.equals(oprtState)) {
                    uiContext.put((Object)"editData", (Object)((SpecificInformationInfo)o));
                } else {
                    uiContext.put((Object)"ID", (Object)((SpecificInformationInfo)o).getId().toString());
                }
            } else {
                if (OprtState.VIEW.equals(oprtState)) {
                    return;
                }
                if (OprtState.EDIT.equals(oprtState) || OprtState.COPYADDNEW.equals(oprtState)) {
                    oprtState = OprtState.ADDNEW;
                }
            }
            uiContext.put((Object)"specServiceType", (Object)this.specEditUI.getSpecificServiceType());
            String uiClass = "com.kingdee.eas.tm.im.client.SpecificInformationEditUI";
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, oprtState);
            if (uiWindow.getUIObject() instanceof SpecificInformationEditUI) {
                this.specInfoUI = (SpecificInformationEditUI)uiWindow.getUIObject();
            }
            this.addSpecInfoPanel();
        }
        catch (Exception e) {
            this.ui.handUIException((Throwable)e);
        }
    }

    private void clearSpecInfoPanel() {
        KDTabbedPane billSpecPanel = this.specEditUI.getBillSpecPanel();
        if (billSpecPanel != null) {
            for (int i = billSpecPanel.getComponentCount() - 1; i >= 0; --i) {
                if (!SpecificServiceUtils.SPECPANELNAME.contains(billSpecPanel.getComponent(i).getName())) continue;
                billSpecPanel.remove(billSpecPanel.getComponent(i));
            }
        }
    }

    private void addSpecInfoPanel() {
        KDTabbedPane kdtPanel = null;
        KDTabbedPane billSpecPanel = this.specEditUI.getBillSpecPanel();
        if (this.specInfoUI.getComponent(0) instanceof KDTabbedPane) {
            kdtPanel = (KDTabbedPane)this.specInfoUI.getComponent(0);
        }
        if (kdtPanel != null && billSpecPanel != null) {
            int i;
            for (i = kdtPanel.getComponentCount() - 1; i >= 0; --i) {
                if (!"kDPSpeInfoEntries".equals(kdtPanel.getComponent(i).getName())) continue;
                billSpecPanel.add(kdtPanel.getComponent(i), (Object)this.resHelper.getString(kdtPanel.getComponent(i).getName() + ".constraints"), billSpecPanel.getTabCount());
            }
            for (i = billSpecPanel.getComponentCount() - 1; i >= 0; --i) {
                if (!SpecificServiceUtils.SPECPANELNAME.contains(billSpecPanel.getComponent(i).getName())) continue;
                kdtPanel.add(billSpecPanel.getComponent(i), (Object)this.resHelper.getString(billSpecPanel.getComponent(i).getName() + ".constraints"), kdtPanel.getTabCount());
            }
            HashSet<Object> panelNames = new HashSet();
            HashSet<String> panelMap = SpecificServiceUtils.specServicePanelMap.get(this.specEditUI.getSpecificServiceType());
            if (panelMap != null && panelMap instanceof HashSet) {
                panelNames = panelMap;
            }
            for (int i2 = kdtPanel.getComponentCount() - 1; i2 > 0; --i2) {
                if (!panelNames.contains(kdtPanel.getComponent(i2).getName())) continue;
                billSpecPanel.add(kdtPanel.getComponent(i2), (Object)this.resHelper.getString(kdtPanel.getComponent(i2).getName() + ".constraints"), billSpecPanel.getTabCount());
            }
        }
    }

    public void refreshSpecPanelBySpecServiceType() {
        if (this.specInfoUI != null) {
            this.specInfoUI.setComponentVisibleBySpecificService(this.specEditUI.getSpecificServiceType());
            this.specInfoUI.clearKdTables();
            this.addSpecInfoPanel();
        }
    }

    public void storeFields() {
        if (this.specInfoUI != null && this.ui != null && this.ui.getDataObject() instanceof ObjectBaseInfo) {
            this.specInfoUI.storeFields();
            ((ObjectBaseInfo)this.ui.getDataObject()).put(this.specEditUI.getSpecFieldName(), (Object)this.specInfoUI.getDataObject());
        }
    }

    public void setFieldsNull(AbstractObjectValue newData) {
        try {
            ObjectBaseInfo bill = (ObjectBaseInfo)newData;
            Object o = bill.get(this.specEditUI.getSpecFieldName());
            if (o != null && o instanceof SpecificInformationInfo && ((SpecificInformationInfo)o).getId() != null) {
                ObjectUuidPK pk = new ObjectUuidPK(((SpecificInformationInfo)o).getId());
                if (SpecificInformationFactory.getRemoteInstance().exists((IObjectPK)pk)) {
                    SpecificInformationInfo specInfo = SpecificInformationFactory.getRemoteInstance().getSpecificInformationInfo((IObjectPK)pk);
                    specInfo.setId(BOSUuid.create((String)"5E6919D3"));
                    SpecificInformationEntryCollection coll = specInfo.getEntries();
                    SpecificInformationEntryInfo entry = null;
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        entry = coll.get(i);
                        entry.setId(BOSUuid.create((String)"506D2A5F"));
                    }
                    bill.put(this.specEditUI.getSpecFieldName(), (Object)specInfo);
                }
            }
        }
        catch (Exception e) {
            this.ui.handUIException((Throwable)e);
        }
    }

    public String checkRequiredFields() {
        if (this.specInfoUI != null && ("4".equals(this.specEditUI.getInvoiceType()) || "5".equals(this.specEditUI.getInvoiceType()))) {
            return this.specInfoUI.checkRequiredFields();
        }
        return "";
    }

    public boolean addLine() throws Exception {
        return this.entryLineOperation("AddLine");
    }

    public boolean insertLine() throws Exception {
        return this.entryLineOperation("InsertLine");
    }

    public boolean removeLine() throws Exception {
        return this.entryLineOperation("RemoveLine");
    }

    private boolean entryLineOperation(String operation) throws Exception {
        KDTabbedPane billSpecPanel = this.specEditUI.getBillSpecPanel();
        if (billSpecPanel != null) {
            JComponent compent = (JComponent)billSpecPanel.getSelectedComponent();
            if ("kDPSpeInfo".equals(compent.getName())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.SpecificInformationResource", (String)"ENTRYLINE_NOT_UPDATE"));
                return false;
            }
            if ("kDPSpeInfoEntries".equals(compent.getName())) {
                if ("AddLine".equals(operation)) {
                    this.specInfoUI.actionAddLine_actionPerformed(null);
                } else if ("InsertLine".equals(operation)) {
                    this.specInfoUI.actionInsertLine_actionPerformed(null);
                } else if ("RemoveLine".equals(operation)) {
                    this.specInfoUI.actionRemoveLine_actionPerformed(null);
                }
                return false;
            }
        }
        return true;
    }

    public boolean destroyWindow() {
        if (this.specInfoUI != null) {
            return this.specInfoUI.destroyWindow();
        }
        return true;
    }
}

