/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.uihelper;

import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tm.im.CombinRuleSettingFactory;
import com.kingdee.eas.tm.im.CombinRuleSettingInfo;
import com.kingdee.eas.tm.im.client.MakeInvoiceReqListUI;
import com.kingdee.eas.tm.im.client.MySwingWork;
import com.kingdee.eas.tm.im.client.MyThreadPool;
import com.kingdee.eas.tm.im.client.RuleItem;
import com.kingdee.eas.tm.im.client.SelectCombinRuleSchemeUI;
import com.kingdee.eas.tm.im.client.comp.ProgressDialog;
import com.kingdee.eas.tm.im.client.comp.ProgressDialogHelper;
import com.kingdee.eas.tm.im.client.util.IMClientUtils;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport;
import com.kingdee.eas.tm.im.common.uihelper.IAsyncJob;
import com.kingdee.eas.tm.im.common.uihelper.IUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UIHelper
implements IUIHelper {
    private static final Logger logger = CoreUIObject.getLogger(UIHelper.class);
    protected CoreUI ui = null;
    private ProgressDialog progressDialog = null;

    public UIHelper(CoreUI ui) {
        this.ui = ui;
    }

    @Override
    public CoreUI getUi() {
        return null;
    }

    public ProgressDialog getProgressDialog() {
        if (this.progressDialog == null) {
            this.progressDialog = ProgressDialogHelper.createProgressDialog(this.ui, true);
        }
        return this.progressDialog;
    }

    public void checkBaseDataPermission(String currentCUID, ArrayList ids) throws Exception {
        boolean isNotCUEnable = false;
        IPermSupport uiSupport = (IPermSupport)this.ui;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        ev.setFilter(filter);
        ICoreBase iCoreBase = uiSupport.getPermInterface();
        CoreBaseCollection coll = iCoreBase.getCollection(ev);
        CoreBaseInfo coreInfo = null;
        String bizOrgId = null;
        for (int i = 0; i < coll.size(); ++i) {
            coreInfo = coll.get(i);
            IObjectValue value = (IObjectValue)coreInfo.get(uiSupport.getBizOrgProperty(this.ui.getMainType()));
            bizOrgId = value.get("id").toString();
            if (currentCUID.equals(bizOrgId)) continue;
            isNotCUEnable = true;
        }
        if (isNotCUEnable) {
            String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource", (String)"CANTNOT_EDIT_DATA_CU");
            MsgBox.showInfo((Component)this.ui, (String)msg);
            SysUtil.abort();
        }
    }

    public void checkCanAddnew(String currentCUID) throws Exception {
        EntityControlTypeUtil.checkCanAddnew((String)"S3", (String)currentCUID);
    }

    public void checkCanEdit(String currentCUID, String id) throws Exception {
        IPermSupport uiSupport = (IPermSupport)this.ui;
        ICoreBase iCoreBase = uiSupport.getPermInterface();
        CoreBaseInfo info = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(id));
        IObjectValue value = (IObjectValue)info.get(uiSupport.getBizOrgProperty(this.ui.getMainType()));
        String cuid = value.get("id").toString();
        if (cuid != null) {
            EntityControlTypeUtil.checkCanEdit((String)"S3", (String)currentCUID, (String)cuid);
        }
    }

    public void checkCanRemove(String currentCUID, List ids) throws Exception {
        IPermSupport uiSupport = (IPermSupport)this.ui;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        ev.setFilter(filter);
        ICoreBase iCoreBase = uiSupport.getPermInterface();
        CoreBaseCollection coll = iCoreBase.getCollection(ev);
        CoreBaseInfo coreInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            coreInfo = coll.get(i);
            IObjectValue value = (IObjectValue)coreInfo.get(uiSupport.getBizOrgProperty(this.ui.getMainType()));
            String cuid = value.get("id").toString();
            if (cuid == null) continue;
            EntityControlTypeUtil.checkCanRemove((String)"S3", (String)currentCUID, (String)cuid);
        }
    }

    public void doInDeamon(ActionEvent e, final IAsyncJob job) {
        String name = this.getActionName(e);
        final MonitorInfo info = new MonitorInfo(name, null, (Object)job.getOwner(), true);
        MySwingWork worker = new MySwingWork(){

            public Object construct() {
                return job.execute();
            }

            public void finished() {
                this.timerStop();
                MyThreadPool.destroyMonitor(info);
                MyThreadPool.destroyPorgressDialog();
            }

            @Override
            public void refreshProgress() {
                MyThreadPool.refreshProgress(job.getProgress());
            }
        };
        info.setWorker((SwingWorker)worker);
        MyThreadPool.getInstance();
        MyThreadPool.addActionThread(info);
        MyThreadPool.setBackgroundRunButtonEnabled(false);
    }

    public String getActionName(ActionEvent e) {
        String label = "";
        if (e.getSource() instanceof KDWorkButton) {
            KDWorkButton button = (KDWorkButton)e.getSource();
            label = button.getText();
        } else if (e.getSource() instanceof KDMenuItem) {
            KDMenuItem item = (KDMenuItem)e.getSource();
            item.getText();
            label = item.getText();
        } else {
            KDButton button = (KDButton)e.getSource();
            label = button.getText();
        }
        return label;
    }

    public boolean isAddNew(ItemAction action) {
        String actionCommand;
        return action != null && action.getActionEvent() != null && !StringUtils.isEmpty((String)(actionCommand = action.getActionEvent().getActionCommand())) && actionCommand.endsWith("AddNew");
    }

    public Map chooseCombinRule(CoreUI comp, String bostype) throws Exception {
        HashMap retMap = new HashMap();
        CommonQueryDialog dialog = null;
        if (comp instanceof CoreBillListUI) {
            ((CoreBillListUI)comp).checkSelected();
        } else if (comp instanceof CoreBillEditUI) {
            ((CoreBillEditUI)comp).checkSelected();
        }
        HashMap<String, String> ruleIDs = new HashMap<String, String>();
        Map<String, Boolean> otherParams = new HashMap<String, Boolean>();
        EntityViewInfo srcview = new EntityViewInfo();
        FilterInfo srcfilter = new FilterInfo();
        srcview.setFilter(srcfilter);
        srcfilter.getFilterItems().add(new FilterItemInfo("billBosType", (Object)"AC368D2D", CompareType.EQUALS));
        srcfilter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
        CoreBaseCollection srcCombinRuleColl = CombinRuleSettingFactory.getRemoteInstance().getCollection(srcview);
        EntityViewInfo destview = new EntityViewInfo();
        FilterInfo destfilter = new FilterInfo();
        destview.setFilter(destfilter);
        destfilter.getFilterItems().add(new FilterItemInfo("billBosType", (Object)"412A6F98", CompareType.EQUALS));
        destfilter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
        CoreBaseCollection destCombinRuleColl = CombinRuleSettingFactory.getRemoteInstance().getCollection(destview);
        if (srcCombinRuleColl.size() <= 1 && destCombinRuleColl.size() <= 1) {
            CombinRuleSettingInfo destCombinRule;
            CombinRuleSettingInfo srcCombinRule;
            if (srcCombinRuleColl.size() > 0 && (srcCombinRule = (CombinRuleSettingInfo)srcCombinRuleColl.get(0)) != null) {
                ruleIDs.put("srcRuleID", srcCombinRule.getId().toString());
            }
            if (destCombinRuleColl.size() > 0 && (destCombinRule = (CombinRuleSettingInfo)destCombinRuleColl.get(0)) != null) {
                ruleIDs.put("destRuleID", destCombinRule.getId().toString());
            }
            otherParams.put("isConstantQty", false);
        } else {
            dialog = IMClientUtils.showCombinRuleSchemeDialog(comp, MakeInvoiceReqListUI.class.getName(), "AC368D2D", "412A6F98", true);
            if (dialog == null) {
                return null;
            }
            SelectCombinRuleSchemeUI scheme = (SelectCombinRuleSchemeUI)dialog.getUserPanel(0);
            if (!scheme.getIsComfirm()) {
                return null;
            }
            RuleItem srcItem = scheme.getSrcRule();
            RuleItem destItem = scheme.getDestRule();
            if (srcItem != null) {
                ruleIDs.put("srcRuleID", srcItem.getId());
            }
            if (destItem != null) {
                ruleIDs.put("destRuleID", destItem.getId());
            }
            otherParams = scheme.getOtherParams();
        }
        retMap.put("ruleIDs", ruleIDs);
        retMap.put("otherParams", otherParams);
        return retMap;
    }
}

