/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.httpClient;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.log4j.Logger;

public class HttpClientHelper {
    private static Logger logger = Logger.getLogger(HttpClientHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String urlPostMethod(String url, String params) {
        logger.info((Object)("\u53d1\u9001\u8bf7\u6c42\uff1a" + url));
        logger.info((Object)("\u53c2\u6570\uff1a" + params));
        HttpClient httpClient = new HttpClient();
        PostMethod method = new PostMethod(url);
        String res = null;
        try {
            ArrayList<Header> headers = new ArrayList<Header>();
            if (params != null && !params.trim().equals("")) {
                StringRequestEntity requestEntity = new StringRequestEntity(params, "text/xml", "UTF-8");
                method.setRequestEntity((RequestEntity)requestEntity);
                headers.add(new Header("Content-Length", String.valueOf(params.getBytes().length)));
            }
            httpClient.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
            httpClient.getHttpConnectionManager().getParams().setSoTimeout(60000);
            httpClient.executeMethod((HttpMethod)method);
            res = method.getResponseBodyAsString();
        }
        catch (HttpException e) {
            res = null;
        }
        catch (IOException e) {
            res = null;
        }
        finally {
            method.releaseConnection();
        }
        logger.info((Object)("\u8fd4\u56de\u7ed3\u679c\uff1a" + res));
        return res;
    }

    public static Map post(String url, String params) {
        logger.info((Object)("\u53d1\u9001\u8bf7\u6c42\uff1a" + url));
        logger.info((Object)("\u53c2\u6570\uff1a" + params));
        HttpClient httpClient = new HttpClient();
        PostMethod method = new PostMethod(url);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            ArrayList<Header> headers = new ArrayList<Header>();
            if (params != null && !params.trim().equals("")) {
                StringRequestEntity requestEntity = new StringRequestEntity(params, "text/xml", "UTF-8");
                method.setRequestEntity((RequestEntity)requestEntity);
                headers.add(new Header("Content-Length", String.valueOf(params.getBytes().length)));
            }
            httpClient.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
            httpClient.getHttpConnectionManager().getParams().setSoTimeout(60000);
            httpClient.executeMethod((HttpMethod)method);
            map.put("result", method.getResponseBodyAsString());
            method.releaseConnection();
        }
        catch (HttpException e) {
            HttpClientHelper.setError(map, (Exception)((Object)e));
            logger.error((Object)e.getMessage());
        }
        catch (IOException e) {
            HttpClientHelper.setError(map, e);
            logger.error((Object)e.getMessage());
        }
        logger.info((Object)("\u8fd4\u56de\u7ed3\u679c\uff1a" + map.get("result")));
        return map;
    }

    public static String urlGetMethod(String url) {
        logger.info((Object)("\u53d1\u9001\u8bf7\u6c42\uff1a" + url));
        HttpClient httpClient = new HttpClient();
        GetMethod method = new GetMethod(url);
        String res = null;
        try {
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
            httpClient.getHttpConnectionManager().getParams().setSoTimeout(60000);
            httpClient.executeMethod((HttpMethod)method);
            res = method.getResponseBodyAsString();
            method.releaseConnection();
        }
        catch (HttpException e) {
            res = null;
        }
        catch (IOException e) {
            res = null;
        }
        logger.info((Object)("\u8fd4\u56de\u7ed3\u679c\uff1a" + res));
        return res;
    }

    public static Map get(String url) {
        logger.info((Object)("\u53d1\u9001\u8bf7\u6c42\uff1a" + url));
        HttpClient httpClient = new HttpClient();
        GetMethod method = new GetMethod(url);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
            httpClient.getHttpConnectionManager().getParams().setSoTimeout(60000);
            httpClient.executeMethod((HttpMethod)method);
            map.put("result", method.getResponseBodyAsString());
            method.releaseConnection();
        }
        catch (HttpException e) {
            HttpClientHelper.setError(map, (Exception)((Object)e));
            logger.error((Object)e.getMessage());
        }
        catch (IOException e) {
            HttpClientHelper.setError(map, e);
            logger.error((Object)e.getMessage());
        }
        logger.info((Object)("\u8fd4\u56de\u7ed3\u679c\uff1a" + map.get("result")));
        return map;
    }

    private static void setError(Map map, Exception e) {
        map.put("errcode", "60000");
        map.put("description", e.getMessage());
    }

    public static void main(String[] args) {
        HttpClientHelper.post("http://192.168.63.22:51524/", "{\"aaaa\":\"\u6211\u4eec\"}");
    }
}

