/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.ps.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tm.common.invoicePool.TjbbStatusEnum;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.client.MySwingWork;
import com.kingdee.eas.tm.im.client.MyThreadPool;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.pool.PoolDiskPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.ps.CheckQueryDataInfo;
import com.kingdee.eas.tm.im.ps.CheckQueryInfo;
import com.kingdee.eas.tm.im.ps.CheckServiceFacadeFactory;
import com.kingdee.eas.tm.im.ps.client.AbstractInvoiceCheckFilterUI;
import com.kingdee.eas.tm.im.util.IMPermissionUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class InvoiceCheckFilterUI
extends AbstractInvoiceCheckFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InvoiceCheckFilterUI.class);
    private static String trueStr = EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"TRUE");
    private static String falseStr = EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"FALSE");
    private static String year = EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Msg_Year");
    private static String month = EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Msg_Month");
    private static String day = EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Msg_Day");
    protected Map result = new HashMap();
    protected Map<String, PwyInvokeParam> allParams = new HashMap<String, PwyInvokeParam>();
    private int invoicePercent = 0;
    private String TB_TAXNO = "taxNo";
    private String TB_COMPANY = "company";
    private String TB_TAXPERIOD = "taxPeriod";
    private String TB_DATERANGE = "dateRange";
    private String TB_ISALLOWGX = "isAllowGxInvoice";
    private String TB_TJBBSTATUS = "createTjbbStatus";

    public void setResult(Map result) {
        this.result = result;
    }

    public Map getResult() {
        return this.result;
    }

    public void onLoad() throws Exception {
        this.kDTable.checkParsed();
        this.kDTable.setEditable(false);
        this.kDTable.getActionMap().remove("Paste");
        this.kDTable.getActionMap().remove("Delete");
        this.kDTable.removeRows();
        String[] mergeColumnKeys = new String[]{"taxNo", "taxPeriod", "dateRange", "isAllowGxInvoice", "createTjbbStatus"};
        this.kDTable.getGroupManager().setGroup(true);
        IColumn col = null;
        for (int i = 0; i < mergeColumnKeys.length; ++i) {
            col = this.kDTable.getColumn(mergeColumnKeys[i]);
            if (col != null) {
                col.setGroup(true);
                col.setMergeable(true);
                continue;
            }
            logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
        }
        super.onLoad();
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        } else {
            this.setDefaultValue();
            this.allParams.clear();
            this.kDTable.removeRows();
            this.kDTextPane1.setText(this.getTips());
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompanyOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected String getViewPermission() {
        return "im_CheckService_view";
    }

    protected void setDefaultValue() {
        this.rdUnChecked.setSelected(true);
        this.rdAll.setSelected(true);
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo filterInvoiceType;
        FilterItemInfo filtercheckSatus;
        FilterInfo filterInfo = super.getFilterInfo();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        FilterInfo newFilterInfo = new FilterInfo();
        FilterInfo orgFilterInfos = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd hh:mm:ss");
        for (String taxNo : this.allParams.keySet()) {
            CheckQueryInfo checkInfo;
            PwyInvokeParam invokeParam = this.allParams.get(taxNo);
            HashSet<String> orgIds = new HashSet<String>();
            Map retMap = invokeParam.getInvokeActionMap();
            if (retMap == null || retMap.get("CheckQueryInfo") == null || (checkInfo = (CheckQueryInfo)retMap.get("CheckQueryInfo")) == null || checkInfo.getDataInfos() == null || checkInfo.getDataInfos().isEmpty() || !checkInfo.getDataInfos().get(0).isAllowGxInvoice()) continue;
            FilterInfo groupFilterInfos = new FilterInfo();
            List orgList = (List)retMap.get("orgList");
            for (int i = 0; i < orgList.size(); ++i) {
                orgIds.add(((CompanyOrgUnitInfo)orgList.get(i)).getId().toString());
            }
            try {
                groupFilterInfos.getFilterItems().add(new FilterItemInfo("company.id", orgIds, CompareType.INCLUDE));
                String[] date = checkInfo.getDataInfos().get(0).getGxrqfw().split("-");
                groupFilterInfos.getFilterItems().add(new FilterItemInfo("invoiceDate", (Object)sdf.parse(date[0] + " 00:00:00"), CompareType.GREATER_EQUALS));
                groupFilterInfos.getFilterItems().add(new FilterItemInfo("invoiceDate", (Object)sdf.parse(date[1] + " 23:59:59"), CompareType.LESS_EQUALS));
                groupFilterInfos.setMaskString("( #0 and #1 and #2 )");
                if (orgFilterInfos == null) {
                    orgFilterInfos = groupFilterInfos;
                    continue;
                }
                orgFilterInfos.mergeFilter(groupFilterInfos, "OR");
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        if (this.rdUnChecked.isSelected()) {
            filtercheckSatus = new FilterItemInfo("checkState", (Object)Character.valueOf('0'), CompareType.EQUALS);
            newFilterInfo.getFilterItems().add(filtercheckSatus);
            this.result.put("checkState", "UnChecked");
        } else if (this.rdChecked.isSelected()) {
            filtercheckSatus = new FilterItemInfo("checkState", (Object)Character.valueOf('1'), CompareType.EQUALS);
            newFilterInfo.getFilterItems().add(filtercheckSatus);
            this.result.put("checkState", "Checked");
            FilterItemInfo filtercheckPurpose = new FilterItemInfo("checkPurpose", (Object)Character.valueOf('0'), CompareType.EQUALS);
            newFilterInfo.getFilterItems().add(filtercheckPurpose);
        }
        if (this.rdAll.isSelected()) {
            filterInvoiceType = new FilterItemInfo("invoiceType", new HashSet(Arrays.asList((Object[])new Object[]{"4", "2", "15", "12", "27"})), CompareType.INCLUDE);
            newFilterInfo.getFilterItems().add(filterInvoiceType);
            this.result.put("invoiceType", "All");
        } else if (this.rdSpecial.isSelected()) {
            filterInvoiceType = new FilterItemInfo("invoiceType", new HashSet(Arrays.asList((Object[])new Object[]{"4"})), CompareType.INCLUDE);
            newFilterInfo.getFilterItems().add(filterInvoiceType);
            this.result.put("invoiceType", "Special");
        } else if (this.rdElecSpecial.isSelected()) {
            filterInvoiceType = new FilterItemInfo("invoiceType", new HashSet(Arrays.asList((Object[])new Object[]{"2"})), CompareType.INCLUDE);
            newFilterInfo.getFilterItems().add(filterInvoiceType);
            this.result.put("invoiceType", "ElecSpecial");
        } else if (this.rdToll.isSelected()) {
            filterInvoiceType = new FilterItemInfo("invoiceType", new HashSet(Arrays.asList((Object[])new Object[]{"15"})), CompareType.INCLUDE);
            newFilterInfo.getFilterItems().add(filterInvoiceType);
            this.result.put("invoiceType", "Toll");
        } else if (this.rdVehicle.isSelected()) {
            filterInvoiceType = new FilterItemInfo("invoiceType", new HashSet(Arrays.asList((Object[])new Object[]{"12"})), CompareType.INCLUDE);
            newFilterInfo.getFilterItems().add(filterInvoiceType);
            this.result.put("invoiceType", "Vehicle");
        } else if (this.rdFullElecSpecial.isSelected()) {
            filterInvoiceType = new FilterItemInfo("invoiceType", new HashSet(Arrays.asList((Object[])new Object[]{"27"})), CompareType.INCLUDE);
            newFilterInfo.getFilterItems().add(filterInvoiceType);
            this.result.put("invoiceType", "FullElecSpecial");
        }
        try {
            if (orgFilterInfos == null) {
                orgFilterInfos = new FilterInfo();
                HashSet<String> idSet = new HashSet<String>();
                if (this.prmtCompanyOrgUnit.getValue() != null) {
                    Object[] obj = this.prmtCompanyOrgUnit.getValue() instanceof Object[] ? (Object[])this.prmtCompanyOrgUnit.getValue() : new Object[]{this.prmtCompanyOrgUnit.getValue()};
                    for (int i = 0; i < obj.length; ++i) {
                        idSet.add(((CompanyOrgUnitInfo)obj[i]).getId().toString());
                    }
                }
                orgFilterInfos.getFilterItems().add(new FilterItemInfo("company.id", idSet, CompareType.INCLUDE));
                orgFilterInfos.getFilterItems().add(new FilterItemInfo("company.id", (Object)"111111111111111", CompareType.EQUALS));
            }
            newFilterInfo.mergeFilter(orgFilterInfos, "and");
            filterInfo.mergeFilter(newFilterInfo, "and");
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        FilterItemCollection filters = entityViewInfo.getFilter().getFilterItems();
        Object checkState = IMUtils.getCompareValue(filters, "checkState", CompareType.EQUALS);
        if ("0".equals(checkState)) {
            this.rdUnChecked.setSelected(true);
            this.rdChecked.setSelected(false);
        } else {
            this.rdUnChecked.setSelected(false);
            this.rdChecked.setSelected(true);
        }
        Object invoiceType = IMUtils.getCompareValue(filters, "invoiceType", CompareType.INCLUDE);
        JComponent[] rdButtons = new JComponent[]{this.rdAll, this.rdSpecial, this.rdElecSpecial, this.rdToll, this.rdVehicle, this.rdFullElecSpecial};
        int selectedIndex = -1;
        if (((Collection)invoiceType).contains("4") && ((Collection)invoiceType).contains("2") && ((Collection)invoiceType).contains("15") && ((Collection)invoiceType).contains("12") && ((Collection)invoiceType).contains("27")) {
            selectedIndex = 0;
        } else if (((Collection)invoiceType).contains("4")) {
            selectedIndex = 1;
        } else if (((Collection)invoiceType).contains("2")) {
            selectedIndex = 2;
        } else if (((Collection)invoiceType).contains("15")) {
            selectedIndex = 3;
        } else if (((Collection)invoiceType).contains("12")) {
            selectedIndex = 4;
        } else if (((Collection)invoiceType).contains("27")) {
            selectedIndex = 5;
        }
        KDRadioButton rdButton = null;
        for (int i = 0; i < rdButtons.length; ++i) {
            rdButton = (KDRadioButton)rdButtons[i];
            if (i == selectedIndex) {
                rdButton.setSelected(true);
                continue;
            }
            rdButton.setSelected(false);
        }
        List objs = IMUtils.getCompareValues(filters, "company.id", CompareType.INCLUDE);
        HashSet companyIds = new HashSet();
        HashSet<String> perOrg = new HashSet<String>();
        for (int i = 0; i < objs.size(); ++i) {
            Object obj = objs.get(i);
            companyIds.addAll((Collection)obj);
        }
        OrgUnitInfo orgUnitInfo = null;
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        try {
            OrgUnitInfo[] perOrgs = IMPermissionUtil.getAuthOrgByPermItem(null, (IObjectPK)new ObjectUuidPK(userInfo.getId()), this.getMainBizOrgType(), this.getViewPermission());
            for (int i = 0; i < perOrgs.length; ++i) {
                orgUnitInfo = perOrgs[i];
                perOrg.add(orgUnitInfo.getId().toString());
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        companyIds.retainAll(perOrg);
        if (companyIds.size() == 0) {
            this.prmtCompanyOrgUnit.setValue(null);
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            CompanyOrgUnitCollection bizOrgs = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            OrgUnitInfo[] orgUnits = new OrgUnitInfo[bizOrgs.size()];
            if (bizOrgs != null && bizOrgs.size() > 0) {
                for (int i = 0; i < bizOrgs.size(); ++i) {
                    orgUnits[i] = bizOrgs.get(i);
                }
            }
            this.prmtCompanyOrgUnit.setValue((Object)orgUnits);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void afterMainOrgChanged(String ids) {
        super.afterMainOrgChanged(ids);
        this.allParams.clear();
        this.kDTable.removeRows();
        this.kDTextPane1.setText(this.getTips());
        if (ids == null) {
            return;
        }
        String[] idStr = ids.split(",");
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < idStr.length; ++i) {
            idSet.add(idStr[i]);
        }
        this.result.put("orgIds", idSet);
        if (idSet.size() > 0) {
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("orgIds", idSet);
            body.put("msgType", (Object)PwyServiceType.OPR_POOL_CHECKSERVICE_REPORT_QUERY);
            body.put("ownerSystem", (Object)TransSrcSystemEnum.easgui);
            try {
                final Map result = CheckServiceFacadeFactory.getRemoteInstance().buildRptQueryInvokeParam(body);
                this.allParams.clear();
                this.kDTable.removeRows();
                this.kDTextPane1.setText(this.getTips());
                final ArrayList errList = new ArrayList();
                this.invoicePercent = 10;
                final MonitorInfo info = new MonitorInfo(EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"CHECK_REPORT_QUERY"), null, (Object)this, true);
                MySwingWork worker = new MySwingWork(1000){

                    public Object construct() {
                        try {
                            for (String taxNo : result.keySet()) {
                                InvoiceCheckFilterUI.this.invokeCheckQueryPwy(taxNo, result, errList);
                            }
                            InvoiceCheckFilterUI.this.allParams.putAll(result);
                            InvoiceCheckFilterUI.this.kDTextPane1.setText(IMUtils.buildErrorMsg(errList));
                            InvoiceCheckFilterUI.this.addRows();
                        }
                        catch (Exception ex) {
                            ExceptionHandler.handle((Throwable)ex);
                        }
                        catch (Throwable ex) {
                            ExceptionHandler.handle((Throwable)ex);
                        }
                        return null;
                    }

                    public void finished() {
                        this.timerStop();
                        MyThreadPool.destroyMonitor(info);
                        MyThreadPool.destroyPorgressDialog();
                        InvoiceCheckFilterUI.this.invoicePercent = 100;
                    }

                    @Override
                    public void refreshProgress() {
                        if (InvoiceCheckFilterUI.this.invoicePercent < 99) {
                            InvoiceCheckFilterUI.this.invoicePercent++;
                        }
                        try {
                            MyThreadPool.refreshProgress(info, InvoiceCheckFilterUI.this.invoicePercent);
                        }
                        catch (Throwable ex) {
                            logger.error((Object)("refreshProgress error=" + ex.getMessage()));
                        }
                    }
                };
                info.setWorker((SwingWorker)worker);
                MyThreadPool.getInstance();
                MyThreadPool.addActionThread(info);
                MyThreadPool.setBackgroundRunButtonEnabled(false);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
    }

    private void invokeCheckQueryPwy(String taxNo, Map<String, PwyInvokeParam> result, ArrayList errList) throws BOSException, JSONException, EASBizException {
        PwyInvokeParam invokeParam = result.get(taxNo);
        PoolDiskPwyService pwyService = (PoolDiskPwyService)PwyServiceHelper.getPwyService(null, invokeParam);
        pwyService.invoke();
        if (!pwyService.isSuccess() || !new JSONObject(invokeParam.getRevMsg()).has("data")) {
            errList.add(EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Err_CheckQuery", (Object[])new Object[]{taxNo, invokeParam.getDescription()}));
        } else if (((CheckQueryInfo)invokeParam.getInvokeActionMap().get("CheckQueryInfo")).getDataInfos().size() > 0 && !((CheckQueryInfo)invokeParam.getInvokeActionMap().get("CheckQueryInfo")).getDataInfos().get(0).isAllowGxInvoice()) {
            errList.add(EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Err_GXStatus", (Object[])new Object[]{taxNo}));
        }
    }

    protected void addRows() {
        List tjbbStatus = TjbbStatusEnum.getEnumList();
        HashMap<String, String> taxPeriodMap = new HashMap<String, String>();
        for (String taxNo : this.allParams.keySet()) {
            PwyInvokeParam invokeParam = this.allParams.get(taxNo);
            Map retMap = invokeParam.getInvokeActionMap();
            if (retMap == null || retMap.get("CheckQueryInfo") == null) continue;
            CheckQueryInfo checkInfo = (CheckQueryInfo)retMap.get("CheckQueryInfo");
            if (!(retMap.get("orgList") instanceof ArrayList) || ((ArrayList)retMap.get("orgList")).size() <= 0 || checkInfo.getDataInfos().size() <= 0) continue;
            CheckQueryDataInfo dataInfo = checkInfo.getDataInfos().get(0);
            String taxPeriod = this.formatTaxPeriod(dataInfo.getSkssq());
            String dateRange = this.formatGxrqfw(dataInfo.getGxrqfw());
            boolean allowGxInvoice = dataInfo.isAllowGxInvoice();
            String createTjbbStatus = dataInfo.getCreateTjbbStatus();
            ArrayList orglist = (ArrayList)retMap.get("orgList");
            for (int i = 0; i < orglist.size(); ++i) {
                IRow row = this.kDTable.addRow();
                row.getCell(this.TB_TAXNO).setValue((Object)taxNo);
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)orglist.get(i);
                row.getCell(this.TB_COMPANY).setValue((Object)company.getName());
                row.getCell(this.TB_TAXPERIOD).setValue((Object)taxPeriod);
                row.getCell(this.TB_DATERANGE).setValue((Object)dateRange);
                if (allowGxInvoice) {
                    row.getCell(this.TB_ISALLOWGX).setValue((Object)trueStr);
                } else {
                    row.getCell(this.TB_ISALLOWGX).setValue((Object)falseStr);
                }
                for (TjbbStatusEnum status : tjbbStatus) {
                    if (!status.getValue().equals(createTjbbStatus)) continue;
                    row.getCell(this.TB_TJBBSTATUS).setValue((Object)status.getAlias());
                    break;
                }
                taxPeriodMap.put(company.getId().toString(), dataInfo.getSkssq().substring(0, 6));
            }
        }
        this.result.put("taxPeriodMap", taxPeriodMap);
    }

    private String formatGxrqfw(String gxrqfw) {
        StringBuffer formatStr = new StringBuffer();
        String[] split = gxrqfw.split("-");
        for (int i = 0; i < split.length; ++i) {
            if (formatStr.length() > 0) {
                formatStr.append("-");
            }
            formatStr.append(split[i].substring(0, 4)).append(year).append(split[i].substring(4, 6)).append(month).append(split[i].substring(6)).append(day);
        }
        return formatStr.toString();
    }

    private String formatTaxPeriod(String skssq) {
        StringBuffer formatStr = new StringBuffer();
        formatStr.append(skssq.substring(0, 4)).append(year).append(skssq.substring(4, 6)).append(month);
        return formatStr.toString();
    }

    public boolean verify() {
        if (this.prmtCompanyOrgUnit.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Err_ORGNOTNULL"));
            return false;
        }
        return true;
    }

    protected String getTips() {
        return "";
    }
}

