/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.ps.client.util;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class PSClientUtils {
    public static List getSelectIDs(KDTable table, String fieldName, String idField) {
        ArrayList<Object> ids = new ArrayList<Object>();
        int count = table.getRowCount3();
        for (int i = 0; i < count; ++i) {
            IRow row = table.getRow(i);
            if (row.getCell(fieldName) == null || row.getCell(fieldName).getValue() == null || !((Boolean)row.getCell(fieldName).getValue()).booleanValue()) continue;
            ids.add(row.getCell(idField).getValue());
        }
        return ids;
    }

    public static KDTSelectListener getSelectListener(final String fieldName, final String[] fieldSumList) {
        KDTSelectListener tableSelectChanged = new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock selectBlock = e.getSelectBlock();
                KDTable table = (KDTable)e.getSource();
                int selectCol = table.getColumnIndex(fieldName);
                IRow iRow = null;
                boolean isSelectedChange = false;
                int size = table.getSelectManager().size();
                for (int i = 0; i < size; ++i) {
                    selectBlock = table.getSelectManager().get(i);
                    int length = selectBlock.getBottom();
                    for (int j = selectBlock.getTop(); j <= length; ++j) {
                        iRow = table.getRow(j);
                        if (iRow == null) continue;
                        boolean isSelected = Boolean.TRUE.equals(iRow.getCell(fieldName).getValue());
                        int selectBeginCol = selectBlock.getBeginCol();
                        int selectEndCol = selectBlock.getEndCol();
                        int selectBiginRow = selectBlock.getBeginRow();
                        int selectEndRow = selectBlock.getEndRow();
                        if (selectCol != selectBeginCol || selectBeginCol != selectEndCol || selectBeginCol == -1 || selectBiginRow == selectEndRow) continue;
                        iRow.getCell(fieldName).setValue((Object)(!isSelected ? 1 : 0));
                        if (iRow.getCell("FLevel") != null && iRow.getCell("FLevel").getValue() != null && "4".equals(iRow.getCell("FLevel").getValue().toString()) && iRow.getCell("FSelect") != null) {
                            iRow.getCell("FSelect").setValue(null);
                        }
                        isSelectedChange = true;
                    }
                }
                if (isSelectedChange) {
                    PSClientUtils.doSelectSum(fieldName, fieldSumList, table);
                }
            }
        };
        return tableSelectChanged;
    }

    public static void doSelectSum(String fieldName, String[] fieldSumList, KDTable table) {
        if (fieldName == null || fieldSumList == null || table == null) {
            return;
        }
        BigDecimal[] result = new BigDecimal[fieldSumList.length];
        int count = table.getRowCount3();
        for (int i = 0; i < count; ++i) {
            if (!((Boolean)table.getCell(i, fieldName).getValue()).booleanValue()) continue;
            int len = fieldSumList.length;
            for (int j = 0; j < len; ++j) {
                if (result[j] == null) {
                    result[j] = SysConstant.BIGZERO;
                }
                if (table.getCell(i, fieldSumList[j]) == null || table.getCell(i, fieldSumList[j]).getValue() == null) continue;
                result[j] = result[j].add(new BigDecimal(table.getCell(i, fieldSumList[j]).getValue().toString()));
            }
        }
        IRow footRow = table.getFootRow(0);
        int len = fieldSumList.length;
        for (int i = 0; i < len; ++i) {
            if (result[i] != null) {
                footRow.getCell(fieldSumList[i]).setValue((Object)result[i]);
                continue;
            }
            footRow.getCell(fieldSumList[i]).setValue((Object)SysConstant.BIGZERO);
        }
    }

    public static void cleanSum(String fieldName, String[] fieldSumList, KDTable table) {
        if (fieldName == null || fieldSumList == null || table == null) {
            return;
        }
        IRow footRow = table.getFootRow(0);
        if (footRow == null) {
            return;
        }
        int len = fieldSumList.length;
        for (int i = 0; i < len; ++i) {
            footRow.getCell(fieldSumList[i]).setValue((Object)SysConstant.BIGZERO);
        }
    }

    public static BigDecimal getBigDecimal(Object o) {
        if (o == null) {
            return null;
        }
        return new BigDecimal(o.toString());
    }

    public static void appendSelectFootRow(KDTable table, String[] fieldSumList) {
        IRow footRow = null;
        KDTFootManager footRowManager = table.getFootManager();
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Msg_SelectTotal");
            footRowManager = new KDTFootManager(table);
            footRowManager.addFootView();
            table.setFootManager(footRowManager);
            footRow = footRowManager.addFootRow(0);
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            table.getIndexColumn().setWidthAdjustMode((short)1);
            table.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        } else {
            footRow = footRowManager.getFootRow(0);
        }
        int columnCount = table.getColumnCount();
        for (int c = 0; c < columnCount; ++c) {
            String fieldName = table.getColumn(c).getKey();
            for (int i = 0; i < fieldSumList.length; ++i) {
                String name = fieldSumList[i];
                if (!name.equalsIgnoreCase(fieldName)) continue;
                ICell cell = footRow.getCell(c);
                cell.getStyleAttributes().setNumberFormat("#,##0.00");
                cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                cell.getStyleAttributes().setFontColor(Color.BLACK);
                cell.setValue((Object)SysConstant.BIGZERO);
            }
        }
        footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
    }

    public static void selectRows(KDTable table, String field, boolean flag) {
        Boolean select = flag;
        int count = table.getRowCount3();
        for (int i = 0; i < count; ++i) {
            table.getCell(i, field).setValue((Object)select);
        }
    }

    public static BigDecimal getBigDecimal(IRow row, String col) {
        Object value = row.getCell(col).getValue();
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(value.toString());
    }
}

