/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.tm.im.FilterCommonStatusEnum;
import com.kingdee.eas.tm.im.rpt.AddSyncLogDataTypeEnum;
import com.kingdee.eas.tm.im.rpt.AddSyncLogStatusEnum;
import com.kingdee.eas.tm.im.rpt.client.AbstractAddSyncLogRptConditionUI;
import com.kingdee.eas.tm.im.util.IMPermissionUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class AddSyncLogRptConditionUI
extends AbstractAddSyncLogRptConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(AddSyncLogRptConditionUI.class);
    public static final String BD_ADD_SYNC_LOG_VIEW = "bd_addSyncLog_view";
    private OrgUnitInfo defaultOrgUnit;

    public void onInit(RptParams initParams) throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCompanyF7();
        this.setDefaultMainBizOrg();
        this.comboSyncStatus.removeAllItems();
        this.comboSyncStatus.addItem((Object)FilterCommonStatusEnum.NULL);
        this.comboSyncStatus.addItems(AddSyncLogStatusEnum.getEnumList().toArray());
    }

    private void setDefaultMainBizOrg() throws EASBizException, BOSException {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        OrgUnitInfo[] orgUnits = IMPermissionUtil.getAuthOrgByPermItem(null, (IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, BD_ADD_SYNC_LOG_VIEW);
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(OrgType.Company);
        if (orgUnits != null && orgUnits.length > 0) {
            for (int i = 0; i < orgUnits.length; ++i) {
                companyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnits[i];
                if (!companyOrgUnitInfo.getId().toString().equals(currentMainOrg.getId().toString())) continue;
                this.defaultOrgUnit = currentMainOrg;
            }
            if (this.defaultOrgUnit == null) {
                this.defaultOrgUnit = orgUnits[0];
            }
            this.bizOrgUnit.setValue((Object)this.defaultOrgUnit);
        }
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("companyId", this.bizOrgUnit.getValue());
        para.setObject("startDate", (Object)this.startDate.getText());
        para.setObject("endDate", (Object)this.endDate.getText());
        if (this.comboDataType.getSelectedItem() != null) {
            para.setObject("dataType", (Object)((AddSyncLogDataTypeEnum)((Object)this.comboDataType.getSelectedItem())).getValue());
        } else {
            para.setObject("dataType", null);
        }
        if (this.comboSyncStatus.getSelectedItem() != null && this.comboSyncStatus.getSelectedItem() != FilterCommonStatusEnum.NULL) {
            para.setObject("syncStatus", (Object)((AddSyncLogStatusEnum)((Object)this.comboSyncStatus.getSelectedItem())).getValue());
        } else {
            para.setObject("syncStatus", null);
        }
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.bizOrgUnit.setValue(params.getObject("companyId"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (params.getObject("startDate") != null && !"".equals(params.getObject("startDate"))) {
                Date dateFrom = sdf.parse(params.getObject("startDate").toString());
                this.startDate.setValue((Object)dateFrom);
            }
            if (params.getObject("endDate") != null && !"".equals(params.getObject("endDate"))) {
                Date dateTo = sdf.parse(params.getObject("endDate").toString());
                this.endDate.setValue((Object)dateTo);
            }
        }
        catch (ParseException e) {
            this.handUIException(e);
        }
        if (params.getObject("dataType") != null) {
            this.comboDataType.setSelectedItem((Object)AddSyncLogDataTypeEnum.getEnum((String)params.getObject("dataType")));
        } else {
            this.comboDataType.setSelectedItem((Object)AddSyncLogDataTypeEnum.INV);
        }
        if (params.getObject("syncStatus") != null) {
            this.comboSyncStatus.setSelectedItem((Object)AddSyncLogStatusEnum.getEnum((String)params.getObject("syncStatus")));
        } else {
            this.comboSyncStatus.setSelectedItem((Object)FilterCommonStatusEnum.NULL);
        }
    }

    private void initCompanyF7() {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, BD_ADD_SYNC_LOG_VIEW);
        this.bizOrgUnit.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    public void clear() {
        this.bizOrgUnit.setValue((Object)this.defaultOrgUnit);
        SCMQueryFormat.formatStartTime((KDDatePicker)this.startDate);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.endDate);
        this.comboSyncStatus.setSelectedItem((Object)FilterCommonStatusEnum.NULL);
        this.comboDataType.setSelectedItem((Object)AddSyncLogDataTypeEnum.INV);
    }

    public boolean verify() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateFrom = null;
        String dateTo = null;
        if (this.bizOrgUnit.getText().isEmpty()) {
            MsgBox.showInfo((String)this.getResource("companyNotNull"));
            return false;
        }
        if (this.startDate.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("dateNotNull"));
            return false;
        }
        dateFrom = sdf.format(this.startDate.getValue());
        if (this.endDate.getValue() == null) {
            MsgBox.showInfo((String)this.getResource("dateNotNull"));
            return false;
        }
        dateTo = sdf.format(this.endDate.getValue());
        if (dateFrom != null && dateTo != null && dateTo.compareTo(dateFrom) < 0) {
            MsgBox.showInfo((String)this.getResource("Error_BizDate"));
            return false;
        }
        return super.verify();
    }

    private String getResource(String key) {
        return IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", key, IMUtils.getLocale());
    }
}

