/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsFactory;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.api.AbstractDataUpgrade;
import com.kingdee.eas.tm.im.util.CheckAbsUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class IncomeInvoiceCheckAbsDataUpgrade
extends AbstractDataUpgrade {
    private static Logger logger = Logger.getLogger((String)IncomeInvoiceCheckAbsDataUpgrade.class.getName());

    @Override
    protected void doUpgrade(Context ctx, DataUpgradeTraceInfo info) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("checkAbs", null, CompareType.EQUALS));
        HashSet<String> invoiceTypeSet = new HashSet<String>();
        invoiceTypeSet.add("1");
        invoiceTypeSet.add("3");
        filter.getFilterItems().add(new FilterItemInfo("invoiceType", invoiceTypeSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection checkAbsColl = new CoreBaseCollection();
        String psql = "update T_IM_IncomeInvoice set FCheckAbsID = ? where FID = ? ";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        try {
            IncomeInvoiceCollection coll = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                IncomeInvoiceInfo invoice = coll.get(i);
                CheckAbsInfo checkAbs = CheckAbsUtil.createCheckAbs(invoice);
                checkAbs.setIsAllowCheck(true);
                checkAbsColl.add((CoreBaseInfo)checkAbs);
                params.add(new Object[]{checkAbs.getId().toString(), invoice.getId().toString()});
            }
            CheckAbsFactory.getLocalInstance((Context)ctx).saveBatchData(checkAbsColl);
            DbUtil.executeBatch((Context)ctx, (String)psql, params);
            info.setIsProcessed(true);
            logger.debug((Object)"upgrade success");
        }
        catch (Exception e) {
            info.setIsProcessed(false);
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

