/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TableManager;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.api.AbstractDataUpgrade;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MakeInvoiceReqProductDataUpgrade
extends AbstractDataUpgrade {
    private static Logger logger = Logger.getLogger(MakeInvoiceReqProductDataUpgrade.class);
    private Map<String, ProductCodeInfo> productCache = new HashMap<String, ProductCodeInfo>();

    @Override
    protected void doUpgrade(Context ctx, DataUpgradeTraceInfo info) throws BOSException {
        try {
            String bakTblName = info.getBakTblName();
            if (StringUtils.isEmpty((String)bakTblName)) {
                bakTblName = TableManager.getTableManager((Context)ctx).getTableName(MakeInvoiceReqProductDataUpgrade.class.getName());
                info.setBakTblName(bakTblName);
                String bakSql = "select * into " + bakTblName + " from T_IM_MAKEINVOICEREQENTRY;";
                try {
                    DbUtil.execute((Context)ctx, (String)bakSql);
                }
                catch (Throwable e) {
                    logger.error((Object)("MakeInvoiceReqProductDataUpgrade backup failed.e=" + e));
                }
            }
            ctx.put((Object)"disablePermissionForKScript", (Object)true);
            String sql = "select ime.fid as entryID,im.FAsstActID,im.FCompanyID,act.FRealtionDataObject,ime.FTaxRate,m.fid as materialID,e.fid as expenseItemID,ime.FTaxClassificationCode, m.FName_l2 as materialName,e.FName_l2 as expenseItemName,im.FIsVehicle as isVehicle,im.FIsDiffTax as isDiffTax from T_IM_MAKEINVOICEREQ im inner join T_IM_MAKEINVOICEREQENTRY ime on im.fid=ime.fparentid LEFT OUTER JOIN T_BD_Material AS m ON ime.FMaterialID = m.FID LEFT OUTER JOIN T_BC_ExpenseType AS e ON ime.FExpenseItemID = e.FID LEFT OUTER JOIN T_BD_AsstActType AS act ON im.FAsstActTypeID = act.FID where im.fstatus in (0,1) and ime.fProductName is null and ime.FTaxClassificationCode is null";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            try {
                while (rs.next()) {
                    String entryID = rs.getString("entryID");
                    String asstActID = rs.getString("FAsstActID");
                    String realtionDataObject = rs.getString("FRealtionDataObject");
                    BigDecimal taxRate = rs.getBigDecimal("FTaxRate");
                    String materialID = rs.getString("materialID");
                    String expenseItemID = rs.getString("expenseItemID");
                    String expenseItemName = rs.getString("expenseItemName");
                    String materialName = rs.getString("materialName");
                    String companyId = rs.getString("FCompanyID");
                    boolean isVehicle = rs.getBoolean("isVehicle");
                    boolean isDiffTax = rs.getBoolean("isDiffTax");
                    String customerId = null;
                    if ("T_BD_Customer".equalsIgnoreCase(realtionDataObject)) {
                        customerId = asstActID;
                    }
                    if (taxRate == null) continue;
                    BigDecimal realTaxRate = taxRate.setScale(4, RoundingMode.HALF_UP);
                    String key = null;
                    String needUpdateProductName = null;
                    String needUpdateProductID = null;
                    String needUpdateTccCode = null;
                    if (materialID != null) {
                        needUpdateProductName = materialName;
                        key = companyId + customerId + materialID + realTaxRate;
                    } else {
                        if (expenseItemID == null) continue;
                        needUpdateProductName = expenseItemName;
                        key = companyId + customerId + expenseItemID + realTaxRate;
                    }
                    ProductCodeInfo product = null;
                    if (this.productCache.containsKey(key)) {
                        product = this.productCache.get(key);
                    } else {
                        product = ProductCodeFactory.getLocalInstance(ctx).getMatchProduct(customerId, companyId, materialID, expenseItemID, realTaxRate, isVehicle, isDiffTax);
                        this.productCache.put(key, product);
                    }
                    if (product != null) {
                        needUpdateProductID = product.getId().toString();
                        needUpdateProductName = product.getName();
                        needUpdateTccCode = product.getTaxClassificationCode().getMergeCode();
                    }
                    paramsList.add(new Object[]{needUpdateProductID, needUpdateProductName, needUpdateTccCode, entryID});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (paramsList != null && paramsList.size() > 0) {
                StringBuffer strBuf = new StringBuffer();
                strBuf.append("UPDATE").append("\r\n");
                strBuf.append("T_IM_MAKEINVOICEREQENTRY").append("\r\n");
                strBuf.append("SET").append("\r\n");
                strBuf.append("FProductCodeID=?,").append("\r\n");
                strBuf.append("FProductName=?,").append("\r\n");
                strBuf.append("FTaxClassificationCode=?").append("\r\n");
                strBuf.append("WHERE FID=?").append("\r\n");
                DbUtil.executeBatch((Context)ctx, (String)strBuf.toString(), paramsList);
            }
            info.setIsProcessed(true);
        }
        catch (Exception e) {
            info.setIsProcessed(false);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            ctx.remove((Object)"disablePermissionForKScript");
        }
    }
}

