/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckPurposeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckWayEnum;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.im.IncomeAuthenticateEnum;
import com.kingdee.eas.tm.im.IncomeAuthenticateStatusEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import java.sql.Timestamp;
import java.util.Date;

public class CheckAbsUtil {
    public static CheckAbsInfo createCheckAbs(Object invoice) {
        CheckAbsInfo checkAbs = new CheckAbsInfo();
        if (invoice instanceof IncomeInvoiceInfo) {
            IncomeInvoiceInfo info = (IncomeInvoiceInfo)invoice;
            BOSUuid bosid = BOSUuid.create((BOSObjectType)checkAbs.getBOSType());
            checkAbs.setId(bosid);
            checkAbs.setCompany(info.getCompany());
            checkAbs.setSalerName(info.getBillingCompany());
            checkAbs.setSalerTaxNo(info.getTaxNumber());
            if (info.getId() == null) {
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            }
            checkAbs.setInvoiceID(info.getId().toString());
            checkAbs.setInvoiceCode(info.getInvoiceCode());
            checkAbs.setInvoiceNo(info.getInvoiceNumber());
            checkAbs.setInvoiceDate(info.getBizDate());
            checkAbs.setAmount(info.getAmount());
            checkAbs.setTaxAmt(info.getTax());
            checkAbs.setEffectiveTaxAmt(info.getTax());
            if (IncomeStatusEnum.NORMAL.equals((Object)info.getStatus())) {
                checkAbs.setInvoiceState(TMInvoiceStatus.NORMAL);
            } else if (IncomeStatusEnum.LOSECONTROL.equals((Object)info.getStatus())) {
                checkAbs.setInvoiceState(TMInvoiceStatus.OUT_OF_CONTROL);
            } else if (IncomeStatusEnum.CANCEL.equals((Object)info.getStatus())) {
                checkAbs.setInvoiceState(TMInvoiceStatus.CANCEL);
            } else if (IncomeStatusEnum.CREDIT.equals((Object)info.getStatus())) {
                checkAbs.setInvoiceState(TMInvoiceStatus.RED);
            } else if (IncomeStatusEnum.UNUSUAL.equals((Object)info.getStatus())) {
                checkAbs.setInvoiceState(TMInvoiceStatus.ABNORMAL);
            } else if (IncomeStatusEnum.UNNORMAL.equals((Object)info.getStatus())) {
                checkAbs.setInvoiceState(TMInvoiceStatus.UNNORMAL);
            } else if (IncomeStatusEnum.UNCONFIRMRED.equals((Object)info.getStatus())) {
                checkAbs.setInvoiceState(TMInvoiceStatus.UNCONFIRMRED);
            } else if (IncomeStatusEnum.PARTLYRED.equals((Object)info.getStatus())) {
                checkAbs.setInvoiceState(TMInvoiceStatus.PARTLYRED);
            } else if (IncomeStatusEnum.FULLRED.equals((Object)info.getStatus())) {
                checkAbs.setInvoiceState(TMInvoiceStatus.FULLRED);
            }
            checkAbs.setInvoiceType(info.getTmInvoiceType());
            if (checkAbs.getInvoiceType() == null) {
                checkAbs.setInvoiceType(TMInvoiceType.INVOICETYPE_SPECIAL_PAPER);
            }
            if (IncomeAuthenticateStatusEnum.PASSED.equals((Object)info.getAuthenticateStatus())) {
                checkAbs.setCheckState(CheckStateEnum.Checked);
                checkAbs.setCheckPurpose(CheckPurposeEnum.Deduct);
                if (IncomeAuthenticateEnum.SCAN.equals((Object)info.getAuthenticateWay())) {
                    checkAbs.setCheckWay(CheckWayEnum.Scan);
                } else {
                    checkAbs.setCheckWay(CheckWayEnum.Check);
                }
                if (info.getAuthenticateDate() != null) {
                    Timestamp time = new Timestamp(info.getAuthenticateDate().getTime());
                    checkAbs.setCheckTime((Date)time);
                    checkAbs.setConfirmTime((Date)time);
                }
                if (info.getAuthenticator() != null) {
                    checkAbs.setCheckUser(info.getAuthenticator());
                    checkAbs.setConfirmUser(info.getAuthenticator());
                }
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
                checkAbs.setTaxPeriod(info.getBelongTaxPeriod());
            } else {
                checkAbs.setCheckState(CheckStateEnum.Unchecked);
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            }
        }
        return checkAbs;
    }

    public static CheckPurposeEnum getPurposeByValue(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        if ("1".equals(value)) {
            return CheckPurposeEnum.Deduct;
        }
        if ("2".equals(value)) {
            return CheckPurposeEnum.NonDeduct;
        }
        return null;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, String value, CompanyOrgUnitInfo company) {
        try {
            if (value == null || value.trim().isEmpty()) {
                return null;
            }
            int period = Integer.valueOf(value);
            if (ctx == null) {
                return PeriodUtils.getPeriodInfo((int)(period / 100), (int)(period % 100), (CompanyOrgUnitInfo)company);
            }
            return PeriodUtils.getPeriodInfo((Context)ctx, (int)(period / 100), (int)(period % 100), (CompanyOrgUnitInfo)company);
        }
        catch (Exception e) {
            return null;
        }
    }
}

