/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.sso.SSOHandleFacadeFactory;
import com.kingdee.eas.tm.common.utils.LogCheckUtil;
import com.kingdee.util.StringUtils;
import java.awt.Desktop;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class ExplorerUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.util.ExplorerUtil");
    private static final String UTF_8 = "utf-8";

    public static void viewInvoice(String invoiceId, String companyId, String invoiceUrl) throws Exception {
        if (ExplorerUtil.needToken(invoiceUrl)) {
            invoiceId = URLEncoder.encode(invoiceId, UTF_8);
            companyId = URLEncoder.encode(companyId, UTF_8);
            invoiceUrl = URLEncoder.encode(invoiceUrl, UTF_8);
            String url = "/easweb/tm/im/viewInvoice.do?method=viewInvoice";
            url = url + "&invoiceId=" + invoiceId;
            url = url + "&invoiceUrl=" + invoiceUrl;
            url = ExplorerUtil.getGUItoPortalUrl(url);
            ExplorerUtil.browse(url);
        } else {
            ExplorerUtil.browse(invoiceUrl);
        }
    }

    public static void toElectricInvoicePreviewPage(String cacheKey) throws Exception {
        cacheKey = URLEncoder.encode(cacheKey, "UTF-8");
        String url = "/easweb/dynamicPage.do?event=initialize&method=doEvent&uipk=com.kingdee.eas.tm.im.ElectricInvoicePreview&waf2skin=eascard&inwafpage=true&debug=true";
        url = url + "&cacheKey=" + cacheKey;
        url = ExplorerUtil.getGUItoPortalUrl(url);
        ExplorerUtil.browse(url);
    }

    private static boolean needToken(String invoiceUrl) {
        return !StringUtils.isEmpty((String)invoiceUrl) && invoiceUrl.indexOf("/m4/file/") >= 0;
    }

    public static String getGUItoPortalUrl(String url) {
        String result = null;
        String serverURL = System.getProperty("EASPORTAL_ROOT");
        if (StringUtils.isEmpty((String)serverURL)) {
            serverURL = "http://localhost:6888/easportal";
        }
        try {
            result = SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(URLEncoder.encode(url, UTF_8), true, SysContext.getSysContext().getLocale().toString(), SysContext.getSysContext().getDCNumber());
            result = serverURL + "/" + result;
        }
        catch (Exception e) {
            logger.error((Object)("[ExplorerUtil.getGUItoPortalUrl]" + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    public static void browse(String url) throws Exception {
        if (!ExplorerUtil.isURL(url)) {
            url = LogCheckUtil.validLog((String)url);
            logger.error((Object)("involid url:" + url));
            return;
        }
        String osName = System.getProperty("os.name", "");
        if (osName.startsWith("Mac OS")) {
            Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
            Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
            openURL.invoke(null, url);
        } else if (osName.startsWith("Windows")) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else {
            try {
                URI uri = new URI(url);
                Desktop.getDesktop().browse(uri);
            }
            catch (Exception e) {
                throw new Exception("Could not find web browser");
            }
        }
    }

    public static boolean isURL(String str) {
        String regex = "(https?|ftp|file)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]";
        return str.matches(regex);
    }
}

