/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvoiceDefNewDataProvider
extends DefaultNoteDataProvider {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.util.InvoiceDefNewDataProvider");
    private Set ids = null;
    private IMetaDataPK qpk = null;

    public InvoiceDefNewDataProvider(List id, IMetaDataPK qpk) {
        this.ids = new HashSet(id);
        this.qpk = qpk;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        IRowSet iRowSet = null;
        try {
            IMetaDataPK pk;
            if (!StringUtil.isEmptyString((String)dataSource.getReference())) {
                pk = MetaDataPKFactory.getMetaDataPK((String)dataSource.getReference());
                log.info((Object)("DefaultNoteDataProvider, datasource has BOSQuery reference. MetaDataPK: " + pk));
            } else {
                pk = this.qpk;
            }
            if (pk == null) {
                throw new R1PrintRuntimeException(MultiLanguageUtil.getMLS((String)"client.DefaultNoteDataProvider.exception", (String)ResourceBase.getString((String)"com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", (String)"ERR_CHECK_FORM_PRINT", (Locale)ContextUtils.getLocaleFromEnv())));
            }
            log.info((Object)("com.kingdee.eas.tm.im.util.InvoiceDefNewDataProvider, MetaDataPK is appointed: " + pk));
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
            exec.option().isAutoTranslateEnum = true;
            exec.option().isAutoTranslateBoolean = true;
            exec.option().isIgnoreOrder = true;
            EntityViewInfo ev = this.createWrappedBosRunsstimeInfo(dataSource);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
            ev.setFilter(filter);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return iRowSet;
    }

    public EntityViewInfo createWrappedBosRunsstimeInfo(R1PrintDataSource ds) {
        int i;
        EntityViewInfo evi = new EntityViewInfo();
        SorterItemCollection ori = (SorterItemCollection)evi.getSorter().clone();
        evi.getSorter().clear();
        R1PrintDataSortItem[] sorts = ds.getSortFields();
        int c = sorts.length;
        for (i = 0; i < c; ++i) {
            SorterItemInfo sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setPropertyName(sorts[i].getSortField());
            if (sorts[i].getSortType() == 1) {
                sorterItemInfo.setSortType(SortType.DESCEND);
            } else {
                sorterItemInfo.setSortType(SortType.ASCEND);
            }
            evi.getSorter().add(sorterItemInfo);
        }
        c = ori.size();
        for (i = 0; i < c; ++i) {
            evi.getSorter().add(ori.get(i));
        }
        return evi;
    }
}

