/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMakeInvoiceReq;
import com.kingdee.eas.tm.im.MakeInvoiceReqCollection;
import com.kingdee.eas.tm.im.MakeInvoiceReqException;
import com.kingdee.eas.tm.im.MakeInvoiceReqFactory;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqStatusEnum;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SIMUtils {
    public static boolean oneStepSIM(Context ctx, String orgId) throws EASBizException, BOSException {
        Map ParamMap = IMUtils.getParam(ctx, orgId, new String[]{"IMC003"});
        return SIMUtils.valueOfBool(ParamMap.get("IMC003"));
    }

    public static boolean getIMC004(Context ctx, String orgId) throws EASBizException, BOSException {
        Map ParamMap = IMUtils.getParam(ctx, orgId, new String[]{"IMC003", "IMC004"});
        return !SIMUtils.valueOfBool(ParamMap.get("IMC003")) && SIMUtils.valueOfBool(ParamMap.get("IMC004"));
    }

    public static void immediateMakeInvoiceWithSubmit(Context ctx, MakeInvoiceReqInfo info) throws EASBizException, BOSException {
        if (info.getCompany() != null && SIMUtils.getIMC004(ctx, info.getCompany().getId().toString())) {
            IMakeInvoiceReq service = MakeInvoiceReqFactory.getLocalInstance(ctx);
            service.passAudit((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBillBaseInfo)info);
        }
    }

    public static void oneStepMakeInvoiceWithSave(Context ctx, MakeInvoiceReqInfo info) throws BOSException, EASBizException {
        if (info.isIsBotp() && info.getCompany() != null && SIMUtils.oneStepSIM(ctx, info.getCompany().getId().toString())) {
            IMakeInvoiceReq service = MakeInvoiceReqFactory.getLocalInstance(ctx);
            service.submit((CoreBaseInfo)info);
            service.passAudit((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBillBaseInfo)info);
        }
    }

    public static void checkInvoiceBeforeSubmit(Context ctx, MakeInvoiceReqInfo info) throws BOSException, EASBizException {
        MakeInvoiceReqInfo infoFromDb;
        if (info != null && info.getId() != null && (infoFromDb = SIMUtils.getMakeInvoiceReqInfoFromDb(ctx, info.getId().toString())) != null && (MakeInvoiceReqStatusEnum.AUDITED.equals((Object)infoFromDb.getStatus()) || MakeInvoiceReqStatusEnum.DELETED.equals((Object)infoFromDb.getStatus()))) {
            throw new MakeInvoiceReqException(MakeInvoiceReqException.SUBMIT_ERROR);
        }
    }

    public static void checkInvoiceBeforeSave(Context ctx, MakeInvoiceReqInfo info) throws BOSException, EASBizException {
        MakeInvoiceReqInfo infoFromDb;
        if (info != null && info.getId() != null && (infoFromDb = SIMUtils.getMakeInvoiceReqInfoFromDb(ctx, info.getId().toString())) != null && !MakeInvoiceReqStatusEnum.TEMPSTROE.equals((Object)infoFromDb.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "NOTADDORSAVE", new String[0])});
        }
    }

    private static MakeInvoiceReqInfo getMakeInvoiceReqInfoFromDb(Context ctx, String pk) throws EASBizException, BOSException {
        IMakeInvoiceReq service = ctx == null ? MakeInvoiceReqFactory.getRemoteInstance() : MakeInvoiceReqFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("status"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        MakeInvoiceReqCollection infosFromDb = service.getMakeInvoiceReqCollection(view);
        if (infosFromDb.isEmpty()) {
            return null;
        }
        return infosFromDb.get(0);
    }

    private static boolean valueOfBool(Object val) {
        return val != null && Boolean.valueOf(val.toString()) != false;
    }

    public static Map<String, Object> getEnumAliasMap(String enumSource) {
        List list = EnumUtils.getEnumList((String)enumSource);
        if (list == null) {
            list = DynamicEnum.getEnumList((String)enumSource);
        }
        Object enumValue = null;
        HashMap<String, Object> enumAliasMap = new HashMap<String, Object>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Enum enumData = (Enum)list.get(i);
            if (enumData instanceof StringEnum) {
                enumValue = ((StringEnum)enumData).getValue();
            } else if (enumData instanceof IntEnum) {
                enumValue = ((IntEnum)enumData).getValue();
            } else if (enumData instanceof LongEnum) {
                enumValue = ((LongEnum)enumData).getValue();
            } else if (enumData instanceof FloatEnum) {
                enumValue = Float.valueOf(((FloatEnum)enumData).getValue());
            } else if (enumData instanceof DoubleEnum) {
                enumValue = ((DoubleEnum)enumData).getValue();
            } else if (enumData instanceof DynamicEnum) {
                enumValue = ((DynamicEnum)enumData).getValue();
            }
            enumAliasMap.put(enumData.getAlias(), enumValue);
        }
        return enumAliasMap;
    }
}

