/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util.invoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.fi.ap.OtherBillCollection;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.InvoiceProperty;
import com.kingdee.eas.tm.common.PoolInvoiceInfo;
import com.kingdee.eas.tm.common.httpClient.HttpClientUtil;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoicePoolSqlExecutor;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.eas.tm.common.utils.TMPwyHelperUtils;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IsDeductEnum;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PoolPwyUrlHelp;
import com.kingdee.eas.tm.im.PwyHelper;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.app.service.PoolSync4OtherBillService;
import com.kingdee.eas.tm.im.basedata.IncomeTypeInfo;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.PoolSyncUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class IncomeInvoiceServerService {
    public static TMTraceLogger logger = TMLoggerFactory.getTraceLogger((String)"IncomeInvoiceServerService");
    private static final String MSG = "msg";
    private static final String AUDIT = "audit";
    private static final String UNAUDIT = "unaudit";
    @Deprecated
    public static Map<String, String> invoiceTypeTable = new HashMap<String, String>();

    public Map getAmountTaxSum(Map params) throws Exception {
        HashMap<String, BigDecimal> ret = new HashMap<String, BigDecimal>();
        Context ctx = (Context)params.get("ctx");
        BigDecimal totalAmountTax = BigDecimal.ZERO;
        BigDecimal amountTax = BigDecimal.ZERO;
        Set invoiceIds = IncomeInvoiceFacadeFactory.getLocalInstance(ctx).getInvoiceIds(params);
        if (invoiceIds.size() == 0) {
            return ret;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)invoiceIds, CompareType.INCLUDE));
        view.setFilter(filter);
        IncomeInvoiceInfo info = null;
        IncomeInvoiceCollection invoiceBills = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
        int size = invoiceBills.size();
        for (int i = 0; i < size; ++i) {
            info = invoiceBills.get(i);
            amountTax = BigDecimal.ZERO;
            if (info.getAmountTax() != null) {
                amountTax = info.getAmountTax();
            }
            totalAmountTax = totalAmountTax.add(amountTax);
        }
        if (invoiceBills.size() > 0) {
            ret.put("totalAmountTax", totalAmountTax);
        }
        return ret;
    }

    public Map updateInvoiceInfoAndBotp(Map params) throws Exception {
        Context ctx = (Context)params.get("ctx");
        if (ctx == null) {
            return IncomeInvoiceFacadeFactory.getRemoteInstance().updateInvoiceInfoAndBotp(params);
        }
        return IncomeInvoiceFacadeFactory.getLocalInstance(ctx).updateInvoiceInfoAndBotp(params);
    }

    protected Map baseInvoiceCallWithRes(Map params) throws Exception {
        Context ctx = (Context)params.get("ctx");
        Map paramMap = (Map)params.get("paramMap");
        String invoiceUrl = (String)params.get("invoiceUrl");
        HashMap<String, String> result = new HashMap<String, String>();
        logger.error((Object)"enter method baseInvoiceCall.");
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String companyId = (String)paramMap.get("companyId");
        PwySettingInfo pwyInfo = this.getPwySettint(ctx, companyId);
        PwyHelper helper = new PwyHelper();
        String token = "?access_token=" + helper.getAccessToken(ctx, pwyInfo.getClientId(), pwyInfo.getClientSecret());
        invoiceUrl = invoiceUrl + token;
        if (pwyInfo == null) {
            logger.error((Object)"baseInvoiceCall pwyInfo is null.");
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.PwySettingResource", (String)"CHECK_PWYSETTING", (Locale)ctx.getLocale())});
        }
        String clientID = pwyInfo.getClientId();
        String secret = pwyInfo.getClientSecret();
        long timestamp = System.currentTimeMillis();
        String sign = this.getSign(clientID, secret, timestamp);
        paramMap.put("client_id", clientID);
        paramMap.put("timestamp", timestamp + "");
        paramMap.put("sign", sign);
        String tokenParam = Kson.getGson().toJson((Object)paramMap);
        String encryptData = this.encryptData(ctx, tokenParam, pwyInfo.getSecretKey());
        String ret = HttpClientUtil.doPost((String)invoiceUrl, (String)encryptData);
        if (ret != null) {
            JSONObject json = new JSONObject(ret);
            logger.error((Object)("baseInvoiceCall json=" + json));
            if (!"0000".equals(json.getString("errcode"))) {
                logger.error((Object)("baseInvoiceCall error,paramMap=" + paramMap));
                throw new IMException(IMException.ERRORMSG, new Object[]{json.getString("description")});
            }
            result.put("result", ret);
            return result;
        }
        logger.error((Object)"exit method baseInvoiceCall.");
        return result;
    }

    private String getSign(String clientID, String secret, long timestamp) {
        String str = clientID + secret + timestamp;
        return IncomeInvoiceServerService.StringToMD5(str);
    }

    protected String encryptData(Context ctx, String data, String secretKey) throws EASBizException, BOSException {
        String content = BizInterfaceFactory.getIMInvoiceFacade(ctx).encryptAES(data, secretKey);
        return content;
    }

    private static String StringToMD5(String input) {
        String md5str = null;
        if (input == null) {
            return "";
        }
        byte[] bytes = input.getBytes();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buff = md.digest(bytes);
            md5str = IncomeInvoiceServerService.bytesToHex(buff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return md5str;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuffer md5str = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            int digital = bytes[i];
            if (digital < 0) {
                digital += 256;
            }
            if (digital < 16) {
                md5str.append("0");
            }
            md5str.append(Integer.toHexString(digital));
        }
        return md5str.toString();
    }

    public PwySettingInfo getPwySettint(Context ctx, String orgID) throws EASBizException, BOSException {
        return (PwySettingInfo)PwySettingFactory.getLocalInstance(ctx).getPwySetting(orgID, OPTypeEnum.RecInvoice, null, null);
    }

    public PoolInvoiceInfo getInvoiceInfo(Context ctx, String invoiceCode, String invoiceNumber) throws BOSException {
        String invoiceNumberField;
        int i;
        if (StringUtils.isEmpty((String)invoiceCode) && StringUtils.isEmpty((String)invoiceNumber)) {
            return null;
        }
        PoolInvoiceInfo poolInvoiceInfo = null;
        StringBuffer sql = new StringBuffer();
        HashSet<String> tableNameSet = new HashSet<String>();
        String[] fieldNames = new String[]{"invoiceNumber", "invoiceCode", "serialNo"};
        String fieldName = null;
        InvoiceProperty invoiceProperty = null;
        ArrayList<InvoiceProperty> invoiceProperties = new ArrayList<InvoiceProperty>(TMPwyHelperUtils.APSUPPORT_INVOICEPROPERTIES);
        invoiceProperties.add(TMPwyHelperUtils.EXTEND_INVOICE);
        int size = invoiceProperties.size();
        for (i = 0; i < size; ++i) {
            invoiceProperty = (InvoiceProperty)invoiceProperties.get(i);
            if (StringUtils.isEmpty((String)invoiceProperty.getTableName()) || !tableNameSet.add(invoiceProperty.getTableName())) continue;
            if (tableNameSet.size() > 1) {
                sql.append(" UNION ALL ");
            }
            sql.append(" SELECT FID as id");
            int length = fieldNames.length;
            for (int j = 0; j < length; ++j) {
                fieldName = (String)invoiceProperty.getFieldsName().get(fieldNames[j]);
                if (StringUtils.isEmpty((String)fieldName)) {
                    sql.append(",''  as ").append(fieldNames[j]);
                    continue;
                }
                sql.append(",CONVERT(NVARCHAR(40),F").append(fieldName).append(") as ").append(fieldNames[j]);
            }
            sql.append(" from ").append(invoiceProperty.getTableName());
            invoiceNumberField = (String)invoiceProperty.getFieldsName().get("invoiceNumber");
            String invoiceCodeField = (String)invoiceProperty.getFieldsName().get("invoiceCode");
            sql.append(" WHERE F").append(invoiceNumberField).append(" = '").append(invoiceNumber).append("' ");
            if (StringUtils.isEmpty((String)invoiceCodeField)) continue;
            sql.append(" and F").append(invoiceCodeField).append(" = '").append(invoiceCode).append("' ");
        }
        if (sql.length() > 0) {
            size = TMPwyHelperUtils.CODEUNCERTAIN_INVOICEPROPERTIES.size();
            for (i = 0; i < size; ++i) {
                invoiceProperty = (InvoiceProperty)TMPwyHelperUtils.CODEUNCERTAIN_INVOICEPROPERTIES.get(i);
                sql.append(" UNION ALL ");
                sql.append(" SELECT FID as id ");
                int length = fieldNames.length;
                for (int j = 0; j < length; ++j) {
                    fieldName = (String)invoiceProperty.getFieldsName().get(fieldNames[j]);
                    if (StringUtils.isEmpty((String)fieldName)) {
                        sql.append(",''  as ").append(fieldNames[j]);
                        continue;
                    }
                    sql.append(",CONVERT(NVARCHAR(40),F").append(fieldName).append(") as ").append(fieldNames[j]);
                }
                sql.append(" from ").append(invoiceProperty.getTableName());
                invoiceNumberField = (String)invoiceProperty.getFieldsName().get("invoiceNumber");
                sql.append(" WHERE F").append(invoiceNumberField).append(" = '").append(invoiceNumber).append("' ");
            }
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String id = null;
            if (rs.next()) {
                id = rs.getString("id");
                poolInvoiceInfo = new PoolInvoiceInfo();
                poolInvoiceInfo.setId(id);
                poolInvoiceInfo.setBosType(BOSUuid.read((String)id).getType().toString());
                poolInvoiceInfo.setInvoiceCode(invoiceCode);
                poolInvoiceInfo.setInvoiceNumber(invoiceNumber);
                poolInvoiceInfo.setSerialNo(rs.getString("serialNo"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return poolInvoiceInfo;
    }

    public Map delInvoiceInfoAndBotp(Map params) throws Exception {
        HashMap ret = new HashMap();
        this.delInvoiceFields(params, ret);
        this.getPoolSyncService().deleteInvoiceStatus(params);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delInvoiceFields(Map params, Map ret) throws BOSException, SQLException {
        Context ctx = (Context)params.get("ctx");
        String billId = (String)params.get("billId");
        HashSet<String> invoiceIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        HashSet<String> tableNameSet = new HashSet<String>();
        InvoiceProperty invoiceProperty = null;
        ArrayList<InvoiceProperty> invoiceProperties = new ArrayList<InvoiceProperty>(TMPwyHelperUtils.APSUPPORT_INVOICEPROPERTIES);
        invoiceProperties.add(TMPwyHelperUtils.EXTEND_INVOICE);
        int size = invoiceProperties.size();
        for (int i = 0; i < size; ++i) {
            invoiceProperty = (InvoiceProperty)invoiceProperties.get(i);
            if (StringUtils.isEmpty((String)invoiceProperty.getTableName()) || !tableNameSet.add(invoiceProperty.getTableName())) continue;
            if (tableNameSet.size() > 1) {
                sql.append(" UNION ALL ");
            }
            sql.append(" SELECT FID FROM ").append(invoiceProperty.getTableName()).append(" WHERE FBIZBILLID = '").append(billId).append("' ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            invoiceIds.add(rs.getString("FID"));
        }
        HashMap invoiceIdMap = new HashMap();
        for (String id : invoiceIds) {
            String bosType = BOSUuid.read((String)id).getType().toString();
            if (invoiceIdMap.containsKey(bosType)) {
                ((ArrayList)invoiceIdMap.get(bosType)).add(id);
                continue;
            }
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(id);
            invoiceIdMap.put(bosType, ids);
        }
        try (InvoicePoolSqlExecutor sqlExecutor = null;){
            sqlExecutor = new InvoicePoolSqlExecutor(ctx);
            sqlExecutor.deleteInvoiceAndBOTP(billId, invoiceIdMap);
        }
    }

    public Map updateInvoiceInfo(Map params) throws Exception {
        HashMap ret = new HashMap();
        this.updateInvoiceFields(params, ret, AUDIT);
        this.getPoolSyncService().updateInvoiceStatus(params, "60");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInvoiceFields(Map params, Map ret, String method) throws Exception {
        Context ctx = (Context)params.get("ctx");
        String rowTypeID = (String)params.get("rowType");
        String billId = (String)params.get("billId");
        Map bosTypeIDMap = IncomeInvoiceFacadeFactory.getLocalInstance(ctx).getBosTypeIdsMap(params);
        if (bosTypeIDMap.size() == 0) {
            return;
        }
        HashMap<String, String> sqlParams = new HashMap<String, String>();
        sqlParams.put("incomeTypeID", this.getIncomeTypeID(ctx, rowTypeID));
        try (InvoicePoolSqlExecutor sqlExecutor = null;){
            sqlExecutor = new InvoicePoolSqlExecutor(ctx);
            if (AUDIT.equals(method)) {
                sqlExecutor.updateInvoiceFields(billId, bosTypeIDMap, sqlParams);
            } else {
                sqlExecutor.updateInvoiceFields(billId, bosTypeIDMap);
            }
        }
    }

    public void updateIncomeInvoiceInfo(Map params, Map ret) throws Exception {
        Context ctx = (Context)params.get("ctx");
        String rowTypeID = (String)params.get("rowType");
        Set invoiceIds = IncomeInvoiceFacadeFactory.getLocalInstance(ctx).getInvoiceIds(params);
        if (invoiceIds.size() == 0) {
            return;
        }
        String incomeTypeID = this.getIncomeTypeID(ctx, rowTypeID);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)invoiceIds, CompareType.INCLUDE));
        view.setFilter(filter);
        IncomeInvoiceInfo info = null;
        IncomeInvoiceCollection invoiceBills = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
        int size = invoiceBills.size();
        for (int i = 0; i < size; ++i) {
            info = invoiceBills.get(i);
            if (PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)info.getInvoiceType()) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)info.getInvoiceType())) {
                info.setIsDeduct(IsDeductEnum.DEDUCTIBLE);
                info.setDeductTaxAmt(info.getTax());
            } else {
                info.setIsDeduct(IsDeductEnum.NONDEDUCTIBLE);
            }
            if (incomeTypeID != null) {
                IncomeTypeInfo incomeType = new IncomeTypeInfo();
                incomeType.setId(BOSUuid.read((String)incomeTypeID));
                info.setIncomeType(incomeType);
            }
            IncomeInvoiceFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
    }

    public Map deleteInvoiceInfo(Map params) throws Exception {
        HashMap ret = new HashMap();
        this.updateInvoiceFields(params, ret, UNAUDIT);
        this.getPoolSyncService().updateInvoiceStatus(params, "1");
        return ret;
    }

    public void deleteIncomeInvoiceInfo(Map params, Map ret) throws Exception {
        Context ctx = (Context)params.get("ctx");
        Set invoiceIds = IncomeInvoiceFacadeFactory.getLocalInstance(ctx).getInvoiceIds(params);
        if (invoiceIds.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)invoiceIds, CompareType.INCLUDE));
        view.setFilter(filter);
        IncomeInvoiceInfo info = null;
        IncomeInvoiceCollection invoiceBills = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
        int size = invoiceBills.size();
        for (int i = 0; i < size; ++i) {
            info = invoiceBills.get(i);
            info.put("isDeduct", null);
            info.setDeductTaxAmt(null);
            info.setIncomeType(null);
            IncomeInvoiceFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
    }

    public void deleteVehicleInvoiceInfo(Map params, Map ret) throws Exception {
        Context ctx = (Context)params.get("ctx");
        String billId = (String)params.get("billId");
        BOSUuid uuid = BOSUuid.read((String)billId);
        String bostype = uuid.getType().toString();
        HashSet<String> invoiceIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        if ("48DA3A71".equals(bostype) || "D001019A".equals(bostype)) {
            sql.append(" SELECT FDestObjectID FROM T_BOT_Relation WHERE FSrcObjectID = '" + billId + "' AND FDestEntityID = '8F9D8961'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    invoiceIds.add(rs.getString("FDestObjectID"));
                }
            }
            catch (SQLException e) {
                throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
            }
            if (invoiceIds.size() > 0) {
                sql.setLength(0);
                sql.append(" UPDATE T_TM_VehicleInvoice SET FIDeduct = null, FDeductTaxAmt = null , FIncomeTypeID = null ");
                sql.append(" WHERE FID IN " + IMUtils.getInStringFromSet(invoiceIds));
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
    }

    public void updateVoucherInfo(Map params) throws Exception {
        HashSet<String> invoicePollTableSet = new HashSet<String>();
        InvoiceProperty invoiceProperty = null;
        int size = TMPwyHelperUtils.APSUPPORT_INVOICEPROPERTIES.size();
        for (int i = 0; i < size; ++i) {
            invoiceProperty = (InvoiceProperty)TMPwyHelperUtils.APSUPPORT_INVOICEPROPERTIES.get(i);
            if (StringUtils.isEmpty((String)invoiceProperty.getTableName())) continue;
            invoicePollTableSet.add(invoiceProperty.getTableName());
        }
        invoicePollTableSet.add("T_TM_ExtendInvoice");
        invoicePollTableSet.remove(TMPwyHelperUtils.COMMON_PAPER.getTableName());
        ArrayList invoicePoolTable = new ArrayList(invoicePollTableSet);
        List data = (List)params.get("data");
        Context ctx = (Context)params.get("ctx");
        ArrayList<String> updateSql = new ArrayList<String>();
        HashSet<String> bizIdSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        int size2 = data.size();
        for (int i = 0; i < size2; ++i) {
            int index;
            int j;
            Map param = (Map)data.get(i);
            String operation = (String)param.get("operation");
            String voucherId = (String)param.get("voucherId");
            String billId = (String)param.get("billId");
            bizIdSet.add(billId);
            if ("update".equals(operation)) {
                sql.append(" Update T_IM_IncomeInvoice inv set (FReBusiness,FBizVoucherID,FBizVoucherNumber,FBizVoucherPeriodID,FBizVoucherTypeID) = ").append(" (select 1,vou.FID,vou.FNumber,vou.FPeriodID,vou.FVoucherTypeID From T_GL_VOUCHER vou where vou.FID = '" + voucherId + "' )").append(" Where inv.FBizBillID = '" + billId + "' ");
                updateSql.add(sql.toString());
                j = invoicePoolTable.size();
                for (index = 0; index < j; ++index) {
                    if (StringUtils.isEmpty((String)((String)invoicePoolTable.get(index)))) continue;
                    sql.setLength(0);
                    sql.append(" Update " + (String)invoicePoolTable.get(index) + " inv set (FIsBusiness,FVoucherID,FVoucherNumber,FVoucherPeriodID,FVoucherTypeID) = ").append(" (select 1,vou.FID,vou.FNumber,vou.FPeriodID,vou.FVoucherTypeID From T_GL_VOUCHER vou where vou.FID = '" + voucherId + "' )").append(" Where inv.FBizBillID = '" + billId + "' ");
                    updateSql.add(sql.toString());
                }
                continue;
            }
            if (!"delete".equals(operation)) continue;
            sql.append(" Update T_IM_IncomeInvoice set FReBusiness = 0 ,FBizVoucherID = null,FBizVoucherNumber = null,FBizVoucherPeriodID = null,FBizVoucherTypeID = null").append(" Where FBizBillID = '" + billId + "' ");
            updateSql.add(sql.toString());
            j = invoicePoolTable.size();
            for (index = 0; index < j; ++index) {
                if (StringUtils.isEmpty((String)((String)invoicePoolTable.get(index)))) continue;
                sql.setLength(0);
                sql.append(" Update " + (String)invoicePoolTable.get(index) + " set FIsBusiness = 0 ,FVoucherID = null,FVoucherNumber = null,FVoucherPeriodID = null,FVoucherTypeID = null").append(" Where FBizBillID = '" + billId + "' ");
                updateSql.add(sql.toString());
            }
        }
        if (updateSql.size() > 0) {
            boolean isUpdateBizVoucher2AWSFPY = false;
            try {
                Map imTempParams = IMFacadeFactory.getLocalInstance(ctx).getIMTempParamByKey(new String[]{"isUpdateBizVoucher2AWSFPY"});
                if (imTempParams != null && imTempParams.get("isUpdateBizVoucher2AWSFPY") != null && "1".equals((String)imTempParams.get("isUpdateBizVoucher2AWSFPY"))) {
                    isUpdateBizVoucher2AWSFPY = true;
                }
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
            if (isUpdateBizVoucher2AWSFPY) {
                params.put("oldInvoiceList", PoolSyncUtil.getInvoiceList(ctx, bizIdSet));
            }
            DBUtil.executeBatch((Context)ctx, (String[])updateSql.toArray(new String[updateSql.size()]));
            if (isUpdateBizVoucher2AWSFPY) {
                this.getPoolSyncService().updateVoucherInfo(params);
            }
        }
    }

    public String getIncomeTypeID(Context ctx, String rowTypeID) throws BOSException {
        String incomeTypeID = "";
        if (StringUtils.isEmpty((String)rowTypeID)) {
            return incomeTypeID;
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" select parent.fid as id from T_TM_IncomeType parent ").append("\n");
            sql.append(" left join T_TM_IncomeTypeEntry entry on parent.FID = entry.FParentID ").append("\n");
            sql.append(" where parent.FStatus = '").append("0").append("' ");
            sql.append(" and entry.FTypeId = '").append(rowTypeID).append("' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            if (rs.next()) {
                incomeTypeID = rs.getString("id");
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return incomeTypeID;
    }

    public static void buildBOTPRelation(Context ctx, String srcId, String srcBosType, String desBosType, String desId, String operation) throws BOSException {
        BOTRelationInfo info = new BOTRelationInfo();
        info.setSrcObjectID(srcId);
        info.setSrcEntityID(srcBosType);
        info.setDestEntityID(desBosType);
        info.setDestObjectID(desId);
        info.setOperatorID(operation);
        info.setDate(new Date());
        info.setIsEffected(true);
        info.setType(0);
        BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
    }

    public HashMap viewInvoicePdf(Map params) throws Exception {
        Context ctx = (Context)params.get("ctx");
        Set invoiceIds = IncomeInvoiceFacadeFactory.getLocalInstance(ctx).getInvoiceIds(params);
        HashMap<String, Object> result = new HashMap<String, Object>();
        String msg = null;
        ArrayList<String> urlList = new ArrayList<String>();
        if (invoiceIds.size() == 0) {
            msg = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"DESCBILL_NOTEXIST", (Locale)ctx.getLocale());
        } else {
            boolean existUrl = false;
            Map PdfUrlMap = IncomeInvoiceFacadeFactory.getLocalInstance(ctx).getPdfUrlMap(invoiceIds);
            for (String id : invoiceIds) {
                String viewInvoiceURL = (String)PdfUrlMap.get(id);
                if (StringUtils.isEmpty((String)viewInvoiceURL)) continue;
                existUrl = true;
                urlList.add(viewInvoiceURL);
            }
            if (!existUrl) {
                msg = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"InvoiceURL_NotExist", (Locale)ctx.getLocale());
            }
        }
        result.put(MSG, msg);
        result.put("urlList", urlList);
        return result;
    }

    public HashMap viewInvoiceImage(Map params) throws Exception {
        HashMap result = new HashMap();
        Context ctx = (Context)params.get("ctx");
        String companyId = (String)params.get("companyId");
        String billNumber = (String)params.get("billNumber");
        Boolean isIntegratedByPWY = params.get("isIntegratedByPWY") == null ? false : (Boolean)params.get("isIntegratedByPWY");
        if (result.get(MSG) == null) {
            if (isIntegratedByPWY.booleanValue()) {
                this.getUserKey(ctx, companyId, billNumber, result);
                result.put("invoiceImageUrl", PoolPwyUrlHelp.getWebViewImageUrl(ctx) + result.get("userKey"));
            } else {
                result = this.viewInvoicePdf(params);
            }
        }
        return result;
    }

    private void getUserKey(Context ctx, String companyId, String billNumber, Map resultMap) throws BOSException, EASBizException, UnsupportedEncodingException {
        PwySettingInfo pwySetting;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (!StringUtils.isEmpty((String)companyId)) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        }
        if ((pwySetting = (PwySettingInfo)PwySettingFactory.getLocalInstance(ctx).getPwySetting(company.getId().toString(), OPTypeEnum.RecInvoice, null, null)) == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "pwySettingIsNull", IMUtils.getLocale())});
        }
        OtherBillCollection col = OtherBillFactory.getLocalInstance((Context)ctx).getOtherBillCollection("where number='" + billNumber + "'");
        if (col == null || col.size() == 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "billNumberIsNull", IMUtils.getLocale())});
        }
        String clientID = pwySetting.getClientId();
        String secret = pwySetting.getClientSecret();
        long timestamp = System.currentTimeMillis();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String tin = company.getTaxNumber();
        String ghf_mc = company.getRegisteredCode();
        String eid = URLEncoder.encode(userID, "UTF-8");
        String sign = IMUtils.getSign(clientID, secret, timestamp);
        double random = new SecureRandom().nextDouble();
        StringBuffer url = new StringBuffer();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("timestamp", timestamp);
        params.put("client_id", clientID);
        params.put("tin", tin);
        params.put("ghf_mc", ghf_mc);
        params.put("eid", eid);
        params.put("sign", sign);
        params.put("billNumber", billNumber);
        params.put("bxd_key", col.get(0).getId().toString());
        params.put("random", random);
        params.put("billType", "");
        String param = Kson.getGson().toJson(params);
        logger.error((Object)("getUserKey params=" + param));
        String userKeyUrl = PoolPwyUrlHelp.getUserKeyUrl(ctx);
        try {
            String userKey = HttpClientUtil.doPost((String)userKeyUrl, (String)param);
            if (userKey != null) {
                JSONObject json = new JSONObject(userKey);
                if ("0000".equals(json.getString("errcode"))) {
                    resultMap.put("userKey", json.getJSONObject("data").getString("userKey"));
                } else {
                    resultMap.put(MSG, json.getString("description"));
                }
            } else {
                resultMap.put(MSG, "\u8bf7\u6c42userKey\u5931\u8d25\uff01 url : " + url + " tokenParam : " + param);
            }
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42userKey\u5931\u8d25\uff01 url : " + url + " e: " + e.getMessage(), (Throwable)e);
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
    }

    public Map getInvoiceMap(Map params) throws BOSException {
        HashMap ret = new HashMap();
        if (params == null || params.isEmpty() || params.get("invoices") == null) {
            return ret;
        }
        List invoiceList = (List)params.get("invoices");
        Context ctx = (Context)params.get("ctx");
        String bizBillId = (String)params.get("bizBillId");
        int size = invoiceList.size();
        for (int i = 0; i < size; ++i) {
            IncomeInvoiceInfo info;
            String[] invoice;
            String invoiceStr = (String)invoiceList.get(i);
            if (invoiceStr == null || (invoice = invoiceStr.toString().split("_")).length == 0 || (info = this.getIncomeInvoiceInfo(ctx, invoice[0], invoice[1])) == null) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("bizBillID", info.getBizBillID());
            map.put("bizBillNumber", info.getBizBillNumber());
            map.put("bizBillEntryID", info.getBizBillEntryID());
            if (info.getBizBillID() == null || info.getBizBillID().toString().equals(bizBillId)) continue;
            map.put("bizBillType", info.getBizBillType().getName());
            ret.put(invoiceStr, map);
        }
        return ret;
    }

    private IncomeInvoiceInfo getIncomeInvoiceInfo(Context ctx, String invoiceCode, String invoiceNumber) {
        IncomeInvoiceInfo invoiceInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceNumber, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bizBillType.*"));
        sic.add(new SelectorItemInfo("company.*"));
        view.setSelector(sic);
        IncomeInvoiceCollection coll = null;
        try {
            coll = ctx == null ? IncomeInvoiceFactory.getRemoteInstance().getIncomeInvoiceCollection(view) : IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (coll != null && coll.size() > 0) {
            invoiceInfo = coll.get(0);
        }
        return invoiceInfo;
    }

    public List eleVoucherStructDataArchived(Context ctx, List<Map<String, String>> params) {
        ArrayList<Map> retList = new ArrayList<Map>();
        Map<String, String> map = null;
        Map ret = null;
        for (int i = 0; i < params.size(); ++i) {
            map = params.get(i);
            if ("10".equals(map.get("invoiceType")) || "9".equals(map.get("invoiceType"))) {
                ret = this.getPlaneTrainInformation(ctx, map.get("queryMode"), map.get("invoiceType"), map.get("serialCodeNum"));
                retList.add(ret);
                continue;
            }
            if ("1".equals(map.get("invoiceType")) || "2".equals(map.get("invoiceType")) || "3".equals(map.get("invoiceType")) || "4".equals(map.get("invoiceType")) || "5".equals(map.get("invoiceType"))) {
                String invoiceType = this.getInvoiceTypeByTMInvoiceType(map.get("invoiceType"));
                ret = this.getIncomeInvoiceInformation(ctx, map.get("queryMode"), invoiceType, map.get("serialCodeNum"));
                retList.add(ret);
                continue;
            }
            if (!"15".equals(map.get("invoiceType"))) continue;
            ret = this.getTollInvoiceInformation(ctx, map.get("queryMode"), map.get("invoiceType"), map.get("serialCodeNum"));
            retList.add(ret);
        }
        return retList;
    }

    private Map getTollInvoiceInformation(Context ctx, String queryMode, String invoiceType, String serialCodeNum) {
        HashMap ret = new HashMap();
        HashMap<String, Object> retInfo = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT invoice.FBizBillNumber as bizBillNumber, invoice.FIsPayment as isPayment, invoice.FType as type, ");
        sql.append(" invoice.FIsBusiness as isBusiness, invoice.FTransferTaxAmt as transferTaxAmt, ");
        sql.append(" invoice.FBuyerTaxNo as buyerTaxNo, invoice.FBuyerName as buyerName, ");
        sql.append(" cabs.FConfirmState as comfirmState, cabs.FTaxPeriodID as taxPeriodID, ");
        sql.append(" invoice.FSalerName as salerName, invoice.FSalerTaxNo as salerTaxNo, ");
        sql.append(" invoice.FInvoiceAmount as invoiceAmount, invoice.FTotalTaxAmount as totalTaxAmount, ");
        sql.append(" invoice.FTotalAmount as totalAmount, invoice.FInvoiceDate as invoiceDate ");
        sql.append(" FROM ").append(TMPwyHelperUtils.getTableNameByType((String)invoiceType)).append(" as invoice ");
        sql.append(" INNER JOIN T_TM_CheckAbs as cabs on cabs.FID = invoice.FCheckAbsID ");
        if ("1".equals(queryMode)) {
            sql.append(" WHERE invoice.FSerialNo = '").append(serialCodeNum).append("' ");
        } else if ("0".equals(queryMode)) {
            String invoiceNumber = serialCodeNum.split("_")[0];
            String invoiceCode = serialCodeNum.split("_")[1];
            sql.append(" WHERE invoice.FInvoiceNo = '").append(invoiceNumber).append("' ").append(" and invoice.FInvoiceCode = '").append(invoiceCode).append("' ");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                retInfo.put("ContractNumber", rs.getString("bizBillNumber"));
                retInfo.put("MatchingStateBetweenBusinessDocumentsAndVatEInvoice", rs.getBoolean("isPayment"));
                retInfo.put("isRed", rs.getBoolean("type"));
                retInfo.put("isBusiness", rs.getBoolean("isBusiness"));
                BigDecimal transferTaxAmt = rs.getBigDecimal("transferTaxAmt") == null ? BigDecimal.ZERO : rs.getBigDecimal("transferTaxAmt");
                retInfo.put("isTransfer", BigDecimal.ZERO.compareTo(transferTaxAmt) <= 0);
                retInfo.put("transferTaxAmt", rs.getBigDecimal("transferTaxAmt"));
                retInfo.put("buyerTaxNo", rs.getString("buyerTaxNo"));
                retInfo.put("buyerName", rs.getString("buyerName"));
                retInfo.put("hasConfirmed", "1".equals(rs.getShort("comfirmState")));
                retInfo.put("usageConfirmation", "1".equals(rs.getShort("comfirmState")));
                retInfo.put("usageConfirmationPeriod", rs.getString("taxPeriodID"));
                retInfo.put("NameOfSeller", rs.getString("salerName"));
                retInfo.put("TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller", rs.getString("salerTaxNo"));
                retInfo.put("TotalAmountExcludingTax", rs.getString("invoiceAmount"));
                retInfo.put("TotalTaxAmount", rs.getString("totalTaxAmount"));
                retInfo.put("TaxIncludedAmountInFigures", rs.getString("totalAmount"));
                retInfo.put("DateOfIssue", rs.getString("invoiceDate"));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        ret.put(serialCodeNum, retInfo);
        return ret;
    }

    private Map getIncomeInvoiceInformation(Context ctx, String queryMode, String invoiceType, String serialCodeNum) {
        HashMap ret = new HashMap();
        HashMap<String, Object> retInfo = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT invoice.FBizBillNumber as bizBillNumber, invoice.FIsPayment as isPayment, invoice.FIsCreditNote as isCreditNote,  ");
        sql.append(" invoice.FReBusiness as reBusiness, invoice.FTransferTaxAmt as transferTaxAmt, ");
        sql.append(" invoice.FBuyerTaxNo as buyerTaxNo, invoice.FBuyerName as buyerName, ");
        sql.append(" cabs.FConfirmState as comfirmState, cabs.FTaxPeriodID as taxPeriodID, ");
        sql.append(" invoice.FBillingCompany as billingCompany, invoice.FTaxNumber as taxNumber, ");
        sql.append(" invoice.FAmount as amount, invoice.FTax as tax, ");
        sql.append(" invoice.FAmountTax as amountTax, invoice.FBizDate as bizDate ");
        sql.append(" FROM ").append(TMPwyHelperUtils.getTableNameByType((String)invoiceType)).append(" as invoice ");
        sql.append(" INNER JOIN T_TM_CheckAbs as cabs on cabs.FID = invoice.FCheckAbsID ");
        sql.append(" WHERE invoice.FInvoiceType ='").append(invoiceType).append("'");
        if ("1".equals(queryMode)) {
            sql.append(" AND invoice.FSerialNo = '").append(serialCodeNum).append("' ");
        } else if ("0".equals(queryMode)) {
            String invoiceNumber = serialCodeNum.split("_")[0];
            String invoiceCode = serialCodeNum.split("_")[1];
            sql.append(" AND invoice.FInvoiceNumber = '").append(invoiceNumber).append("' ").append(" and invoice.FInvoiceCode = '").append(invoiceCode).append("' ");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                retInfo.put("ContractNumber", rs.getString("bizBillNumber"));
                retInfo.put("MatchingStateBetweenBusinessDocumentsAndVatEInvoice", rs.getBoolean("isPayment"));
                retInfo.put("isRed", rs.getBoolean("isCreditNote"));
                retInfo.put("isBusiness", rs.getBoolean("reBusiness"));
                BigDecimal transferTaxAmt = rs.getBigDecimal("transferTaxAmt") == null ? BigDecimal.ZERO : rs.getBigDecimal("transferTaxAmt");
                retInfo.put("isTransfer", BigDecimal.ZERO.compareTo(transferTaxAmt) <= 0);
                retInfo.put("transferTaxAmt", transferTaxAmt);
                retInfo.put("buyerTaxNo", rs.getString("buyerTaxNo"));
                retInfo.put("buyerName", rs.getString("buyerName"));
                retInfo.put("hasConfirmed", "1".equals(rs.getShort("comfirmState")));
                retInfo.put("usageConfirmation", "1".equals(rs.getShort("comfirmState")));
                retInfo.put("usageConfirmationPeriod", rs.getString("taxPeriodID"));
                retInfo.put("NameOfSeller", rs.getString("billingCompany"));
                retInfo.put("TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller", rs.getString("taxNumber"));
                retInfo.put("TotalAmountExcludingTax", rs.getString("amount"));
                retInfo.put("TotalTaxAmount", rs.getString("tax"));
                retInfo.put("TaxIncludedAmountInFigures", rs.getString("amountTax"));
                retInfo.put("DateOfIssue", rs.getString("bizDate"));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        ret.put(serialCodeNum, retInfo);
        return ret;
    }

    private String getInvoiceTypeByTMInvoiceType(String tmInvoiceType) {
        if ("1".equals(tmInvoiceType)) {
            return "2";
        }
        if ("2".equals(tmInvoiceType)) {
            return "3";
        }
        if ("3".equals(tmInvoiceType)) {
            return "0";
        }
        if ("4".equals(tmInvoiceType)) {
            return "1";
        }
        if ("5".equals(tmInvoiceType)) {
            return "0";
        }
        return null;
    }

    private Map getPlaneTrainInformation(Context ctx, String queryMode, String invoiceType, String serialCodeNum) {
        HashMap ret = new HashMap();
        HashMap<String, Object> retInfo = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT invoice.FBizBillNumber as bizBillNumber, invoice.FIsPayment as isPayment, invoice.FTotalAmount as totalAmount,");
        sql.append(" invoice.FisBusiness as isBusiness, invoice.FVoucherPeriodID as voucherPeriodID");
        sql.append(" FROM ").append(TMPwyHelperUtils.getTableNameByType((String)invoiceType)).append(" as invoice ");
        if ("1".equals(queryMode)) {
            sql.append(" WHERE invoice.FSerialNo = '").append(serialCodeNum).append("' ");
        } else if ("0".equals(queryMode)) {
            String invoiceNumber = serialCodeNum.split("_")[0];
            String invoiceCode = serialCodeNum.split("_")[1];
            sql.append(" WHERE invoice.FInvoiceNo = '").append(invoiceNumber).append("' ").append(" and invoice.FInvoiceCode = '").append(invoiceCode).append("' ");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                retInfo.put("ContractNumber", rs.getString("bizBillNumber"));
                retInfo.put("MatchingStateBetweenBusinessDocumentsAndVatEInvoice", rs.getBoolean("isPayment"));
                BigDecimal totalAmount = rs.getBigDecimal("totalAmount");
                retInfo.put("isRed", totalAmount != null && BigDecimal.ZERO.compareTo(totalAmount) > 0);
                retInfo.put("isBusiness", rs.getBoolean("isBusiness"));
                retInfo.put("hasDeduct", !StringUtils.isEmpty((String)rs.getString("voucherPeriodID")));
                retInfo.put("voucherPeriodID", rs.getString("voucherPeriodID"));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        ret.put(serialCodeNum, retInfo);
        return ret;
    }

    public Map getInvoiceBosType(Map param) throws EASBizException, BOSException {
        HashMap<String, Set> invoiceBosTypeMap = new HashMap<String, Set>();
        Set invoiceBosTypeSet = TMPwyHelperUtils.getAPInvoiceBosTypeSet();
        invoiceBosTypeMap.put("invoiceBosTypeSet", invoiceBosTypeSet);
        return invoiceBosTypeMap;
    }

    public Map getInvoiceInfoList(Map params) throws EASBizException, BOSException {
        Map ret = null;
        if (params.containsKey("ctx") && params.get("ctx") != null) {
            Context ctx = (Context)params.get("ctx");
            ret = IncomeInvoiceFacadeFactory.getLocalInstance(ctx).getInvoiceList(params);
        } else {
            ret = IncomeInvoiceFacadeFactory.getRemoteInstance().getInvoiceList(params);
        }
        return ret;
    }

    public PoolSync4OtherBillService getPoolSyncService() {
        return new PoolSync4OtherBillService();
    }

    static {
        invoiceTypeTable.put("0", "T_IM_IncomeInvoice");
        invoiceTypeTable.put("1", "T_IM_IncomeInvoice");
        invoiceTypeTable.put("2", "T_IM_IncomeInvoice");
        invoiceTypeTable.put("3", "T_IM_IncomeInvoice");
        invoiceTypeTable.put("4", "T_IM_IncomeInvoice");
        invoiceTypeTable.put("5", "T_IM_IncomeInvoice");
        invoiceTypeTable.put("7", "T_TM_MachineInvoice");
        invoiceTypeTable.put("8", "T_TM_TaxiInvoice");
        invoiceTypeTable.put("9", "T_TM_TrainInvoice");
        invoiceTypeTable.put("10", "T_TM_PlaneInvoice");
        invoiceTypeTable.put("11", "T_TM_OtherInvoice");
        invoiceTypeTable.put("12", "T_TM_VehicleInvoice");
        invoiceTypeTable.put("13", "T_TM_SecondHandCarInvoice");
        invoiceTypeTable.put("14", "T_TM_QuotaInvoice");
        invoiceTypeTable.put("15", "T_TM_TollInvoice");
        invoiceTypeTable.put("17", "T_TM_MachineInvoice");
        invoiceTypeTable.put("19", "T_TM_PurchaseInvoice");
        invoiceTypeTable.put("20", "T_TM_ShipInvoice");
        invoiceTypeTable.put("16", "T_TM_ShipInvoice");
        invoiceTypeTable.put("23", "T_TM_MachineInvoice");
        invoiceTypeTable.put("25", "T_TM_FinancialInvoice");
        invoiceTypeTable.put("26", "T_TM_FullElectricInvoice");
        invoiceTypeTable.put("27", "T_TM_FullElectricInvoice");
    }
}

