/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util.invoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.TMException;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolDownloadInvoiceHelper;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.msg.result.PoolDownloadResult;
import com.kingdee.eas.tm.im.common.comm.service.util.IncomeInvoicePwyHelper;
import com.kingdee.eas.tm.im.common.logger.IMLoggerFactory;
import com.kingdee.eas.tm.im.common.logger.IMTraceLogger;
import com.kingdee.eas.tm.im.param.TaxNoSumResult;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.rim.RIMUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PoolDownloadInvoiceServerService {
    public static IMTraceLogger logger = IMLoggerFactory.getTraceLogger("PoolDownloadInvoiceServerService");
    public static final String OPER_DOWNLOADINVOICE = "0";
    public static final String OPER_DOWNLOADINVOICEDETAIL = "1";
    public static final String OPER_RIM_DOWNLOADINVOICE = "2";
    public static final String SOURCE_DISK = "DISK";
    public static final String SOURCE_WEB = "WEB";
    public static final String SOURCE_RIM_WEB = "RIM_WEB";
    public String[] diskSupportInvoiceTypes = new String[]{"2", "4", "15", "12", "27"};

    public List buildDownloadInvoice(Context ctx, Map param) throws EASBizException, BOSException {
        String type = (String)param.get("type");
        Map formData = (Map)param.get("formData");
        String srcSystem = (String)param.get("srcSystem");
        ArrayList resultList = new ArrayList();
        if (OPER_DOWNLOADINVOICE.equals(type)) {
            resultList.addAll(this.buildDownloadInvoiceBySource(ctx, formData, SOURCE_WEB, srcSystem));
            resultList.addAll(this.buildDownloadInvoiceBySource(ctx, formData, SOURCE_DISK, srcSystem));
        } else if (OPER_DOWNLOADINVOICEDETAIL.equals(type)) {
            resultList.addAll(this.buildDownloadInvoiceBySource(ctx, formData, SOURCE_WEB, srcSystem));
        } else if (OPER_RIM_DOWNLOADINVOICE.equals(type)) {
            resultList.addAll(this.buildDownloadInvoiceBySource(ctx, formData, SOURCE_RIM_WEB, srcSystem));
        }
        return resultList;
    }

    protected List buildDownloadInvoiceBySource(Context ctx, Map formData, String sourceType, String srcSystem) throws BOSException, EASBizException {
        String invoiceTypes = (String)formData.get("invoiceType");
        List companyIDs = (List)formData.get("companyIDs");
        String invoiceStatus = (String)formData.get("invoiceStatus");
        if (SOURCE_DISK.equals(sourceType) && !this.isSupportDisk(invoiceTypes)) {
            return new ArrayList();
        }
        PwyServiceType msgType = this.getPwyServiceType(formData, sourceType);
        List<HashMap> bodyList = this.buildDownloadInvoiceBodyList(ctx, formData, msgType, sourceType);
        HashSet companyIdSet = new HashSet(companyIDs);
        Map resultMap = PwySettingFactory.getLocalInstance(ctx).getTaxNoSumResult(companyIdSet);
        ArrayList<PwyActionParam> paramList = new ArrayList<PwyActionParam>();
        PwyActionParam actionParam = null;
        HashMap param = null;
        HashMap<String, String> newPwyData = null;
        for (String taxNo : resultMap.keySet()) {
            for (HashMap pwyData : bodyList) {
                newPwyData = new HashMap<String, String>(pwyData);
                param = new HashMap();
                param.put("sumRet", resultMap.get(taxNo));
                param.put("pwyData", newPwyData);
                param.put("status", invoiceStatus);
                param.put("invoiceTypes", invoiceTypes);
                param.put("isPoolDownload", true);
                CompanyOrgUnitInfo company = ((TaxNoSumResult)resultMap.get(taxNo)).getDefaultCompany();
                if (!StringUtils.isEmpty((String)company.getTaxNumber())) {
                    newPwyData.put("buyerTaxNo", company.getTaxNumber().trim());
                }
                param.put("sourceType", sourceType);
                actionParam = new PwyActionParam(msgType, srcSystem == null ? TransSrcSystemEnum.easweb : TransSrcSystemEnum.getEnum(srcSystem), ((TaxNoSumResult)resultMap.get(taxNo)).getDefaultCompany().getId().toString(), param);
                paramList.add(actionParam);
            }
        }
        return PwyServiceFacadeFactory.getLocalInstance(ctx).buildPwyParam(paramList);
    }

    protected boolean isSupportDisk(String invoiceTypes) {
        String[] types = invoiceTypes.split(",");
        List<String> typeList = Arrays.asList(types);
        int size = this.diskSupportInvoiceTypes.length;
        for (int i = 0; i < size; ++i) {
            if (!typeList.contains(this.diskSupportInvoiceTypes[i])) continue;
            return true;
        }
        return false;
    }

    protected PwyServiceType getPwyServiceType(Map formData, String sourceType) {
        String invoiceNumber = (String)formData.get("invoiceNumber");
        PwyServiceType msgType = null;
        if (SOURCE_DISK.equals(sourceType)) {
            msgType = !StringUtils.isEmpty((String)invoiceNumber) ? PwyServiceType.OPR_POOL_DISK_DOWNLOAD_SINGLE : PwyServiceType.OPR_POOL_DISK_DOWNLOAD;
        } else if (SOURCE_WEB.equals(sourceType)) {
            msgType = !StringUtils.isEmpty((String)invoiceNumber) ? PwyServiceType.OPR_POOL_WEB_DOWNLOAD_CODENO : PwyServiceType.OPR_POOL_WEB_DOWNLOAD;
        } else if (SOURCE_RIM_WEB.equals(sourceType)) {
            msgType = PwyServiceType.OPR_RIM_INVOICE_QUERY;
        }
        return msgType;
    }

    protected List<HashMap> buildDownloadInvoiceBodyList(Context ctx, Map formData, PwyServiceType msgType, String sourceType) throws TMException {
        ArrayList<HashMap> bodyList = new ArrayList<HashMap>();
        if (PwyServiceType.OPR_POOL_DISK_DOWNLOAD_SINGLE.equals((Object)msgType)) {
            this.buildDiskDownloadSingleParam(ctx, formData, bodyList, sourceType);
        } else if (PwyServiceType.OPR_POOL_DISK_DOWNLOAD.equals((Object)msgType)) {
            this.buildDiskDownloadParam(ctx, formData, bodyList, sourceType);
        } else if (PwyServiceType.OPR_POOL_WEB_DOWNLOAD_CODENO.equals((Object)msgType)) {
            this.buildWebDownloadCodeNoParam(ctx, formData, bodyList, sourceType);
        } else if (PwyServiceType.OPR_POOL_WEB_DOWNLOAD.equals((Object)msgType)) {
            this.buildWebDownloadParam(ctx, formData, bodyList, sourceType);
        } else if (PwyServiceType.OPR_RIM_INVOICE_QUERY.equals((Object)msgType)) {
            RIMUtil.buildRIMWebDownloadParam(ctx, formData, bodyList, sourceType);
        }
        return bodyList;
    }

    protected void buildDiskDownloadSingleParam(Context ctx, Map formData, List bodyList, String sourceType) {
        String invoiceCode = (String)formData.get("invoiceCode");
        String invoiceNumber = (String)formData.get("invoiceNumber");
        String[] codeArr = invoiceCode.trim().split("[;\uff1b]");
        String[] noArr = invoiceNumber.trim().split("[;\uff1b]");
        int noLen = noArr.length;
        int codeLen = codeArr.length;
        for (int i = 0; i < noLen; ++i) {
            HashMap<String, String> params = new HashMap<String, String>();
            if (i < codeLen) {
                params.put("invoiceCode", codeArr[i]);
            } else {
                params.put("invoiceCode", "");
            }
            params.put("invoiceNo", noArr[i]);
            bodyList.add(params);
        }
    }

    protected void buildDiskDownloadParam(Context ctx, Map formData, List bodyList, String sourceType) {
        String startDate = (String)formData.get("beginDate");
        String endDate = (String)formData.get("endDate");
        List supplierTaxNos = (List)formData.get("supplierTaxNos");
        String invoiceType = (String)formData.get("invoiceType");
        String invoiceStatus = (String)formData.get("invoiceStatus");
        String checkStatus = (String)formData.get("checkStatus");
        String invoiceTypes = this.getInvoiceTypes(invoiceType, sourceType);
        String[] types = invoiceTypes.split(",");
        for (int i = 0; i < types.length; ++i) {
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("serialNo", "");
            body.put("dataFromIndex", 0);
            body.put("dataIndex", "");
            HashMap<String, String> opt = new HashMap<String, String>();
            opt.put("startTime", startDate);
            opt.put("endTime", endDate);
            opt.put("authenticateFlags", checkStatus);
            if (!invoiceStatus.contains(",")) {
                opt.put("invoiceStatus", invoiceStatus);
            }
            opt.put("invoiceType", types[i]);
            if (supplierTaxNos.isEmpty()) {
                HashMap<String, String> searchOpt = new HashMap<String, String>();
                searchOpt.putAll(opt);
                searchOpt.put("salerTaxNo", "");
                HashMap<String, Object> bodyParam = new HashMap<String, Object>();
                bodyParam.putAll(body);
                bodyParam.put("searchOpt", searchOpt);
                bodyList.add(bodyParam);
                continue;
            }
            for (String taxNo : supplierTaxNos) {
                HashMap<String, String> searchOpt = new HashMap<String, String>();
                searchOpt.putAll(opt);
                searchOpt.put("salerTaxNo", taxNo);
                HashMap<String, Object> bodyParam = new HashMap<String, Object>();
                bodyParam.putAll(body);
                bodyParam.put("searchOpt", searchOpt);
                bodyList.add(bodyParam);
            }
        }
    }

    protected String getInvoiceTypes(String invoiceTypes, String sourceType) {
        if (SOURCE_WEB.equals(sourceType)) {
            return invoiceTypes;
        }
        String[] types = invoiceTypes.split(",");
        List<String> typeList = Arrays.asList(types);
        List<String> diskSupportInvoiceTypeList = Arrays.asList(this.diskSupportInvoiceTypes);
        ArrayList<String> resultInvoiceTypes = new ArrayList<String>();
        int size = typeList.size();
        for (int i = 0; i < size; ++i) {
            if (!diskSupportInvoiceTypeList.contains(typeList.get(i))) continue;
            resultInvoiceTypes.add(typeList.get(i));
        }
        return CollectionUtil.convertList2String(resultInvoiceTypes, ",", false);
    }

    protected void buildWebDownloadParam(Context ctx, Map formData, List bodyList, String sourceType) {
        String startDate = (String)formData.get("beginDate");
        String endDate = (String)formData.get("endDate");
        List supplierTaxNos = (List)formData.get("supplierTaxNos");
        String invoiceType = (String)formData.get("invoiceType");
        String invoiceStatus = (String)formData.get("invoiceStatus");
        String checkStatus = (String)formData.get("checkStatus");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("startTime", startDate);
        body.put("endTime", endDate);
        body.put("invoiceTypes", this.getInvoiceTypes(invoiceType, sourceType));
        if (!invoiceStatus.contains(",")) {
            body.put("invoiceStatus", invoiceStatus);
        }
        body.put("authenticateFlags", checkStatus);
        body.put("salerTaxNo", "");
        body.put("pageNo", OPER_DOWNLOADINVOICEDETAIL);
        body.put("pageSize", "50");
        if (supplierTaxNos.isEmpty()) {
            HashMap<String, String> bodyParam = new HashMap<String, String>();
            bodyParam.putAll(body);
            bodyList.add(bodyParam);
        } else {
            for (String taxNo : supplierTaxNos) {
                HashMap<String, String> bodyParam = new HashMap<String, String>();
                bodyParam.putAll(body);
                bodyParam.put("salerTaxNo", taxNo);
                bodyList.add(bodyParam);
            }
        }
    }

    protected void buildWebDownloadCodeNoParam(Context ctx, Map formData, List bodyList, String sourceType) {
        String invoiceCode = (String)formData.get("invoiceCode");
        String invoiceNumber = (String)formData.get("invoiceNumber");
        HashMap bodyParam = new HashMap();
        String[] codeArr = invoiceCode.trim().split("[;\uff1b]");
        String[] noArr = invoiceNumber.trim().split("[;\uff1b]");
        int noLen = noArr.length;
        int codeLen = codeArr.length;
        for (int i = 0; i < noLen; ++i) {
            HashMap<String, String> params = new HashMap<String, String>();
            if (i < codeLen) {
                params.put("invoiceCode", codeArr[i]);
            } else {
                params.put("invoiceCode", "");
            }
            params.put("invoiceNo", noArr[i]);
            bodyList.add(params);
        }
    }

    public Map parseDownloadInvoice(Context ctx, Map params) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company;
        String orgid = (String)params.get("orgid");
        HashMap<String, PoolDownloadResult> totalMap = (HashMap<String, PoolDownloadResult>)params.get("totalMap");
        if (totalMap == null) {
            totalMap = new HashMap<String, PoolDownloadResult>();
        }
        if (!totalMap.containsKey((company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid))).getId().toString())) {
            PoolDownloadResult result = new PoolDownloadResult();
            result.setCompany(company);
            totalMap.put(orgid, result);
        }
        TaxNoSumResult sumRet = null;
        if (params.get("sumRet") instanceof TaxNoSumResult) {
            sumRet = (TaxNoSumResult)params.get("sumRet");
        } else if (params.get("sumRet") instanceof Map) {
            sumRet = (TaxNoSumResult)JSONUtils.convertJsonToObject((Context)ctx, (String)JSONUtils.convertObjectToJson((Context)ctx, (Object)((Map)params.get("sumRet"))), TaxNoSumResult.class);
        }
        try {
            Map<String, CompanyOrgUnitInfo> companyMap = IncomeInvoicePwyHelper.matchPwySettingCompany(sumRet);
            DownloadInvoiceType srcType = this.getSrcType(params.get("sourceType"));
            DownloadInvoiceParams downloadParams = new DownloadInvoiceParams(srcType);
            downloadParams.setInvoiceType((String)params.get("invoiceTypes"));
            downloadParams.putAll(params);
            downloadParams.setCompanyMap(companyMap);
            String retInfo = (String)params.get("retInfo");
            List invoiceList = PoolDownloadInvoiceHelper.parseDownLoadInvoice((Context)ctx, (String)retInfo, (DownloadInvoiceParams)downloadParams);
            IObjectValue invoiceInfo = null;
            for (int i = 0; i < invoiceList.size(); ++i) {
                PoolDownloadResult result;
                invoiceInfo = (IObjectValue)invoiceList.get(i);
                company = (CompanyOrgUnitInfo)invoiceInfo.get("company");
                if (totalMap.containsKey(company.getId().toString())) {
                    result = (PoolDownloadResult)totalMap.get(company.getId().toString());
                    result.add(invoiceInfo);
                    continue;
                }
                result = new PoolDownloadResult();
                result.setCompany(company);
                result.add(invoiceInfo);
                totalMap.put(company.getId().toString(), result);
            }
        }
        catch (Exception e) {
            logger.error(e);
            if (totalMap.containsKey(company.getId().toString())) {
                PoolDownloadResult result = (PoolDownloadResult)totalMap.get(company.getId().toString());
                result.getErrMsgList().add(e.getMessage());
                totalMap.put(orgid, result);
                return totalMap;
            }
            PoolDownloadResult result = new PoolDownloadResult();
            result.setCompany(company);
            result.getErrMsgList().add(e.getMessage());
            totalMap.put(orgid, result);
            return totalMap;
        }
        return totalMap;
    }

    private DownloadInvoiceType getSrcType(Object sourceType) {
        if (SOURCE_DISK.equals(sourceType)) {
            return DownloadInvoiceType.DISK;
        }
        if (SOURCE_RIM_WEB.equals(sourceType)) {
            return DownloadInvoiceType.RIMWEB;
        }
        return DownloadInvoiceType.WEB;
    }
}

