/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util.ofd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlUtil {
    public static Map<String, Object> Dom2Map(String str) throws DocumentException {
        Document documents = DocumentHelper.parseText((String)str);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (documents == null) {
            return map;
        }
        Element element = documents.getRootElement();
        Element root = documents.getRootElement();
        Iterator iterator = root.elementIterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            List list = e.elements();
            if (list.size() > 0) {
                map.put(e.getName(), XmlUtil.Dom2Map(e));
                continue;
            }
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    private static Map<String, Object> Dom2Map(Element e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element iter = (Element)list.get(i);
                List<Object> mapList = new ArrayList();
                if (iter.elements().size() > 0) {
                    Map<String, Object> m = XmlUtil.Dom2Map(iter);
                    if (map.get(iter.getName()) != null) {
                        Object obj = map.get(iter.getName());
                        if (!(obj instanceof List)) {
                            mapList = new ArrayList();
                            mapList.add(obj);
                            mapList.add(m);
                        }
                        if (obj instanceof List) {
                            mapList = (List)obj;
                            mapList.add(m);
                        }
                        map.put(iter.getName(), mapList);
                        continue;
                    }
                    map.put(iter.getName(), m);
                    continue;
                }
                if (map.get(iter.getName()) != null) {
                    Object obj = map.get(iter.getName());
                    if (!(obj instanceof List)) {
                        mapList = new ArrayList();
                        mapList.add(obj);
                        mapList.add(iter.getText());
                    }
                    if (obj instanceof List) {
                        mapList = (List)obj;
                        mapList.add(iter.getText());
                    }
                    map.put(iter.getName(), mapList);
                    continue;
                }
                map.put(iter.getName(), iter.getText());
            }
        } else {
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    public static String toXML(Map _obj, String root) {
        StringBuffer xml = new StringBuffer();
        String[] extra = new String[]{root};
        xml.append("<").append(extra[0]).append(">");
        xml.append(XmlUtil.toXML(_obj));
        xml.append("</").append(extra[0]).append(">");
        return xml.toString();
    }

    private static String toXML(Map _obj) {
        StringBuffer sb = new StringBuffer();
        if (_obj != null) {
            Set keySet = _obj.keySet();
            for (Object key : keySet) {
                Object value = _obj.get(key);
                if (value instanceof Map) {
                    sb.append(XmlUtil.toXMLMap((Map)value, key));
                    continue;
                }
                if (value instanceof Collection) {
                    sb.append(XmlUtil.toXMLCollection((Collection)value, key));
                    continue;
                }
                if (value == null) {
                    sb.append(XmlUtil.toXMLOtherObject("", key));
                    continue;
                }
                sb.append(XmlUtil.toXMLOtherObject(value, key));
            }
        }
        return sb.toString();
    }

    private static String toXMLCollection(Collection _list, Object key) {
        StringBuffer sb = new StringBuffer();
        if (_list != null) {
            sb.append("<").append(key).append("S");
            sb.append(" class=\"").append(key).append(";").append("\"");
            sb.append(" size=").append("\"").append(_list.size()).append("\"");
            sb.append(">");
            Iterator it = _list.iterator();
            while (it.hasNext()) {
                sb.append("<").append(key).append(">");
                sb.append(XmlUtil.toXML((Map)it.next()));
                sb.append("</").append(key).append(">");
            }
            sb.append("</").append(key).append("S").append(">");
        }
        return sb.toString();
    }

    private static String toXMLMap(Map _map, Object node) {
        StringBuffer sb = new StringBuffer();
        if (_map != null) {
            sb.append("<").append(node).append(">");
            sb.append(XmlUtil.toXML(_map));
            sb.append("</").append(node).append(">");
        }
        return sb.toString();
    }

    private static String toXMLOtherObject(Object _obj, Object key) {
        StringBuffer sb = new StringBuffer();
        if (_obj != null) {
            sb.append("<").append(key).append(">");
            String v = _obj.toString();
            if (XmlUtil.containXmlSpecificSymbol(v)) {
                sb.append("<![CDATA[").append(v).append("]]>");
            } else {
                sb.append(v);
            }
            sb.append("</").append(key).append(">");
        }
        return sb.toString();
    }

    private static boolean containXmlSpecificSymbol(String data) {
        return data.indexOf("&") != -1 || data.indexOf(">") != -1 || data.indexOf("<") != -1 || data.indexOf("'") != -1 || data.indexOf("\"") != -1;
    }

    public static Document createDocument(String rootName) {
        Element root = DocumentHelper.createElement((String)rootName);
        root.addNamespace("ofd", "http://www.ofdspec.org");
        return DocumentHelper.createDocument((Element)root);
    }

    public static Document createOfdDocument(String rootName) {
        Element root = DocumentHelper.createElement((String)rootName);
        return DocumentHelper.createDocument((Element)root);
    }

    public static Element AddNode(Element parentNode, String nodeName, String nodeText) {
        Element element = parentNode.addElement(nodeName);
        if (nodeText != null) {
            element.setText(nodeText);
        }
        return element;
    }

    public static Document loadXML(String xml) throws Exception {
        Document document = DocumentHelper.parseText((String)xml);
        return document;
    }

    public static Document loadXML(byte[] xmlData) throws Exception {
        SAXReader reader = new SAXReader();
        ByteArrayInputStream bis = new ByteArrayInputStream(xmlData);
        Document document = reader.read((InputStream)bis);
        return document;
    }

    public static Document loadFromFile(String fileName) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(new File(fileName));
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(Document document, String strPath) throws IOException {
        OutputFormat format = new OutputFormat("  ", true);
        FileOutputStream out = null;
        XMLWriter xmlWriter = null;
        try {
            out = new FileOutputStream(strPath);
            xmlWriter = new XMLWriter((OutputStream)out, format);
            xmlWriter.write(document);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (xmlWriter != null) {
                xmlWriter.close();
            }
        }
    }

    public static byte[] toByteArray(Document document) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLWriter xmlWriter = new XMLWriter((OutputStream)bos);
        xmlWriter.write(document);
        xmlWriter.close();
        byte[] bts = bos.toByteArray();
        bos.close();
        return bts;
    }
}

