/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util.ofd.util;

import com.kingdee.eas.tm.im.util.ofd.ExportQrCode;
import com.kingdee.eas.tm.im.util.ofd.StrUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class SvgUtil {
    public static Map<String, Object> getPageSvg(Element pageEle, String areaText, Map<String, String> fontFamilyMap, StringBuffer svgBuffer, Map<String, Object> multiMediaMap, String signSvgString, float offsetY, int pageNum) {
        List imageEleList;
        List pathObjectEleList;
        Element contentEle;
        Element layerEle;
        List textEleList;
        HashMap<String, Object> svgMap = new HashMap<String, Object>();
        Element areaEle = pageEle.element("Area");
        if (areaEle != null) {
            areaText = areaEle.elementText("PhysicalBox");
        }
        if (areaText != null && !"".equals(areaText)) {
            String[] areaArr = areaText.split(" ");
            if (svgBuffer == null || svgBuffer.length() == 0) {
                float areaHeight;
                float areaWidth = Float.parseFloat(areaArr[2]);
                if (areaWidth == 0.0f) {
                    areaWidth = 210.0f;
                }
                if ((areaHeight = Float.parseFloat(areaArr[3])) == 0.0f) {
                    areaHeight = pageNum == 0 ? 140.0f : 297.0f;
                }
                float offsetHeight = offsetY + areaHeight;
                svgMap.put("offsetY", Float.valueOf(offsetHeight));
                svgBuffer = new StringBuffer("<svg width=\"" + areaWidth + "mm\" height=\" " + offsetHeight + "mm\">");
            }
        }
        if ((textEleList = (layerEle = (contentEle = pageEle.element("Content")).element("Layer")).elements("TextObject")) != null && !textEleList.isEmpty()) {
            SvgUtil.getSvgTextByList(textEleList, fontFamilyMap, svgBuffer, 0.0f, offsetY);
        }
        if ((pathObjectEleList = layerEle.elements("PathObject")) != null && !pathObjectEleList.isEmpty()) {
            SvgUtil.getSvgLineByList(pathObjectEleList, svgBuffer, 0.0f, offsetY);
        }
        if ((imageEleList = layerEle.elements("ImageObject")) != null && !imageEleList.isEmpty()) {
            svgBuffer.append(SvgUtil.getSvgImageByList(imageEleList, multiMediaMap, offsetY));
        }
        if (signSvgString != null) {
            svgBuffer.append(signSvgString);
        }
        svgMap.put("svgBuffer", svgBuffer);
        return svgMap;
    }

    public static StringBuffer getSvgTextByList(List<Element> textEleList, Map<String, String> fontFamilyMap, StringBuffer svgBuffer, float pageOffsetX, float pageOffsetY) {
        for (Element textEleTag : textEleList) {
            String boundary = textEleTag.attributeValue("Boundary");
            String[] boundaryArr = boundary.split(" ");
            String fontFamily = fontFamilyMap.get(textEleTag.attributeValue("Font"));
            String fontSizeStr = textEleTag.attributeValue("Size");
            float fontSize = Float.parseFloat(fontSizeStr);
            Element textCodeEle = textEleTag.element("TextCode");
            String textStr = textCodeEle.getText();
            String offsetXStr = textCodeEle.attributeValue("X");
            String offsetYStr = textCodeEle.attributeValue("Y");
            float offsetX = Float.parseFloat(offsetXStr);
            float offsetY = Float.parseFloat(offsetYStr);
            String deltaX = textCodeEle.attributeValue("DeltaX");
            String deltaY = textCodeEle.attributeValue("DeltaY");
            StringBuffer deltaBuffer = SvgUtil.getOffsetBuffer(deltaX, fontSize, fontFamily);
            String fontColor = "#000000";
            Element fontColorEle = textEleTag.element("FillColor");
            if (fontColorEle != null) {
                fontColor = SvgUtil.getHexColorByRgb(fontColorEle.attributeValue("Value"));
            } else {
                String fillColorStr = fontFamilyMap.get("fillColor");
                if (!StrUtil.isEmpty(fillColorStr)) {
                    fontColor = SvgUtil.getHexColorByRgb(fillColorStr);
                }
            }
            String ctmStr = textEleTag.attributeValue("CTM");
            float x = Float.parseFloat(boundaryArr[0]);
            float y = Float.parseFloat(boundaryArr[1]);
            String[] ctmArr = null;
            float ctmX = 0.0f;
            float ctmY = 0.0f;
            if (ctmStr != null && !"".equals(ctmStr)) {
                ctmArr = ctmStr.split(" ");
                ctmX = x + pageOffsetX + Float.parseFloat(ctmArr[4]);
                ctmY = y + pageOffsetY + Float.parseFloat(ctmArr[5]);
                ctmArr[4] = ctmX + "";
                ctmArr[5] = ctmY + "";
                x = offsetX;
                y = offsetY;
            } else {
                x = x + offsetX + pageOffsetX;
                y = y + offsetY + pageOffsetY;
            }
            textStr = deltaY != null && deltaY.length() > 0 ? SvgUtil.getOffsetYBuffer(textStr, x, y, deltaY) : SvgUtil.getCdataStr(textStr);
            svgBuffer.append("<text x=\"").append(x).append("mm\" y=\"").append(y).append("mm\" ");
            svgBuffer.append("fill=\"").append(fontColor).append("\" font-size=\"").append(fontSize).append("mm\" ");
            svgBuffer.append("font-family=\"").append(fontFamily).append("\" ");
            svgBuffer.append(deltaBuffer).append(SvgUtil.getTextCtmBuffer(ctmArr)).append(">").append(textStr).append("</text>");
        }
        return svgBuffer;
    }

    public static StringBuffer getSvgLineByList(List<Element> lineEleList, StringBuffer svgBuffer, float pageOffsetX, float pageOffsetY) {
        for (Element lineEle : lineEleList) {
            String[] parts;
            String boundary = lineEle.attributeValue("Boundary");
            String[] boundaryArr = boundary.split(" ");
            float x = Float.parseFloat(boundaryArr[0]) + pageOffsetX;
            float y = Float.parseFloat(boundaryArr[1]) + pageOffsetY;
            String ctmMatrix = "";
            String ctmStr = lineEle.attributeValue("CTM");
            if (!StrUtil.isEmpty(ctmStr)) {
                String[] ctmArr = ctmStr.split(" ");
                if (ctmArr != null && ctmArr.length == 6) {
                    ctmArr[4] = x + Float.parseFloat(ctmArr[4]) + "";
                    ctmArr[5] = y + Float.parseFloat(ctmArr[5]) + "";
                    ctmMatrix = SvgUtil.getTextCtmBuffer(ctmArr).toString();
                }
            } else {
                ctmMatrix = SvgUtil.getTranslateStr(x, y);
            }
            String lineWidth = lineEle.attributeValue("LineWidth");
            String strokeColor = "#000000";
            Element strokeColorEle = lineEle.element("StrokeColor");
            if (strokeColorEle != null) {
                strokeColor = SvgUtil.getHexColorByRgb(strokeColorEle.attributeValue("Value"));
            }
            StringBuffer dBuffer = new StringBuffer();
            String abbreviatedData = lineEle.elementText("AbbreviatedData");
            block18: for (String part : parts = abbreviatedData.split(" (?=[SMLQBAC])")) {
                String[] temps = part.split(" ");
                switch (temps[0]) {
                    case "S": 
                    case "M": {
                        dBuffer.append("M ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[1]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[2]))).append(" ");
                        continue block18;
                    }
                    case "L": {
                        dBuffer.append("L ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[1]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[2]))).append(" ");
                        continue block18;
                    }
                    case "Q": {
                        dBuffer.append("Q ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[1]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[2]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[3]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[4]))).append(" ");
                        continue block18;
                    }
                    case "B": {
                        dBuffer.append("C ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[1]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[2]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[3]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[4]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[5]))).append(" ");
                        dBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(temps[6]))).append(" ");
                        continue block18;
                    }
                    case "A": {
                        continue block18;
                    }
                    case "C": {
                        dBuffer.append("Z");
                    }
                }
            }
            svgBuffer.append(SvgUtil.getPathBuffer(strokeColor, lineWidth, ctmMatrix, dBuffer.toString()));
        }
        return svgBuffer;
    }

    private static StringBuffer getTextCtmBuffer(String[] ctmArr) {
        StringBuffer matrixBuffer = new StringBuffer();
        if (ctmArr != null && ctmArr.length == 6) {
            matrixBuffer.append(" transform=\"matrix(");
            matrixBuffer.append(ctmArr[0]).append(" ");
            matrixBuffer.append(ctmArr[1]).append(" ");
            matrixBuffer.append(ctmArr[2]).append(" ");
            matrixBuffer.append(ctmArr[3]).append(" ");
            matrixBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(ctmArr[4]))).append(" ");
            matrixBuffer.append(SvgUtil.getPxByMM(Float.parseFloat(ctmArr[5])));
            matrixBuffer.append(")\" ");
        }
        return matrixBuffer;
    }

    private static String getTranslateStr(float x, float y) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" transform=\"translate(");
        buffer.append(SvgUtil.getPxByMM(x)).append(",");
        buffer.append(SvgUtil.getPxByMM(y));
        buffer.append(")\" ");
        return buffer.toString();
    }

    public static float getPxByMM(float mmValue) {
        return mmValue * 96.0f / 25.4f;
    }

    private static StringBuffer getPathBuffer(String strokeColor, String lineWidth, String ctmMatrix, String d) {
        StringBuffer lineBuffer = new StringBuffer("<path fill=\"none\" ");
        lineBuffer.append("stroke=\"").append(strokeColor).append("\" ");
        if (!StrUtil.isEmpty(lineWidth)) {
            lineBuffer.append("stroke-width=\"").append(lineWidth).append("mm\" ");
        }
        lineBuffer.append("d=\"").append(d).append("\" ");
        lineBuffer.append(ctmMatrix).append("/> ");
        return lineBuffer;
    }

    private static StringBuffer getSvgImageByList(List<Element> imageEleList, Map<String, Object> multiMediaMap, float offsetY) {
        StringBuffer imageBuffer = new StringBuffer();
        for (Element imageEle : imageEleList) {
            String resourceID = imageEle.attributeValue("ResourceID");
            String boundary = imageEle.attributeValue("Boundary");
            String[] boundaryArr = boundary.split(" ");
            String imageName = (String)multiMediaMap.get(resourceID);
            if (imageName == null || "".equals(imageName)) continue;
            byte[] imageFileByte = (byte[])multiMediaMap.get(resourceID + "_BYTE");
            String imageBase64Str = null;
            try {
                imageBase64Str = ExportQrCode.getImageBase64(imageFileByte, imageName.split("\\.")[1]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            imageBuffer.append("<image x=\"").append(boundaryArr[0]).append("mm\" ");
            imageBuffer.append("y=\"").append(offsetY + Float.parseFloat(boundaryArr[1])).append("mm\" ");
            imageBuffer.append("width=\"").append(boundaryArr[2]).append("mm\" ");
            imageBuffer.append("height=\"").append(boundaryArr[3]).append("mm\" xlink:href=\"data:image/png;base64,");
            if (imageBase64Str != null) {
                imageBuffer.append(imageBase64Str.replaceAll("\r", "").replaceAll("\n", ""));
            }
            imageBuffer.append("\"/>");
        }
        return imageBuffer;
    }

    private static String getOffsetYBuffer(String textStr, float xIndex, float yIndex, String deltaY) {
        StringBuffer offsetYBuffer = new StringBuffer();
        float lastY = yIndex;
        if (!deltaY.contains("g")) {
            offsetYBuffer.append("<tspan>").append(textStr.substring(0, 1)).append("</tspan>");
            String[] deltaArr = deltaY.split(" ");
            for (int i = 0; i < deltaArr.length; ++i) {
                float offsetY = Float.parseFloat(deltaArr[0]);
                offsetYBuffer.append("<tspan x=\"").append(xIndex);
                offsetYBuffer.append("mm\" y=\"").append(lastY += offsetY).append("mm\">");
                offsetYBuffer.append(SvgUtil.getCdataStr(textStr.substring(i + 1, i + 2))).append("</tspan>");
            }
        } else {
            String[] deltaYArr = deltaY.split("g ");
            for (int i = 1; i < deltaYArr.length - 1; ++i) {
                String deltaStr = deltaYArr[i];
                String[] deltaArr = deltaStr.split(" ");
                int num = Integer.parseInt(deltaArr[0]) + 1;
                int startNum = SvgUtil.getLastNum(num, i, textStr.length());
                int lastNum = SvgUtil.getLastNum(num, i + 1, textStr.length());
                float offsetY = Float.parseFloat(deltaArr[2]);
                if (i == 1) {
                    offsetYBuffer.append("<tspan>").append(SvgUtil.getCdataStr(textStr.substring(0, startNum))).append("</tspan>");
                }
                offsetYBuffer.append("<tspan x=\"").append(xIndex);
                offsetYBuffer.append("mm\" y=\"").append(lastY += offsetY).append("mm\">");
                offsetYBuffer.append(SvgUtil.getCdataStr(textStr.substring(startNum, lastNum))).append("</tspan>");
            }
        }
        return offsetYBuffer.toString();
    }

    private static int getLastNum(int num, int i, int limitNum) {
        int lastNum = num * i;
        if (lastNum > limitNum) {
            lastNum = limitNum;
        }
        return lastNum;
    }

    private static StringBuffer getOffsetBuffer(String deltaX, float fontSize, String fontFamily) {
        StringBuffer offsetX;
        StringBuffer buffer = new StringBuffer();
        if ("\u6977\u4f53, KaiTi, Kai, simkai".equals(fontFamily) && deltaX != null && deltaX.length() > 0 && (offsetX = SvgUtil.getOffsetBufferByDelta(deltaX, fontSize)) != null) {
            buffer.append(offsetX);
        }
        return buffer;
    }

    private static StringBuffer getOffsetBufferByDelta(String delta, float fontSize) {
        StringBuffer buffer = new StringBuffer();
        String[] deltaArr = delta.split(" ");
        boolean zeroFlag = true;
        for (int i = 0; i < deltaArr.length; ++i) {
            String deltaStrI = deltaArr[i];
            if ("g".equals(deltaArr[i])) {
                int times = Integer.parseInt(deltaArr[i + 1]);
                float offsetValue = SvgUtil.getOffsetValue(deltaArr[i + 2], fontSize);
                if (zeroFlag && offsetValue != 0.0f) {
                    zeroFlag = false;
                }
                for (int j = 0; j < times; ++j) {
                    buffer.append(offsetValue).append("mm,");
                }
                i += 2;
                continue;
            }
            float offsetValue = SvgUtil.getOffsetValue(deltaStrI, fontSize);
            if (zeroFlag && offsetValue != 0.0f) {
                zeroFlag = false;
            }
            buffer.append(offsetValue).append("mm,");
        }
        int bufferLength = buffer.length();
        if (!zeroFlag && bufferLength > 0) {
            StringBuffer bufferLast = new StringBuffer("dx=\"0mm,");
            bufferLast.append(buffer.substring(0, bufferLength - 1));
            bufferLast.append("\" ");
            return bufferLast;
        }
        return null;
    }

    private static float getOffsetValue(String deltaStr, float fontSize) {
        return Float.parseFloat(deltaStr) - fontSize;
    }

    private static String getCdataStr(String str) {
        if (str != null) {
            str = str.replaceAll("&", "&amp;");
            str = str.replaceAll("  ", "&#160;");
            str = str.replaceAll("<", "&lt;");
            str = str.replaceAll(">", "&gt;");
            str = str.replaceAll("'", "&aops;");
            str = str.replaceAll("\"", "&aops;");
        }
        return str;
    }

    private static String getHexColorByRgb(String rgbStr) {
        if ("0 0 0".equals(rgbStr) || rgbStr == null || "".equals(rgbStr)) {
            return "#000000";
        }
        if ("156 82 35".equals(rgbStr)) {
            return "#9C5223";
        }
        String[] rgbArr = rgbStr.split(" ");
        return String.format("#%02x%02x%02x", Integer.parseInt(rgbArr[0]), Integer.parseInt(rgbArr[1]), Integer.parseInt(rgbArr[2])).toUpperCase();
    }
}

