/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.ws;

import com.alibaba.fastjson.annotation.JSONField;
import com.kingdee.eas.tm.im.ws.BillResultInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ResultInfo
implements Serializable {
    private static final long serialVersionUID = 9110640431620540988L;
    private int status = 1;
    private String msg;
    private List<BillResultInfo> billErrors = new ArrayList<BillResultInfo>();
    private String errorCode = null;

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        this.setErrorCode(String.valueOf(status));
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public List<BillResultInfo> getBillErrors() {
        return this.billErrors;
    }

    public void setBillErrors(List<BillResultInfo> billErrors) {
        this.billErrors = billErrors;
    }

    public boolean isSuccess() {
        return this.status == 0;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public static ResultInfo buildSuccess() {
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.setStatus(0);
        return resultInfo;
    }

    public static ResultInfo buildError(String msg) {
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.setStatus(2);
        resultInfo.setMsg(msg);
        return resultInfo;
    }

    public static ResultInfo buildResult(List<BillResultInfo> billResultList) {
        ResultInfo resultInfo = new ResultInfo();
        resultInfo.setBillErrors(billResultList);
        BillResultInfo billResultInfo = null;
        int successCount = 0;
        int size = billResultList.size();
        for (int i = 0; i < size; ++i) {
            billResultInfo = billResultList.get(i);
            if (billResultInfo.getStatus() != 0) continue;
            ++successCount;
        }
        if (successCount == 0) {
            resultInfo.setStatus(2);
        } else if (successCount == billResultList.size()) {
            resultInfo.setStatus(0);
        } else {
            resultInfo.setStatus(1);
        }
        return resultInfo;
    }

    @JSONField(serialize=false, deserialize=false)
    public ArrayList<String> getErrorMsg() {
        ArrayList<String> errorMsg = new ArrayList<String>();
        if (this.getBillErrors().size() == 0) {
            errorMsg.add(this.getMsg());
        } else {
            BillResultInfo billResultInfo = null;
            StringBuffer msg = null;
            int size = this.getBillErrors().size();
            for (int i = 0; i < size; ++i) {
                billResultInfo = this.getBillErrors().get(i);
                msg = new StringBuffer();
                msg.append(billResultInfo.getNumber() + "\uff1a");
                int j = 0;
                int len = billResultInfo.getErrorMsgs().size();
                while (i < len) {
                    if (j > 0) {
                        msg.append("\u3001");
                    }
                    msg.append(billResultInfo.getErrorMsgs().get(j));
                    ++i;
                }
                errorMsg.add(msg.toString());
            }
        }
        return errorMsg;
    }
}

