/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.rpt.client;

import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.rpt.client.AbstractMakeInvoiceAnalysisRptConditionUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MakeInvoiceAnalysisRptConditionUI
extends AbstractMakeInvoiceAnalysisRptConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(MakeInvoiceAnalysisRptConditionUI.class);
    private DataChangeListener prmtCompanyChange = null;

    public void onInit(RptParams initParams) throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, "im_AnalysisRpt_view");
        this.bizOrgUnit.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        this.initListeners();
    }

    private void initListeners() {
        if (this.prmtCompanyChange == null) {
            this.prmtCompanyChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    MakeInvoiceAnalysisRptConditionUI.this.prmtCompanyChange_dataChanged(eventObj);
                }
            };
        }
        this.bizOrgUnit.addDataChangeListener(this.prmtCompanyChange);
    }

    protected void prmtCompanyChange_dataChanged(DataChangeEvent e) {
        Object[] companyOrg = this.bizOrgUnit.getValue() instanceof CompanyOrgUnitInfo ? new Object[]{this.bizOrgUnit.getValue()} : (Object[])this.bizOrgUnit.getValue();
        HashSet<String> companyIds = new HashSet<String>();
        CompanyOrgUnitInfo company = null;
        for (int i = 0; i < companyOrg.length; ++i) {
            company = (CompanyOrgUnitInfo)companyOrg[i];
            if (company == null) continue;
            companyIds.add(company.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", companyIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
        view.setFilter(filter);
        this.prmtCustomerFrom.setEntityViewInfo(view);
        this.prmtCustomerTo.setEntityViewInfo(view);
        this.prmtCustomerFrom.setValue(null);
        this.prmtCustomerTo.setValue(null);
    }

    public void clear() {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, "im_AnalysisRpt_view");
        this.bizOrgUnit.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        try {
            this.bizOrgUnit.setValue((Object)IMUtils.getPermissionCompany("im_AnalysisRpt_view"));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        SCMQueryFormat.formatStartTime((KDDatePicker)this.dpkDataFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.dpkDataTo);
        this.prmtCustomerFrom.setValue(null);
        this.prmtCustomerTo.setValue(null);
        this.txtNumber.setText(null);
        this.txtInvoiceNumber.setText(null);
        this.cbxShowNoInvoice.setSelected(true);
        this.cbxShowZero.setSelected(true);
        this.cbSrcBillType.setSelectedItem((Object)0);
    }

    public RptParams getCustomCondition() {
        RptParams para = new RptParams();
        para.setObject("companyIds", this.bizOrgUnit.getValue());
        para.setObject("dateFrom", (Object)this.dpkDataFrom.getText());
        para.setObject("dateTo", (Object)this.dpkDataTo.getText());
        if (this.prmtCustomerFrom.getValue() != null) {
            CustomerInfo custFrom = (CustomerInfo)this.prmtCustomerFrom.getValue();
            para.setObject("customerFrom", (Object)custFrom.getId().toString());
        }
        para.setObject("custFrom", this.prmtCustomerFrom.getValue());
        if (this.prmtCustomerTo.getValue() != null) {
            CustomerInfo custTo = (CustomerInfo)this.prmtCustomerTo.getValue();
            para.setObject("customerTo", (Object)custTo.getId().toString());
        }
        para.setObject("custTo", this.prmtCustomerTo.getValue());
        para.setString("billNumber", this.txtNumber.getText());
        para.setString("invoiceNo", this.txtInvoiceNumber.getText());
        para.setBoolean("isShowNoInvoice", this.cbxShowNoInvoice.isSelected());
        para.setBoolean("isShowZero", this.cbxShowZero.isSelected());
        para.setObject("srcBillType", this.cbSrcBillType.getSelectedItem());
        return para;
    }

    public void setCustomCondition(RptParams params) {
        this.bizOrgUnit.setValue(params.getObject("companyIds"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (params.getObject("dateFrom") != null && !"".equals(params.getObject("dateFrom"))) {
                Date dateFrom = sdf.parse(params.getObject("dateFrom").toString());
                this.dpkDataFrom.setValue((Object)dateFrom);
            }
            if (params.getObject("dateTo") != null && !"".equals(params.getObject("dateTo"))) {
                Date dateTo = sdf.parse(params.getObject("dateTo").toString());
                this.dpkDataTo.setValue((Object)dateTo);
            }
        }
        catch (ParseException e) {
            this.handUIException(e);
        }
        this.prmtCustomerFrom.setValue(params.getObject("custFrom"));
        this.prmtCustomerTo.setValue(params.getObject("custTo"));
        this.txtNumber.setText(params.getString("billNumber"));
        this.txtInvoiceNumber.setText(params.getString("invoiceNo"));
        this.cbxShowNoInvoice.setSelected(params.getBoolean("isShowNoInvoice"));
        this.cbxShowZero.setSelected(params.getBoolean("isShowZero"));
        this.cbSrcBillType.setSelectedItem(params.getObject("srcBillType"));
    }

    public boolean verify() {
        Date endDate;
        if (this.companyIsNull()) {
            MsgBox.showInfo((String)this.getResource("companyNotNull"));
            return false;
        }
        if (this.dpkDataFrom.getValue() == null) {
            return true;
        }
        if (this.dpkDataTo.getValue() == null) {
            return true;
        }
        Date beginDate = (Date)this.dpkDataFrom.getValue();
        if (beginDate.compareTo(endDate = (Date)this.dpkDataTo.getValue()) > 0) {
            MsgBox.showInfo((String)this.getResource("timeRangeError"));
            SysUtil.abort();
        }
        return true;
    }

    private boolean companyIsNull() {
        if (this.bizOrgUnit.getValue() == null) {
            return true;
        }
        if (this.bizOrgUnit.getValue() instanceof Object[]) {
            Object[] values;
            for (Object value : values = (Object[])this.bizOrgUnit.getValue()) {
                if (value == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String getResource(String key) {
        return IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", key, IMUtils.getLocale());
    }
}

