/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.account.engine.interfaces.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.tm.td.account.engine.interfaces.ISQLBuilder;
import com.kingdee.eas.tm.td.account.engine.model.AccountCalculatorParams;
import com.kingdee.eas.tm.td.account.engine.util.AccountUtil;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryCollection;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.DataSourceInfo;
import com.kingdee.eas.tm.td.basedata.FieldsMappingCollection;
import com.kingdee.eas.tm.td.basedata.FieldsMappingFactory;
import com.kingdee.eas.tm.td.basedata.FieldsMappingInfo;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionInfo;

public class AbstractAccountSQLBuilder
implements ISQLBuilder {
    protected Context ctx;
    protected AccountConfigInfo accountConfigInfo = null;
    protected TakeDataContditionInfo conditionInfo = null;
    protected AccountCalculatorParams params = null;

    public AbstractAccountSQLBuilder(Context ctx, AccountConfigInfo accountConfigInfo, TakeDataContditionInfo conditionInfo, AccountCalculatorParams params) {
        this.ctx = ctx;
        this.accountConfigInfo = accountConfigInfo;
        this.conditionInfo = conditionInfo;
        this.params = params;
    }

    @Override
    public String getSQL() throws EASBizException, BOSException {
        StringBuffer result = new StringBuffer();
        result.append(this.getSelectSQL()).append("\r\n");
        result.append(this.getFromSQL());
        FilterInfo filter = this.getFilterInfo();
        String filterSql = filter.toSql();
        if (!StringUtil.isEmpty((String)filterSql)) {
            result.append("Where ").append(filterSql).append("\r\n");
        }
        result.append(this.getOrderSQL());
        return result.toString().replaceAll("\"", "'");
    }

    @Override
    public String getExecuteLockName() {
        return this.conditionInfo.getId().toString();
    }

    protected String getSelectSQL() throws EASBizException, BOSException {
        StringBuffer result = new StringBuffer("Select ").append("\r\n");
        AccountConfigEntryInfo fieldModel = null;
        FieldsMappingInfo fieldDataModel = null;
        AccountConfigEntryCollection fieldColl = this.accountConfigInfo.getEntry();
        fieldColl.sort("seq");
        for (int i = 0; i < fieldColl.size(); ++i) {
            fieldModel = fieldColl.get(i);
            if (i > 0) {
                result.append(",").append("\r\n");
            }
            if ((fieldDataModel = this.getFieldsMappingByConfigEntry(fieldModel.getId().toString(), this.conditionInfo.getId().toString())) == null) {
                result.append(this.getFieldSQL(fieldModel));
                continue;
            }
            result.append(this.getFieldDataModelSQL(fieldModel, fieldDataModel));
        }
        return result.toString();
    }

    private FieldsMappingInfo getFieldsMappingByConfigEntry(String accountConfigEntryId, String conditionId) throws BOSException {
        FieldsMappingInfo fieldsMappingInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountConfigEntry.id", (Object)accountConfigEntryId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("condition.id", (Object)conditionId, CompareType.EQUALS));
        view.setFilter(filter);
        FieldsMappingCollection coll = FieldsMappingFactory.getLocalInstance(this.ctx).getFieldsMappingCollection(view);
        if (coll != null && coll.size() > 0) {
            fieldsMappingInfo = coll.get(0);
        }
        return fieldsMappingInfo;
    }

    protected String getFieldDataModelSQL(AccountConfigEntryInfo fieldModel, FieldsMappingInfo fieldDataModel) {
        if (StringUtil.isEmpty((String)fieldModel.getDefaultValue())) {
            return fieldDataModel.getValueExpression() + " AS " + fieldModel.getName();
        }
        String defaultValue = AccountUtil.getDefaultValueSQL(fieldModel, false);
        return "ISNULL(" + fieldDataModel.getValueExpression() + ", " + defaultValue + ")" + " AS " + fieldModel.getName();
    }

    protected String getFromSQL() throws EASBizException, BOSException {
        String fromSQL = null;
        try {
            DataSourceInfo dataQuery = this.conditionInfo.getDataSource();
            fromSQL = dataQuery.getFromSQL();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return fromSQL;
    }

    protected String getOrderSQL() throws EASBizException, BOSException {
        StringBuffer orderSQL = new StringBuffer();
        AccountConfigEntryCollection fieldColl = this.accountConfigInfo.getEntry();
        AccountConfigEntryInfo fieldModel = null;
        boolean hasOrderField = false;
        orderSQL.append(" ORDER BY ");
        for (int i = 0; i < fieldColl.size(); ++i) {
            fieldModel = fieldColl.get(i);
            if (!fieldModel.isIsSort()) continue;
            orderSQL.append(fieldModel.getName()).append(",");
            hasOrderField = true;
        }
        String result = "";
        if (hasOrderField) {
            result = orderSQL.substring(0, orderSQL.length() - 1) + "\r\n";
        }
        return result;
    }

    protected FilterInfo getFilterInfo() throws EASBizException, BOSException {
        FilterInfo filter = this.conditionInfo.getQueryFilterInfo();
        DataSourceInfo dataQuery = this.conditionInfo.getDataSource();
        filter.mergeFilter(dataQuery.getFilterInfo(), "AND");
        filter.mergeFilter(this.getExtendFilter(), "AND");
        return filter;
    }

    protected FilterInfo getExtendFilter() throws EASBizException, BOSException {
        return null;
    }

    protected String getFieldSQL(AccountConfigEntryInfo fieldModel) {
        String defaultValue;
        String result = "";
        result = fieldModel.getName().equalsIgnoreCase("ID") ? this.conditionInfo.getDataSource().getMainTable().getTableAlias() + ".FID AS FID" : (StringUtil.isEmpty((String)(defaultValue = AccountUtil.getDefaultValueSQL(fieldModel, false))) ? "NULL AS " + fieldModel.getName() : defaultValue + " AS " + fieldModel.getName());
        return result;
    }

    protected String getFieldNameById(String fieldId) throws EASBizException, BOSException {
        FieldsMappingCollection coll = this.getFieldsMappingCollCollection(this.conditionInfo.getId().toString());
        for (int i = 0; i < coll.size(); ++i) {
            AccountConfigEntryInfo field = coll.get(i).getAccountConfigEntry();
            if (!fieldId.equals(field.getId().toString())) continue;
            return coll.get(i).getValueExpression();
        }
        return null;
    }

    protected String getFieldNameByName(String fieldName) throws EASBizException, BOSException {
        FieldsMappingCollection coll = this.getFieldsMappingCollCollection(this.conditionInfo.getId().toString());
        for (int i = 0; i < coll.size(); ++i) {
            AccountConfigEntryInfo field = coll.get(i).getAccountConfigEntry();
            if (!fieldName.equals(field.getName())) continue;
            return coll.get(i).getValueExpression();
        }
        return null;
    }

    private FieldsMappingCollection getFieldsMappingCollCollection(String conditionId) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("condition.id", (Object)conditionId, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountConfigEntry.*"));
        view.setSelector(sic);
        FieldsMappingCollection coll = FieldsMappingFactory.getLocalInstance(this.ctx).getFieldsMappingCollection(view);
        return coll;
    }
}

