/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.account.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.account.formula.AbstractFormulaService;
import com.kingdee.eas.tm.td.account.formula.AccountFormulaColumnParams;
import com.kingdee.eas.tm.td.account.formula.AccountFormulaComparable;
import com.kingdee.eas.tm.td.account.formula.AccountFormulaParams;
import com.kingdee.eas.tm.td.account.formula.FormulaHelper;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryCollection;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountFormulaService
extends AbstractFormulaService {
    private AccountFormulaParams formulaParams = null;
    private AccountConfigInfo configInfo = null;
    private AccountConfigEntryCollection entryColl = null;
    private PeriodInfo period = null;
    private ReportBaseInfo reportInfo = null;
    private List<Object[]> volidData = new ArrayList<Object[]>();
    private static final Logger logger = CoreUIObject.getLogger(AccountFormulaService.class);
    private List<AccountFormulaColumnParams> groupColumns = null;
    private List<AccountFormulaColumnParams> sumColumns = null;
    private List<AccountFormulaColumnParams> headColumns = null;
    private List<AccountFormulaColumnParams> sortColumns = null;
    private List<AccountFormulaColumnParams> groupAndSumColumns = null;
    private List<AccountFormulaColumnParams> hideColumns = null;
    private boolean checkFieldsVolid = true;
    Map<String, BigDecimal[]> sumValueMap = new HashMap<String, BigDecimal[]>();

    @Override
    protected void initParams() throws BOSException, EASBizException {
        this.formulaParams = (AccountFormulaParams)this.params.get("formulaParams");
        this.reportInfo = (TaxDraftRecordInfo)this.params.get("reportInfo");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entry.*");
        this.configInfo = AccountConfigFactory.getLocalInstance(this.ctx).getAccountConfigInfo((IObjectPK)new ObjectUuidPK(this.formulaParams.getAccountID()), sic);
        this.entryColl = this.configInfo.getEntry();
        this.entryColl.sort("seq");
        int periodOffset = this.formulaParams.getPeriodOffset();
        String periodID = ((PeriodInfo)this.reportInfo.get("rptPeriod")).getId().toString();
        PeriodInfo prePeriod = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodID));
        for (int i = 0; i < periodOffset; ++i) {
            prePeriod = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (IObjectPK)new ObjectUuidPK(periodID));
            if (prePeriod == null) {
                String destPeriodIsNotExists = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "destPeriodIsNotExists", this.ctx.getLocale());
                throw new TDException(TDException.ERROR_MSG, new Object[]{destPeriodIsNotExists});
            }
            if (prePeriod.isIsAdjustPeriod() && (prePeriod = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (IObjectPK)new ObjectUuidPK(prePeriod.getId().toString()))) == null) {
                String destPeriodIsNotExists = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "destPeriodIsNotExists", this.ctx.getLocale());
                throw new TDException(TDException.ERROR_MSG, new Object[]{destPeriodIsNotExists});
            }
            periodID = prePeriod.getId().toString();
        }
        this.period = prePeriod;
        this.initColumns();
    }

    private void initColumns() {
        int index;
        AccountFormulaColumnParams columnInfo2 = null;
        this.groupColumns = new ArrayList<AccountFormulaColumnParams>();
        this.sumColumns = new ArrayList<AccountFormulaColumnParams>();
        this.headColumns = new ArrayList<AccountFormulaColumnParams>();
        this.sortColumns = new ArrayList<AccountFormulaColumnParams>();
        this.groupAndSumColumns = new ArrayList<AccountFormulaColumnParams>();
        this.hideColumns = new ArrayList<AccountFormulaColumnParams>();
        for (AccountFormulaColumnParams columnInfo2 : this.formulaParams.getColumnParams()) {
            index = FormulaHelper.getAccountConfigEntryIndex(this.configInfo, columnInfo2.getName());
            if (index < 0) {
                this.checkFieldsVolid = false;
                return;
            }
            columnInfo2.setSeq(index);
            if (columnInfo2.isGroup()) {
                this.groupColumns.add(columnInfo2);
                this.groupAndSumColumns.add(columnInfo2);
            }
            if (columnInfo2.isSum()) {
                this.sumColumns.add(columnInfo2);
            }
            if (columnInfo2.getIsVisible()) {
                this.headColumns.add(columnInfo2);
            }
            if (columnInfo2.getSortType() != 0) {
                this.sortColumns.add(columnInfo2);
            }
            if (columnInfo2.getMatchField() == null || StringUtils.isEmpty((String)columnInfo2.getMatchField()) || columnInfo2.getIsVisible()) continue;
            this.hideColumns.add(columnInfo2);
        }
        for (AccountFormulaColumnParams columnInfo2 : this.formulaParams.getColumnParams()) {
            index = FormulaHelper.getAccountConfigEntryIndex(this.configInfo, columnInfo2.getName());
            if (index < 0) {
                this.checkFieldsVolid = false;
                return;
            }
            columnInfo2.setSeq(index);
            if (!columnInfo2.isSum()) continue;
            this.groupAndSumColumns.add(columnInfo2);
        }
    }

    @Override
    protected void doExecute() throws BOSException, EASBizException {
        TaxDraftRecordInfo accountInfo = this.loadReport();
        if (accountInfo == null) {
            return;
        }
        if (!this.checkFieldsVolid) {
            return;
        }
        Book book = FormulaHelper.initBook(this.ctx, accountInfo);
        if (book == null) {
            return;
        }
        Sheet sheet = book.getSheet(this.formulaParams.getSheetName());
        if (sheet == null) {
            return;
        }
        Object[][] sheetData = FormulaHelper.getSheetData(sheet, this.configInfo);
        if (sheetData == null || sheetData.length == 0) {
            return;
        }
        this.volidData = FormulaHelper.getVolidData(this.ctx, this.configInfo, sheetData, this.formulaParams.getFormula(), this.formulaParams.getFormulaMask());
        if (this.volidData.size() == 0) {
            return;
        }
        if (this.formulaParams.isSumFormula()) {
            this.sumValueMap = this.calculateSum();
        }
    }

    @Override
    protected void afterExecute() throws BOSException, EASBizException {
        this.setReturnValue();
    }

    private void setReturnValue() {
        int i;
        if (this.period == null) {
            return;
        }
        List<Object> dataList = new ArrayList();
        if (this.formulaParams.isSumFormula()) {
            String dimKey = null;
            String[] keys = null;
            ArrayList<Object> rowData = new ArrayList<Object>();
            Object var5_5 = null;
            for (Map.Entry<String, BigDecimal[]> entry : this.sumValueMap.entrySet()) {
                dimKey = entry.getKey();
                rowData = new ArrayList();
                keys = dimKey.split("_\\$\\$_");
                for (int i2 = 0; i2 < this.groupColumns.size(); ++i2) {
                    rowData.add(FormulaHelper.getFieldDimValueObject(keys[i2], this.groupColumns.get(i2)));
                }
                rowData.addAll(Arrays.asList((Object[])entry.getValue()));
                dataList.add(rowData.toArray());
            }
        } else {
            dataList = this.volidData;
        }
        if (this.sortColumns != null && this.sortColumns.size() > 0) {
            List<AccountFormulaColumnParams> dataColumns = this.formulaParams.getColumnParams();
            if (this.formulaParams.isSumFormula()) {
                dataColumns = this.groupAndSumColumns;
            }
            Collections.sort(dataList, new AccountFormulaComparable(this.sortColumns, dataColumns));
        }
        ArrayList<Object[]> resultList = new ArrayList<Object[]>();
        List<AccountFormulaColumnParams> headers = this.headColumns;
        AccountFormulaColumnParams columnParams = null;
        Object var5_8 = null;
        Object[] tmpData = null;
        int index = -1;
        int headSize = headers.size();
        for (Object[] objectArray : dataList) {
            tmpData = new Object[headSize + this.hideColumns.size()];
            int size = headers.size();
            for (i = 0; i < size; ++i) {
                columnParams = headers.get(i);
                index = this.formulaParams.isSumFormula() ? FormulaHelper.getColumnIndex(this.groupAndSumColumns, columnParams) : columnParams.getSeq();
                tmpData[i] = objectArray[index];
            }
            size = this.hideColumns.size();
            for (i = 0; i < size; ++i) {
                columnParams = this.hideColumns.get(i);
                index = this.formulaParams.isSumFormula() ? FormulaHelper.getColumnIndex(this.groupAndSumColumns, columnParams) : columnParams.getSeq();
                tmpData[headSize + i] = objectArray[index];
            }
            resultList.add(tmpData);
        }
        Object[][] data = new Object[resultList.size()][headers.size()];
        for (i = 0; i < resultList.size(); ++i) {
            data[i] = (Object[])resultList.get(i);
        }
        this.result.put("headers", headers);
        this.result.put("hideColumns", this.hideColumns);
        this.result.put("data", data);
        this.result.put("isSumFormula", this.formulaParams.isSumFormula());
        this.result.put("isColumnMatch", this.formulaParams.isColumnMatch());
    }

    private Map calculateSum() throws TDException {
        Object[] rowData = null;
        String dimkey = "";
        HashMap<String, BigDecimal[]> valueMap = new HashMap<String, BigDecimal[]>();
        BigDecimal[] values = null;
        BigDecimal[] tempValues = null;
        Object value = null;
        Iterator<Object[]> it = this.volidData.iterator();
        while (it.hasNext()) {
            int i;
            dimkey = "";
            rowData = it.next();
            for (i = 0; i < this.groupColumns.size(); ++i) {
                if (i != 0) {
                    dimkey = dimkey + "_$$_";
                }
                value = rowData[this.groupColumns.get(i).getSeq()];
                dimkey = dimkey + FormulaHelper.getFieldDimValue(value, this.groupColumns.get(i).getDataType());
            }
            values = new BigDecimal[this.sumColumns.size()];
            for (i = 0; i < this.sumColumns.size(); ++i) {
                try {
                    values[i] = FormulaHelper.getBigDecimalValue(rowData[this.sumColumns.get(i).getSeq()]);
                    continue;
                }
                catch (NumberFormatException e) {
                    String numberFormatError = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "SumColumNumberError", this.ctx.getLocale(), new Object[]{this.formulaParams.getAnalysisRange(), this.sumColumns.get(i).getAlias()});
                    throw new TDException(TDException.ERROR_MSG, new Object[]{numberFormatError});
                }
            }
            if (!valueMap.containsKey(dimkey)) {
                valueMap.put(dimkey, values);
                continue;
            }
            tempValues = (BigDecimal[])valueMap.get(dimkey);
            valueMap.put(dimkey, FormulaHelper.arrayElemSum(values, tempValues));
        }
        return valueMap;
    }

    private TaxDraftRecordInfo loadReport() throws EASBizException, BOSException {
        String groupID;
        String taxTypeID;
        if (this.period == null) {
            return null;
        }
        String companyID = this.formulaParams.getCompanyID();
        if (StringUtils.isEmpty((String)companyID)) {
            companyID = ((CompanyOrgUnitInfo)this.reportInfo.get("companyOrgUnit")).getId().toString();
        }
        if (StringUtils.isEmpty((String)(taxTypeID = this.formulaParams.getTaxTypeID())) && this.reportInfo.get("taxType") != null) {
            taxTypeID = ((TaxItemTypeInfo)this.reportInfo.get("taxType")).getId().toString();
        }
        if (StringUtils.isEmpty((String)(groupID = this.formulaParams.getGroupID())) && this.reportInfo.get("buildingTaxesGroup") != null) {
            groupID = ((RealEstateGroupInfo)this.reportInfo.get("buildingTaxesGroup")).getId().toString();
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> paramList = new ArrayList<Object>();
        sql.append(" SELECT t.fid as FRptID from T_TD_TaxDraftRecord t");
        sql.append(" left join T_BD_Period rptPeriod on rptPeriod.fid = t.FRptPeriod");
        sql.append(" left join T_ORG_Company company on company.fid = t.FCompanyOrgUnitID");
        sql.append(" left join T_TM_TaxItemType taxItemType on taxItemType.fid = t.FTaxTypeID");
        sql.append(" left join T_TM_AccountConfig account on account.fid = t.FRelateAccountID");
        sql.append(" left join T_TD_RealEstateGroup estGroup on estGroup.fid = t.FBuildingTaxesGroupID");
        sql.append(" where rptPeriod.fid = ?");
        paramList.add(this.period.getId().toString());
        sql.append(" and t.FRecordType = ?");
        paramList.add(0);
        sql.append(" and company.fid = ?");
        paramList.add(companyID);
        if (!StringUtils.isEmpty((String)taxTypeID)) {
            sql.append(" and taxItemType.fid = ?");
            paramList.add(taxTypeID);
        }
        sql.append(" and account.fid = ?");
        paramList.add(this.configInfo.getId().toString());
        if (!StringUtils.isEmpty((String)groupID)) {
            sql.append(" and estGroup.fid = ?");
            paramList.add(groupID);
        } else {
            sql.append(" and estGroup.fid is null");
        }
        sql.append(" order by t.FDraftRecordType desc");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])paramList.toArray());
        String rptID = null;
        try {
            if (rs.next()) {
                rptID = rs.getString("FRptID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        TaxDraftRecordInfo reportInfo = null;
        if (!StringUtils.isEmpty((String)rptID)) {
            reportInfo = TaxDraftRecordFactory.getLocalInstance(this.ctx).getTaxDraftRecordInfo((IObjectPK)new ObjectUuidPK(rptID), TDSelectorFactory.getAllReportSelectors());
        }
        return reportInfo;
    }
}

